/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.OrderedPropertyValues;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.RepeatRule;

public class TxStateTest {
    public final RandomRule random = new RandomRule();
    private final IndexDescriptor indexOn_1_1 = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    private final IndexDescriptor indexOn_1_2 = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
    private final IndexDescriptor indexOn_2_1 = IndexDescriptorFactory.forLabel((int)2, (int[])new int[]{1});
    private TransactionState state;

    @Rule
    public final TestRule repeatWithDifferentRandomization() {
        return RuleChain.outerRule((TestRule)new RepeatRule()).around((TestRule)this.random);
    }

    @Test
    public void shouldGetAddedLabels() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(2, 1L);
        Set addedLabels = this.state.nodeStateLabelDiffSets(1L).getAdded();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{1, 2}), (Object)addedLabels);
    }

    @Test
    public void shouldGetRemovedLabels() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(2, 1L);
        Set removedLabels = this.state.nodeStateLabelDiffSets(1L).getRemoved();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{1, 2}), (Object)removedLabels);
    }

    @Test
    public void removeAddedLabelShouldRemoveFromAdded() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(2, 1L);
        this.state.nodeDoRemoveLabel(1, 1L);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{2}), (Object)this.state.nodeStateLabelDiffSets(1L).getAdded());
    }

    @Test
    public void addRemovedLabelShouldRemoveFromRemoved() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(2, 1L);
        this.state.nodeDoAddLabel(1, 1L);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{2}), (Object)this.state.nodeStateLabelDiffSets(1L).getRemoved());
    }

    @Test
    public void shouldMapFromRemovedLabelToNodes() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(2, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(3, 1L);
        this.state.nodeDoRemoveLabel(2, 2L);
        Set nodes = this.state.nodesWithLabelChanged(2).getRemoved();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{0L, 2L}), (Object)Iterables.asSet((Iterable)nodes));
    }

    @Test
    public void shouldAddAndGetByLabel() throws Exception {
        this.state.indexRuleDoAdd(this.indexOn_1_1);
        this.state.indexRuleDoAdd(this.indexOn_2_1);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{this.indexOn_1_1}), (Object)this.state.indexDiffSetsByLabel(this.indexOn_1_1.schema().getLabelId()).getAdded());
    }

    @Test
    public void shouldAddAndGetByRuleId() throws Exception {
        this.state.indexRuleDoAdd(this.indexOn_1_1);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{this.indexOn_1_1}), (Object)this.state.indexChanges().getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForScanOrSeekOnAnEmptyTxState() throws Exception {
        ReadableDiffSets diffSets = this.state.indexUpdatesForScan(this.indexOn_1_1);
        Assert.assertTrue((boolean)diffSets.isEmpty());
    }

    @Test
    public void shouldComputeIndexUpdatesForScanWhenThereAreNewNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L, 43L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForScan(this.indexOn_1_1);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForSeekWhenThereAreNewNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L, 43L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForSeek(this.indexOn_1_1, OrderedPropertyValues.ofUndefined((Object[])new Object[]{"value43"}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWhenThereAreNoMatchingNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)550)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)44L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)660, false, (Number)800, true);
        Assert.assertEquals(Collections.emptySet(), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWhenThereAreNewNodesCreatedInSingleBatch() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)550)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)44L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, true, (Number)600, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWhenThereAreNewNodesCreatedInTwoBatches() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Collections.singletonList(Pair.of((Object)42L, (Object)500)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)44L, (Object)520)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Collections.singletonList(Pair.of((Object)43L, (Object)550)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, true, (Number)600, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, true, (Number)550, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, true, (Number)550, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, false, (Number)550, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, false, (Number)550, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedLowerExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, false, (Number)550, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedLowerIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, true, (Number)550, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedLowerExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, false, (Number)550, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedLowerIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, true, (Number)550, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedUpperIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)540, true, null, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{47L, 48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedUpperIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)540, true, null, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{47L, 48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedUpperExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)540, false, null, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedUpperExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)540, false, null, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithNoBounds() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, true, null, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWhenThereAreNoMatchingNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Barbara")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)44L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Cindy", false, "William", true);
        Assert.assertEquals(Collections.emptySet(), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWhenThereAreNewNodesCreatedInSingleBatch() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Barbara")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)44L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", true, "Cathy", true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWhenThereAreNewNodesCreatedInTwoBatches() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Collections.singletonList(Pair.of((Object)42L, (Object)"Agatha")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)44L, (Object)"Andreas")));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Collections.singletonList(Pair.of((Object)43L, (Object)"Barbara")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", true, "Cathy", true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", true, "Arwen", true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", true, "Arwen", false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", false, "Arwen", true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", false, "Arwen", false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedLowerExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, false, "Arwen", true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedLowerIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, true, "Arwen", true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedLowerExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, false, "Arwen", false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedLowerIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, true, "Arwen", false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedUpperIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Arthur", true, null, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{47L, 48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedUpperIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Arthur", true, null, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{47L, 48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedUpperExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Arthur", false, null, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedUpperExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Arthur", false, null, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithNoBounds() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, true, null, true);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L, 44L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNoMatchingNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L, 43L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "eulav");
        Assert.assertEquals(Collections.emptySet(), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNewNodesCreatedInOneBatch() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L, 43L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "value");
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereArePartiallyMatchingNewNodes1() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)40L, (Object)"Aaron"), Pair.of((Object)41L, (Object)"Agatha"), Pair.of((Object)42L, (Object)"Andreas"), Pair.of((Object)43L, (Object)"Andrea"), Pair.of((Object)44L, (Object)"Aristotle"), Pair.of((Object)45L, (Object)"Barbara"), Pair.of((Object)46L, (Object)"Barbarella"), Pair.of((Object)47L, (Object)"Cinderella")));
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "And");
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereArePartiallyMatchingNewNodes2() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)40L, (Object)"Aaron"), Pair.of((Object)41L, (Object)"Agatha"), Pair.of((Object)42L, (Object)"Andreas"), Pair.of((Object)43L, (Object)"Andrea"), Pair.of((Object)44L, (Object)"Aristotle"), Pair.of((Object)45L, (Object)"Barbara"), Pair.of((Object)46L, (Object)"Barbarella"), Pair.of((Object)47L, (Object)"Cinderella")));
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "Bar");
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{45L, 46L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereArePartiallyMatchingLeadingNewNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)40L, (Object)"Aaron"), Pair.of((Object)41L, (Object)"Agatha"), Pair.of((Object)42L, (Object)"Andreas"), Pair.of((Object)43L, (Object)"Andrea"), Pair.of((Object)44L, (Object)"Aristotle"), Pair.of((Object)45L, (Object)"Barbara"), Pair.of((Object)46L, (Object)"Barbarella"), Pair.of((Object)47L, (Object)"Cinderella")));
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "Aa");
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{40L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereArePartiallyMatchingTrailingNewNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)40L, (Object)"Aaron"), Pair.of((Object)41L, (Object)"Agatha"), Pair.of((Object)42L, (Object)"Andreas"), Pair.of((Object)43L, (Object)"Andrea"), Pair.of((Object)44L, (Object)"Aristotle"), Pair.of((Object)45L, (Object)"Barbara"), Pair.of((Object)46L, (Object)"Barbarella"), Pair.of((Object)47L, (Object)"Cinderella")));
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "Ci");
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNewNodesCreatedInTwoBatches() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(43L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "value");
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldListNodeAsDeletedIfItIsDeleted() throws Exception {
        long nodeId = 1337L;
        this.state.nodeDoDelete(nodeId);
        Assert.assertThat((Object)Iterables.asSet((Iterable)this.state.addedAndRemovedNodes().getRemoved()), (Matcher)IsEqual.equalTo((Object)Iterators.asSet((Object[])new Long[]{nodeId})));
    }

    @Test
    public void shouldAddUniquenessConstraint() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint, 7L);
        ReadableDiffSets diff = this.state.constraintsChangesForLabel(1);
        Assert.assertEquals(Collections.singleton(constraint), (Object)diff.getAdded());
        Assert.assertTrue((boolean)diff.getRemoved().isEmpty());
    }

    @Test
    public void addingUniquenessConstraintShouldBeIdempotent() throws Exception {
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint1, 7L);
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint2, 19L);
        Assert.assertEquals((Object)constraint1, (Object)constraint2);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
    }

    @Test
    public void shouldDifferentiateBetweenUniquenessConstraintsForDifferentLabels() throws Exception {
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint1, 7L);
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint2, 19L);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
        Assert.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForLabel(2).getAdded());
    }

    @Test
    public void shouldAddRelationshipPropertyExistenceConstraint() {
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint);
        Assert.assertEquals(Collections.singleton(constraint), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
    }

    @Test
    public void addingRelationshipPropertyExistenceConstraintConstraintShouldBeIdempotent() {
        RelExistenceConstraintDescriptor constraint1 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        RelExistenceConstraintDescriptor constraint2 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint1);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint2);
        Assert.assertEquals((Object)constraint1, (Object)constraint2);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
    }

    @Test
    public void shouldDropRelationshipPropertyExistenceConstraint() {
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint);
        this.state.constraintDoDrop((ConstraintDescriptor)constraint);
        Assert.assertTrue((boolean)this.state.constraintsChangesForRelationshipType(1).isEmpty());
    }

    @Test
    public void shouldDifferentiateRelationshipPropertyExistenceConstraints() throws Exception {
        RelExistenceConstraintDescriptor constraint1 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{11});
        RelExistenceConstraintDescriptor constraint2 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{22});
        RelExistenceConstraintDescriptor constraint3 = ConstraintDescriptorFactory.existsForRelType((int)3, (int[])new int[]{33});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint1);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint2);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint3);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1, constraint2}), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForSchema(constraint1.schema()).getAdded());
        Assert.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForSchema(constraint2.schema()).getAdded());
        Assert.assertEquals(Collections.singleton(constraint3), (Object)this.state.constraintsChangesForRelationshipType(3).getAdded());
        Assert.assertEquals(Collections.singleton(constraint3), (Object)this.state.constraintsChangesForSchema(constraint3.schema()).getAdded());
    }

    @Test
    public void shouldListRelationshipsAsCreatedIfCreated() throws Exception {
        long relId = 10L;
        this.state.relationshipDoCreate(relId, 0, 1L, 2L);
        Assert.assertTrue((boolean)this.state.hasChanges());
        Assert.assertTrue((boolean)this.state.relationshipIsAddedInThisTx(relId));
    }

    @Test
    public void shouldGiveCorrectDegreeWhenAddingAndRemovingRelationships() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        this.state.relationshipDoCreate(10L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(11L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(12L, relType + 1, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(13L, relType + 1, (long)endNode, (long)startNode);
        this.state.relationshipDoDelete(1337L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(1338L, relType + 1, (long)startNode, (long)startNode);
        Assert.assertEquals((long)12L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.BOTH));
        Assert.assertEquals((long)10L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.INCOMING));
        Assert.assertEquals((long)11L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.BOTH, relType));
    }

    @Test
    public void shouldGiveCorrectRelationshipTypesForNode() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        long relA = 10L;
        long relB = 11L;
        long relC = 12L;
        this.state.relationshipDoCreate(relA, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relB, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relC, relType + 1, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relB, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relC, relType + 1, (long)startNode, (long)endNode);
        Assert.assertThat((Object)PrimitiveIntCollections.toList((PrimitiveIntIterator)this.state.nodeRelationshipTypes((long)startNode).iterator()), (Matcher)IsEqual.equalTo(Arrays.asList(relType)));
    }

    @Test
    public void shouldNotChangeRecordForCreatedAndDeletedNode() throws Exception {
        this.state.nodeDoCreate(0L);
        this.state.nodeDoDelete(0L);
        this.state.nodeDoCreate(1L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedNode(long id) {
                Assert.assertEquals((String)"Should not create any other node than 1", (long)1L, (long)id);
            }

            public void visitDeletedNode(long id) {
                Assert.fail((String)"Should not delete any node");
            }
        });
    }

    @Test
    public void shouldVisitDeletedNode() throws Exception {
        this.state.nodeDoDelete(42L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitDeletedNode(long id) {
                Assert.assertEquals((String)"Wrong deleted node id", (long)42L, (long)id);
            }
        });
    }

    @Test
    public void shouldReportDeletedNodeIfItWasCreatedAndDeletedInSameTx() {
        long nodeId = 42L;
        this.state.nodeDoCreate(nodeId);
        this.state.nodeDoDelete(nodeId);
        Assert.assertTrue((boolean)this.state.nodeIsDeletedInThisTx(nodeId));
    }

    @Test
    public void shouldNotReportDeletedNodeIfItIsNotDeleted() {
        long nodeId = 42L;
        this.state.nodeDoCreate(nodeId);
        Assert.assertFalse((boolean)this.state.nodeIsDeletedInThisTx(nodeId));
    }

    @Test
    public void shouldNotChangeRecordForCreatedAndDeletedRelationship() throws Exception {
        this.state.relationshipDoCreate(0L, 0, 1L, 2L);
        this.state.relationshipDoDelete(0L, 0, 1L, 2L);
        this.state.relationshipDoCreate(1L, 0, 2L, 3L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                Assert.assertEquals((String)"Should not create any other relationship than 1", (long)1L, (long)id);
            }

            public void visitDeletedRelationship(long id) {
                Assert.fail((String)"Should not delete any relationship");
            }
        });
    }

    @Test
    public void shouldVisitDeletedRelationship() throws Exception {
        this.state.relationshipDoDelete(42L, 2, 3L, 4L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitDeletedRelationship(long id) {
                Assert.assertEquals((String)"Wrong deleted relationship id", (long)42L, (long)id);
            }
        });
    }

    @Test
    public void shouldReportDeletedRelationshipIfItWasCreatedAndDeletedInSameTx() {
        long startNodeId = 1L;
        long relationshipId = 2L;
        int relationshipType = 3;
        long endNodeId = 4L;
        this.state.relationshipDoCreate(relationshipId, relationshipType, startNodeId, endNodeId);
        this.state.relationshipDoDelete(relationshipId, relationshipType, startNodeId, endNodeId);
        Assert.assertTrue((boolean)this.state.relationshipIsDeletedInThisTx(relationshipId));
    }

    @Test
    public void shouldNotReportDeletedRelationshipIfItIsNotDeleted() {
        long startNodeId = 1L;
        long relationshipId = 2L;
        int relationshipType = 3;
        long endNodeId = 4L;
        this.state.relationshipDoCreate(relationshipId, relationshipType, startNodeId, endNodeId);
        Assert.assertFalse((boolean)this.state.relationshipIsDeletedInThisTx(relationshipId));
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedNodesBeforeDeletedNodes() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedNodesBeforeCreatedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedRelationshipsBeforeDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoDelete((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitEarly();
            }

            public void visitDeletedRelationship(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitDeletedNodesAfterDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitDeletedRelationship(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    public void shouldObserveCorrectAugmentedNodeRelationshipsState() throws Exception {
        int i;
        int i2;
        TxState state = new TxState();
        for (i2 = 0; i2 < 100; ++i2) {
            state.nodeDoCreate((long)i2);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            state.relationshipTypeDoCreateForName("Type-" + i2, i2);
        }
        HashMap<Long, RelationshipItem> committedRelationships = new HashMap<Long, RelationshipItem>();
        long relationshipId = 0L;
        int nodeCount = 100;
        int relationshipTypeCount = 5;
        for (int i3 = 0; i3 < 30; ++i3) {
            RelationshipItem relationship = StubCursors.relationship(relationshipId++, this.random.nextInt(relationshipTypeCount), this.random.nextInt(nodeCount), this.random.nextInt(nodeCount));
            committedRelationships.put(relationship.id(), relationship);
        }
        HashMap<Long, RelationshipItem> allRelationships = new HashMap<Long, RelationshipItem>(committedRelationships);
        for (i = 0; i < 10; ++i) {
            RelationshipItem relationship;
            if (this.random.nextBoolean()) {
                relationship = StubCursors.relationship(relationshipId++, this.random.nextInt(relationshipTypeCount), this.random.nextInt(nodeCount), this.random.nextInt(nodeCount));
                allRelationships.put(relationship.id(), relationship);
                state.relationshipDoCreate(relationship.id(), relationship.type(), relationship.startNode(), relationship.endNode());
                continue;
            }
            relationship = (RelationshipItem)Iterables.fromEnd(committedRelationships.values(), (int)this.random.nextInt(committedRelationships.size()));
            state.relationshipDoDelete(relationship.id(), relationship.type(), relationship.startNode(), relationship.endNode());
            allRelationships.remove(relationship.id());
        }
        for (i = 0; i < nodeCount; ++i) {
            Direction direction = Direction.values()[this.random.nextInt(Direction.values().length)];
            int[] relationshipTypes = this.randomTypes(relationshipTypeCount, this.random.random());
            Cursor<RelationshipItem> committed = StubCursors.cursor(this.relationshipsForNode(i, committedRelationships, direction, relationshipTypes).values());
            Cursor augmented = relationshipTypes == null ? state.augmentNodeRelationshipCursor(committed, state.getNodeState((long)i), direction) : state.augmentNodeRelationshipCursor(committed, state.getNodeState((long)i), direction, relationshipTypes);
            Map<Long, RelationshipItem> expectedRelationships = this.relationshipsForNode(i, allRelationships, direction, relationshipTypes);
            while (augmented.next()) {
                RelationshipItem relationship = (RelationshipItem)augmented.get();
                RelationshipItem actual = expectedRelationships.remove(relationship.id());
                Assert.assertNotNull((String)("Augmented cursor returned relationship " + relationship + ", but shouldn't have"), (Object)actual);
                this.assertRelationshipEquals(actual, relationship);
            }
            Assert.assertTrue((String)("Augmented cursor didn't return some expected relationships: " + expectedRelationships), (boolean)expectedRelationships.isEmpty());
        }
    }

    private Map<Long, RelationshipItem> relationshipsForNode(long nodeId, Map<Long, RelationshipItem> allRelationships, Direction direction, int[] relationshipTypes) {
        HashMap<Long, RelationshipItem> result = new HashMap<Long, RelationshipItem>();
        block5: for (RelationshipItem relationship : allRelationships.values()) {
            switch (direction) {
                case OUTGOING: {
                    if (relationship.startNode() == nodeId) break;
                    continue block5;
                }
                case INCOMING: {
                    if (relationship.endNode() == nodeId) break;
                    continue block5;
                }
                case BOTH: {
                    if (relationship.startNode() == nodeId || relationship.endNode() == nodeId) break;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unknown direction: " + direction);
                }
            }
            if (relationshipTypes != null && !this.contains(relationshipTypes, relationship.type())) continue;
            result.put(relationship.id(), relationship);
        }
        return result;
    }

    private void assertRelationshipEquals(RelationshipItem expected, RelationshipItem relationship) {
        Assert.assertEquals((long)expected.id(), (long)relationship.id());
        Assert.assertEquals((long)expected.type(), (long)relationship.type());
        Assert.assertEquals((long)expected.startNode(), (long)relationship.startNode());
        Assert.assertEquals((long)expected.endNode(), (long)relationship.endNode());
    }

    private int[] randomTypes(int high, Random random) {
        int count = random.nextInt(high);
        if (count == 0) {
            return null;
        }
        int[] types = new int[count];
        Arrays.fill(types, -1);
        int i = 0;
        while (i < count) {
            int candidate = random.nextInt(high);
            if (this.contains(types, candidate)) continue;
            types[i++] = candidate;
        }
        return types;
    }

    private boolean contains(int[] array, int candidate) {
        for (int i : array) {
            if (i != candidate) continue;
            return true;
        }
        return false;
    }

    @Before
    public void before() throws Exception {
        this.state = new TxState();
    }

    private IndexUpdater addNodesToIndex(final IndexDescriptor descriptor) {
        return new IndexUpdater(){

            @Override
            public void withDefaultStringProperties(long ... nodeIds) {
                ArrayList<Pair<Long, String>> entries = new ArrayList<Pair<Long, String>>(nodeIds.length);
                for (long nodeId : nodeIds) {
                    entries.add((Pair<Long, String>)Pair.of((Object)nodeId, (Object)("value" + nodeId)));
                }
                this.withStringProperties(entries);
            }

            @Override
            public void withStringProperties(Collection<Pair<Long, String>> nodesWithValues) {
                int labelId = descriptor.schema().getLabelId();
                int propertyKeyId = descriptor.schema().getPropertyId();
                for (Pair<Long, String> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateTest.this.state.nodeDoCreate(nodeId);
                    TxStateTest.this.state.nodeDoAddLabel(labelId, nodeId);
                    DefinedProperty propertyAfter = Property.stringProperty((int)propertyKeyId, (String)((String)entry.other()));
                    TxStateTest.this.state.nodeDoAddProperty(nodeId, propertyAfter);
                    TxStateTest.this.state.indexDoUpdateEntry(descriptor.schema(), nodeId, null, OrderedPropertyValues.ofUndefined((Object[])new Object[]{propertyAfter.value()}));
                }
            }

            @Override
            public <T extends Number> void withNumberProperties(Collection<Pair<Long, T>> nodesWithValues) {
                int labelId = descriptor.schema().getLabelId();
                int propertyKeyId = descriptor.schema().getPropertyId();
                for (Pair<Long, T> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateTest.this.state.nodeDoCreate(nodeId);
                    TxStateTest.this.state.nodeDoAddLabel(labelId, nodeId);
                    DefinedProperty propertyAfter = Property.numberProperty((int)propertyKeyId, (Number)((Number)entry.other()));
                    TxStateTest.this.state.nodeDoAddProperty(nodeId, propertyAfter);
                    TxStateTest.this.state.indexDoUpdateEntry(descriptor.schema(), nodeId, null, OrderedPropertyValues.ofUndefined((Object[])new Object[]{propertyAfter.value()}));
                }
            }

            @Override
            public void withBooleanProperties(Collection<Pair<Long, Boolean>> nodesWithValues) {
                int labelId = descriptor.schema().getLabelId();
                int propertyKeyId = descriptor.schema().getPropertyId();
                for (Pair<Long, Boolean> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateTest.this.state.nodeDoCreate(nodeId);
                    TxStateTest.this.state.nodeDoAddLabel(labelId, nodeId);
                    DefinedProperty propertyAfter = Property.booleanProperty((int)propertyKeyId, (boolean)((Boolean)entry.other()));
                    TxStateTest.this.state.nodeDoAddProperty(nodeId, propertyAfter);
                    TxStateTest.this.state.indexDoUpdateEntry(descriptor.schema(), nodeId, null, OrderedPropertyValues.ofUndefined((Object[])new Object[]{propertyAfter.value()}));
                }
            }
        };
    }

    private static interface IndexUpdater {
        public void withDefaultStringProperties(long ... var1);

        public void withStringProperties(Collection<Pair<Long, String>> var1);

        public <T extends Number> void withNumberProperties(Collection<Pair<Long, T>> var1);

        public void withBooleanProperties(Collection<Pair<Long, Boolean>> var1);
    }

    abstract class VisitationOrder
    extends TxStateVisitor.Adapter {
        private final Set<String> visitMethods = new HashSet<String>();
        private boolean late;

        VisitationOrder(int size) {
            for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
                if (!method.getName().startsWith("visit")) continue;
                this.visitMethods.add(method.getName());
            }
            Assert.assertEquals((String)"should implement exactly two visit*(...) methods", (long)2L, (long)this.visitMethods.size());
            do {
                if (TxStateTest.this.random.nextBoolean()) {
                    this.createEarlyState();
                    continue;
                }
                this.createLateState();
            } while (size-- > 0);
        }

        abstract void createEarlyState();

        abstract void createLateState();

        final void visitEarly() {
            if (this.late) {
                String early = "the early visit*-method";
                String late = "the late visit*-method";
                for (StackTraceElement trace : Thread.currentThread().getStackTrace()) {
                    if (!this.visitMethods.contains(trace.getMethodName())) continue;
                    early = trace.getMethodName();
                    for (String method : this.visitMethods) {
                        if (method.equals(early)) continue;
                        late = method;
                    }
                    break;
                }
                Assert.fail((String)(early + "(...) should not be invoked after " + late + "(...)"));
            }
        }

        final void visitLate() {
            this.late = true;
        }
    }
}

