/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.api.store.CursorRelationshipIterator;
import org.neo4j.kernel.impl.util.collection.ContinuableArrayCursor;
import org.neo4j.storageengine.api.RelationshipItem;

public class CursorRelationshipIteratorTest {
    @Test
    public void shouldLazilyGoToNext() throws Exception {
        Cursor cursor = (Cursor)Mockito.spy((Object)new ContinuableArrayCursor((Supplier)new Supplier<RelationshipItem[]>(){
            private boolean first = true;

            @Override
            public RelationshipItem[] get() {
                if (this.first) {
                    this.first = false;
                    return new RelationshipItem[]{(RelationshipItem)Mockito.mock(RelationshipItem.class), (RelationshipItem)Mockito.mock(RelationshipItem.class)};
                }
                return null;
            }
        }));
        try (CursorRelationshipIterator iterator = new CursorRelationshipIterator(cursor);){
            Mockito.verifyZeroInteractions((Object[])new Object[]{cursor});
            Assert.assertTrue((boolean)iterator.hasNext());
            ((Cursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)1))).next();
            iterator.next();
            ((Cursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)1))).next();
            Assert.assertTrue((boolean)iterator.hasNext());
            ((Cursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)2))).next();
            iterator.next();
            ((Cursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)2))).next();
            Assert.assertFalse((boolean)iterator.hasNext());
            ((Cursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)3))).next();
        }
    }
}

