/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.impl.api.store.StorageLayerTest;

public class StorageLayerSchemaTest
extends StorageLayerTest {
    @Test
    public void shouldListAllConstraints() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label2, "name");
        Set constraints = Iterators.asSet((Iterator)this.disk.constraintsGetAll());
        Set expectedConstraints = Iterators.asSet((Object[])new ConstraintDescriptor[]{this.uniqueConstraintDescriptor(this.label1, "name"), this.uniqueConstraintDescriptor(this.label2, "name")});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    @Test
    public void shouldListAllConstraintsForLabel() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label2, "name");
        Set constraints = Iterators.asSet((Iterator)this.disk.constraintsGetForLabel(this.labelId(this.label1)));
        Set expectedConstraints = Iterators.asSet((Object[])new ConstraintDescriptor[]{this.uniqueConstraintDescriptor(this.label1, "name")});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    @Test
    public void shouldListAllConstraintsForLabelAndProperty() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label1, "age");
        Set constraints = Iterators.asSet((Iterator)this.disk.constraintsGetForSchema(this.uniqueConstraintDescriptor(this.label1, "name").schema()));
        Set expectedConstraints = Iterators.asSet((Object[])new ConstraintDescriptor[]{this.uniqueConstraintDescriptor(this.label1, "name")});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    private void createUniquenessConstraint(Label label, String propertyKey) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
        }
    }

    private ConstraintDescriptor uniqueConstraintDescriptor(Label label, String propertyKey) {
        int labelId = this.labelId(label);
        int propKeyId = this.propertyKeyId(propertyKey);
        return ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propKeyId});
    }
}

