/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class GraphDatabaseFacadeTest {
    private GraphDatabaseFacade.SPI spi = (GraphDatabaseFacade.SPI)Mockito.mock(GraphDatabaseFacade.SPI.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private GraphDatabaseFacade graphDatabaseFacade = new GraphDatabaseFacade();
    private GraphDatabaseQueryService queryService;

    @Before
    public void setUp() {
        this.queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Statement statement = (Statement)Mockito.mock(Statement.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ThreadToStatementContextBridge contextBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        Mockito.when((Object)this.spi.queryService()).thenReturn((Object)this.queryService);
        Mockito.when((Object)this.spi.resolver()).thenReturn((Object)resolver);
        Mockito.when((Object)resolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)contextBridge);
        Mockito.when((Object)resolver.resolveDependency(Guard.class)).thenReturn(Mockito.mock(Guard.class));
        Mockito.when((Object)contextBridge.get()).thenReturn((Object)statement);
        Mockito.when((Object)resolver.resolveDependency(Config.class)).thenReturn((Object)Config.embeddedDefaults((ConfigurationValidator[])new ConfigurationValidator[0]));
        this.graphDatabaseFacade.init(this.spi);
    }

    @Test
    public void beginTransactionWithCustomTimeout() throws Exception {
        this.graphDatabaseFacade.beginTx(10L, TimeUnit.MILLISECONDS);
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi)).beginTransaction(KernelTransaction.Type.explicit, SecurityContext.AUTH_DISABLED, 10L);
    }

    @Test
    public void beginTransaction() {
        this.graphDatabaseFacade.beginTx();
        long timeout = ((Duration)Config.embeddedDefaults((ConfigurationValidator[])new ConfigurationValidator[0]).get(GraphDatabaseSettings.transaction_timeout)).toMillis();
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi)).beginTransaction(KernelTransaction.Type.explicit, SecurityContext.AUTH_DISABLED, timeout);
    }

    @Test
    public void executeQueryWithCustomTimeoutShouldStartTransactionWithRequestedTimeout() {
        this.graphDatabaseFacade.execute("create (n)", 157L, TimeUnit.SECONDS);
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi)).beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, TimeUnit.SECONDS.toMillis(157L));
        this.graphDatabaseFacade.execute("create (n)", new HashMap(), 247L, TimeUnit.MINUTES);
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi)).beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, TimeUnit.MINUTES.toMillis(247L));
    }

    @Test
    public void executeQueryStartDefaultTransaction() {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        TopLevelTransaction transaction = new TopLevelTransaction(kernelTransaction, null);
        Mockito.when((Object)this.queryService.beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED)).thenReturn((Object)transaction);
        this.graphDatabaseFacade.execute("create (n)");
        this.graphDatabaseFacade.execute("create (n)", new HashMap());
        long timeout = ((Duration)Config.embeddedDefaults((ConfigurationValidator[])new ConfigurationValidator[0]).get(GraphDatabaseSettings.transaction_timeout)).toMillis();
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi, (VerificationMode)Mockito.times((int)2))).beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, timeout);
    }
}

