/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.index.labelscan.CompositeLabelScanValueIterator;

public class CompositeLabelScanValueIteratorTest {
    @Test
    public void mustHandleEmptyListOfIterators() throws Exception {
        List iterators = Collections.emptyList();
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Expected iterator to throw");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void mustHandleEmptyIterator() throws Exception {
        List<PrimitiveLongIterator> iterators = Collections.singletonList(PrimitiveLongCollections.emptyIterator());
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void mustHandleMultipleEmptyIterators() throws Exception {
        List<PrimitiveLongIterator> iterators = Arrays.asList(PrimitiveLongCollections.emptyIterator(), PrimitiveLongCollections.emptyIterator(), PrimitiveLongCollections.emptyIterator());
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void mustReportAllFromSingleIterator() throws Exception {
        long[] expected = new long[]{0L, 1L, Long.MAX_VALUE};
        List<PrimitiveLongIterator> iterators = Arrays.asList(PrimitiveLongCollections.iterator((long[])expected));
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
    }

    @Test
    public void mustReportAllFromNonOverlappingMultipleIterators() throws Exception {
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        List<PrimitiveLongIterator> iterators = Arrays.asList(PrimitiveLongCollections.iterator((long[])firstIter), PrimitiveLongCollections.iterator((long[])secondIter));
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
    }

    @Test
    public void mustReportUniqueValuesFromOverlappingIterators() throws Exception {
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] thridIter = new long[]{0L, 3L};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        List<PrimitiveLongIterator> iterators = Arrays.asList(PrimitiveLongCollections.iterator((long[])firstIter), PrimitiveLongCollections.iterator((long[])secondIter), PrimitiveLongCollections.iterator((long[])thridIter));
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
    }

    @Test
    public void mustReportUniqueValuesFromOverlappingIteratorsWithOneEmpty() throws Exception {
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] thridIter = new long[]{0L, 3L};
        long[] fourthIter = new long[]{};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        List<PrimitiveLongIterator> iterators = Arrays.asList(PrimitiveLongCollections.iterator((long[])firstIter), PrimitiveLongCollections.iterator((long[])secondIter), PrimitiveLongCollections.iterator((long[])thridIter), PrimitiveLongCollections.iterator((long[])fourthIter));
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
    }

    @Test
    public void mustOnlyReportValuesReportedByAll() throws Exception {
        long[] firstIter = new long[]{0L, Long.MAX_VALUE};
        long[] secondIter = new long[]{0L, 1L, Long.MAX_VALUE};
        long[] thridIter = new long[]{0L, 1L, 2L, Long.MAX_VALUE};
        long[] expected = new long[]{0L, Long.MAX_VALUE};
        List<PrimitiveLongIterator> iterators = Arrays.asList(PrimitiveLongCollections.iterator((long[])firstIter), PrimitiveLongCollections.iterator((long[])secondIter), PrimitiveLongCollections.iterator((long[])thridIter));
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, true);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
    }

    @Test
    public void mustOnlyReportValuesReportedByAllWithOneEmpty() throws Exception {
        long[] firstIter = new long[]{0L, Long.MAX_VALUE};
        long[] secondIter = new long[]{0L, 1L, Long.MAX_VALUE};
        long[] thridIter = new long[]{0L, 1L, 2L, Long.MAX_VALUE};
        long[] fourthIter = new long[]{};
        long[] expected = new long[]{};
        List<PrimitiveLongIterator> iterators = Arrays.asList(PrimitiveLongCollections.iterator((long[])firstIter), PrimitiveLongCollections.iterator((long[])secondIter), PrimitiveLongCollections.iterator((long[])thridIter), PrimitiveLongCollections.iterator((long[])fourthIter));
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, true);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
    }
}

