/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class LockReentrancyCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public LockReentrancyCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    public void shouldAcquireExclusiveIfClientIsOnlyOneHoldingShared() throws Exception {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void shouldRetainExclusiveLockAfterReleasingSharedLock() throws Exception {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireShared(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void shouldRetainSharedLockWhenAcquiredAfterExclusiveLock() throws Exception {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void sharedLocksShouldStack() throws Exception {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void exclusiveLocksShouldBeReentrantAndBlockOtherExclusiveLocks() throws Exception {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void exclusiveLocksShouldBeReentrantAndBlockOtherSharedLocks() throws Exception {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L);
        Future<Object> clientBLock = this.acquireShared(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void sharedLocksShouldNotReplaceExclusiveLocks() throws Exception {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireShared(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void shouldUpgradeAndDowngradeSameSharedLock() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientB.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockIdentityExplorer sharedLockExplorer = new LockIdentityExplorer((ResourceType)ResourceTypes.NODE, 1L);
        this.locks.accept((Locks.Visitor)sharedLockExplorer);
        Future<Object> exclusiveLockFuture = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, exclusiveLockFuture);
        this.clientB.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        LockIdentityExplorer releasedLockExplorer = new LockIdentityExplorer((ResourceType)ResourceTypes.NODE, 1L);
        this.locks.accept((Locks.Visitor)releasedLockExplorer);
        Assert.assertEquals((long)sharedLockExplorer.getLockIdentityHashCode(), (long)releasedLockExplorer.getLockIdentityHashCode());
    }

    private static class LockIdentityExplorer
    implements Locks.Visitor {
        private final ResourceType resourceType;
        private final long resourceId;
        private long lockIdentityHashCode;

        LockIdentityExplorer(ResourceType resourceType, long resourceId) {
            this.resourceType = resourceType;
            this.resourceId = resourceId;
        }

        public void visit(ResourceType resourceType, long resourceId, String description, long estimatedWaitTime, long lockIdentityHashCode) {
            if (this.resourceType.equals(resourceType) && this.resourceId == resourceId) {
                this.lockIdentityHashCode = lockIdentityHashCode;
            }
        }

        public long getLockIdentityHashCode() {
            return this.lockIdentityHashCode;
        }
    }
}

