/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongLongMap;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class ResourceTypesIT {
    @Test
    public void indexEntryHashing() {
        int collisions = 0;
        try (PrimitiveLongLongMap map = Primitive.offHeapLongLongMap((int)35000000);){
            int labelIdCount = 50;
            int propertyKeyIdCount = 50;
            int objectCount = 10000;
            String[] values = this.precomputeValues(objectCount);
            for (int labelId = 0; labelId < labelIdCount; ++labelId) {
                for (int propertyKeyId = 0; propertyKeyId < propertyKeyIdCount; ++propertyKeyId) {
                    for (int objectId = 0; objectId < objectCount; ++objectId) {
                        long newValue;
                        String object = values[objectId];
                        long resourceId = ResourceTypes.indexEntryResourceId((long)labelId, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propertyKeyId, (Object)object)});
                        long oldValue = map.put(resourceId, newValue = this.packValue(labelId, propertyKeyId, objectId));
                        if (oldValue == -1L) continue;
                        System.out.printf("Collision on %s: %s ~= %s%n", resourceId, this.toValueString(newValue), this.toValueString(oldValue));
                        if (++collisions <= 100) continue;
                        Assert.fail((String)"This hashing is terrible!");
                    }
                }
            }
        }
        Assert.assertThat((Object)collisions, (Matcher)Matchers.is((Object)0));
    }

    private long packValue(int labelId, int propertyKeyId, int objectId) {
        long result = labelId;
        result <<= 16;
        result += (long)propertyKeyId;
        result <<= 32;
        return result += (long)objectId;
    }

    private String toValueString(long value) {
        int objectId = (int)(value & 0xFFFFFFFFL);
        int propertyKeyId = (int)((value & 0xFFFF00000000L) >>> 32);
        int labelId = (int)((value & 0xFFFF000000000000L) >>> 48);
        return String.format("IndexEntry{ labelId=%s, propertyKeyId=%s, objectId=%s }", labelId, propertyKeyId, objectId);
    }

    private String[] precomputeValues(int objectCount) {
        String[] values = new String[objectCount];
        for (int i = 0; i < objectCount; ++i) {
            values[i] = "" + i;
        }
        return values;
    }
}

