/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.JarBuilder;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ProcedureJarLoader;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class ProcedureJarLoaderTest {
    @Rule
    public TemporaryFolder tmpdir = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Log log = (Log)Mockito.mock(Log.class);
    private final ProcedureJarLoader jarloader = new ProcedureJarLoader(new ReflectiveProcedureCompiler(new TypeMappers(), new ComponentRegistry(), this.registryWithUnsafeAPI(), this.log, this.procedureConfig()), (Log)NullLog.getInstance());

    @Test
    public void shouldLoadProcedureFromJar() throws Throwable {
        URL jar = this.createJarFor(ClassWithOneProcedure.class);
        List procedures = this.jarloader.loadProcedures(jar).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.contains((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
        Assert.assertThat((Object)Iterators.asList((RawIterator)((CallableProcedure)procedures.get(0)).apply((Context)new BasicContext(), new Object[0])), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{1337L})));
    }

    @Test
    public void shouldLoadProcedureWithArgumentFromJar() throws Throwable {
        URL jar = this.createJarFor(ClassWithProcedureWithArgument.class);
        List procedures = this.jarloader.loadProcedures(jar).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.contains((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).in("value", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
        Assert.assertThat((Object)Iterators.asList((RawIterator)((CallableProcedure)procedures.get(0)).apply((Context)new BasicContext(), new Object[]{42L})), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{42L})));
    }

    @Test
    public void shouldLoadProcedureFromJarWithMultipleProcedureClasses() throws Throwable {
        URL jar = this.createJarFor(ClassWithOneProcedure.class, ClassWithAnotherProcedure.class, ClassWithNoProcedureAtAll.class);
        List procedures = this.jarloader.loadProcedures(jar).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.containsInAnyOrder((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myOtherProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build(), ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
    }

    @Test
    public void shouldGiveHelpfulErrorOnInvalidProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithOneProcedure.class, ClassWithInvalidProcedure.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `boolean`, you could define a record class like:%npublic class Output '{'%n    public boolean out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", new Object[0]));
        this.jarloader.loadProcedures(jar);
    }

    @Test
    public void shouldLoadProceduresFromDirectory() throws Throwable {
        this.createJarFor(ClassWithOneProcedure.class);
        this.createJarFor(ClassWithAnotherProcedure.class);
        List procedures = this.jarloader.loadProceduresFromDir(this.tmpdir.getRoot()).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.containsInAnyOrder((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myOtherProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build(), ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
    }

    @Test
    public void shouldGiveHelpfulErrorOnWildCardProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithWildCardStream.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a Stream<?>.", new Object[0]));
        this.jarloader.loadProcedures(jar);
    }

    @Test
    public void shouldGiveHelpfulErrorOnRawStreamProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithRawStream.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a raw Stream.", new Object[0]));
        this.jarloader.loadProcedures(jar);
    }

    @Test
    public void shouldGiveHelpfulErrorOnGenericStreamProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithGenericStream.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a parameterized type such as java.util.List<org.neo4j.kernel.impl.proc.ProcedureJarLoaderTest$Output>.", new Object[0]));
        this.jarloader.loadProcedures(jar);
    }

    @Test
    public void shouldGiveHelpfulLogOnUnsafeRestrictedProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithUnsafeComponent.class);
        this.jarloader.loadProcedures(jar);
        ((Log)Mockito.verify((Object)this.log)).warn("org.neo4j.kernel.impl.proc.unsafeProcedure is not available due to having restricted access rights, check configuration.");
        ((Log)Mockito.verify((Object)this.log)).warn("org.neo4j.kernel.impl.proc.unsafeFunction is not available due to having restricted access rights, check configuration.");
    }

    @Test
    public void shouldLoadUnsafeAllowedProcedureFromJar() throws Throwable {
        URL jar = this.createJarFor(ClassWithUnsafeConfiguredComponent.class);
        ProcedureJarLoader.Callables callables = this.jarloader.loadProcedures(jar);
        List functions = callables.functions();
        List procedures = callables.procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.contains((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "unsafeFullAccessProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
        Assert.assertThat((Object)Iterators.asList((RawIterator)((CallableProcedure)procedures.get(0)).apply((Context)new BasicContext(), new Object[0])), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{7331L})));
        List functionsSignatures = functions.stream().map(CallableUserFunction::signature).collect(Collectors.toList());
        Assert.assertThat(functionsSignatures, (Matcher)Matchers.contains((Object[])new UserFunctionSignature[]{UserFunctionSignature.functionSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "unsafeFullAccessFunction"}).out((Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
        Assert.assertThat((Object)((CallableUserFunction)functions.get(0)).apply((Context)new BasicContext(), new Object[0]), (Matcher)Matchers.equalTo((Object)7331L));
    }

    public URL createJarFor(Class<?> ... targets) throws IOException {
        return new JarBuilder().createJarFor(this.tmpdir.newFile(new Random().nextInt() + ".jar"), targets);
    }

    private ComponentRegistry registryWithUnsafeAPI() {
        ComponentRegistry allComponents = new ComponentRegistry();
        allComponents.register(UnsafeAPI.class, ctx -> new UnsafeAPI());
        return allComponents;
    }

    private ProcedureConfig procedureConfig() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_unrestricted.name(), "org.neo4j.kernel.impl.proc.unsafeFullAccess*"}));
        return new ProcedureConfig(config);
    }

    private static class UnsafeAPI {
        private UnsafeAPI() {
        }

        public long getNumber() {
            return 7331L;
        }
    }

    public static class ClassWithUnsafeConfiguredComponent {
        @org.neo4j.procedure.Context
        public UnsafeAPI api;

        @Procedure
        public Stream<Output> unsafeFullAccessProcedure() {
            return Stream.of(new Output(this.api.getNumber()));
        }

        @UserFunction
        public long unsafeFullAccessFunction() {
            return this.api.getNumber();
        }
    }

    public static class ClassWithUnsafeComponent {
        @org.neo4j.procedure.Context
        public UnsafeAPI api;

        @Procedure
        public Stream<Output> unsafeProcedure() {
            return Stream.of(new Output(this.api.getNumber()));
        }

        @UserFunction
        public long unsafeFunction() {
            return this.api.getNumber();
        }
    }

    public static class ClassWithGenericStream {
        @Procedure
        public Stream<List<Output>> genericStream() {
            return Stream.of(Collections.singletonList(new Output()));
        }
    }

    public static class ClassWithRawStream {
        @Procedure
        public Stream rawStreamProc() {
            return Stream.of(new Output());
        }
    }

    public static class ClassWithWildCardStream {
        @Procedure
        public Stream<?> wildCardProc() {
            return Stream.of(new Output());
        }
    }

    public static class ClassWithProcedureWithArgument {
        @Procedure
        public Stream<Output> myProcedure(@Name(value="value") long value) {
            return Stream.of(new Output(value));
        }
    }

    public static class ClassWithAnotherProcedure {
        @Procedure
        public Stream<Output> myOtherProcedure() {
            return Stream.of(new Output());
        }
    }

    public static class ClassWithNoProcedureAtAll {
        void thisMethodIsEntirelyUnrelatedToAllThisExcitement() {
        }
    }

    public static class ClassWithOneProcedure {
        @Procedure
        public Stream<Output> myProcedure() {
            return Stream.of(new Output());
        }
    }

    public static class ClassWithInvalidProcedure {
        @Procedure
        public boolean booleansAreNotAcceptableReturnTypes() {
            return false;
        }
    }

    public static class Output {
        public long someNumber = 1337L;

        public Output() {
        }

        public Output(long anotherNumber) {
            this.someNumber = anotherNumber;
        }
    }
}

