/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class ReflectiveUserAggregationFunctionTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ReflectiveProcedureCompiler procedureCompiler;
    private ComponentRegistry components;

    @Before
    public void setUp() throws Exception {
        this.components = new ComponentRegistry();
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, this.components, (Log)NullLog.getInstance(), ProcedureConfig.DEFAULT);
    }

    @Test
    public void shouldCompileAggregationFunction() throws Throwable {
        List<CallableUserAggregationFunction> function = this.compile(SingleAggregationFunction.class);
        TestCase.assertEquals((int)1, (int)function.size());
        Assert.assertThat((Object)function.get(0).signature(), (Matcher)Matchers.equalTo((Object)UserFunctionSignature.functionSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "collectCool"}).in("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out((Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTAny)).build()));
    }

    @Test
    public void shouldRunAggregationFunction() throws Throwable {
        CallableUserAggregationFunction func = this.compile(SingleAggregationFunction.class).get(0);
        CallableUserAggregationFunction.Aggregator aggregator = func.create((Context)new BasicContext());
        aggregator.update(new Object[]{"Harry"});
        aggregator.update(new Object[]{"Bonnie"});
        aggregator.update(new Object[]{"Sally"});
        aggregator.update(new Object[]{"Clyde"});
        Assert.assertThat((Object)aggregator.result(), (Matcher)CoreMatchers.equalTo(Arrays.asList("Bonnie", "Clyde")));
    }

    @Test
    public void shouldInjectLogging() throws KernelException {
        Log log = (Log)Mockito.spy(Log.class);
        this.components.register(Log.class, ctx -> log);
        CallableUserAggregationFunction function = (CallableUserAggregationFunction)this.procedureCompiler.compileAggregationFunction(LoggingFunction.class).get(0);
        CallableUserAggregationFunction.Aggregator aggregator = function.create((Context)new BasicContext());
        aggregator.update(new Object[0]);
        aggregator.result();
        ((Log)Mockito.verify((Object)log)).debug("1");
        ((Log)Mockito.verify((Object)log)).info("2");
        ((Log)Mockito.verify((Object)log)).warn("3");
        ((Log)Mockito.verify((Object)log)).error("4");
    }

    @Test
    public void shouldIgnoreClassesWithNoFunctions() throws Throwable {
        List<CallableUserAggregationFunction> functions = this.compile(PrivateConstructorButNoFunctions.class);
        TestCase.assertEquals((int)0, (int)functions.size());
    }

    @Test
    public void shouldRunClassWithMultipleFunctionsDeclared() throws Throwable {
        List<CallableUserAggregationFunction> compiled = this.compile(MultiFunction.class);
        CallableUserAggregationFunction f1 = compiled.get(0);
        CallableUserAggregationFunction f2 = compiled.get(1);
        CallableUserAggregationFunction.Aggregator f1Aggregator = f1.create((Context)new BasicContext());
        f1Aggregator.update(new Object[]{"Bonnie"});
        f1Aggregator.update(new Object[]{"Clyde"});
        CallableUserAggregationFunction.Aggregator f2Aggregator = f2.create((Context)new BasicContext());
        f2Aggregator.update(new Object[]{"Bonnie", 1337L});
        f2Aggregator.update(new Object[]{"Bonnie", 42L});
        Assert.assertThat((Object)f1Aggregator.result(), (Matcher)CoreMatchers.equalTo(Arrays.asList("Bonnie", "Clyde")));
        Assert.assertThat(((Map)f2Aggregator.result()).get("Bonnie"), (Matcher)CoreMatchers.equalTo((Object)1337L));
    }

    @Test
    public void shouldGiveHelpfulErrorOnConstructorThatRequiresArgument() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `WierdConstructorFunction`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(WierdConstructorFunction.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnNoPublicConstructor() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `PrivateConstructorFunction`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(PrivateConstructorFunction.class);
    }

    @Test
    public void shouldNotAllowVoidOutput() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Don't know how to map `void` to the Neo4j Type System.");
        this.compile(FunctionWithVoidOutput.class);
    }

    @Test
    public void shouldNotAllowNonVoidUpdate() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Update method 'update' in VoidOutput has type 'long' but must have return type 'void'.");
        this.compile(FunctionWithNonVoidUpdate.class);
    }

    @Test
    public void shouldNotAllowMissingAnnotations() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Class 'MissingAggregator' must contain methods annotated with both '@UserAggregationResult' as well as '@UserAggregationUpdate'.");
        this.compile(FunctionWithMissingAnnotations.class);
    }

    @Test
    public void shouldNotAllowMultipleUpdateAnnotations() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Class 'MissingAggregator' contains multiple methods annotated with '@UserAggregationUpdate'.");
        this.compile(FunctionWithDuplicateUpdateAnnotations.class);
    }

    @Test
    public void shouldNotAllowMultipleResultAnnotations() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Class 'MissingAggregator' contains multiple methods annotated with '@UserAggregationResult'.");
        this.compile(FunctionWithDuplicateResultAnnotations.class);
    }

    @Test
    public void shouldNotAllowNonPublicMethod() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Aggregation method 'test' in NonPublicTestMethod must be public.");
        this.compile(NonPublicTestMethod.class);
    }

    @Test
    public void shouldNotAllowNonPublicUpdateMethod() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Aggregation update method 'update' in InnerAggregator must be public.");
        this.compile(NonPublicUpdateMethod.class);
    }

    @Test
    public void shouldNotAllowNonPublicResultMethod() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Aggregation result method 'result' in InnerAggregator must be public.");
        this.compile(NonPublicResultMethod.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnFunctionReturningInvalidType() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Don't know how to map `char[]` to the Neo4j Type System.%nPlease refer to to the documentation for full details.%nFor your reference, known types are: [boolean, double, java.lang.Boolean, java.lang.Double, java.lang.Long, java.lang.Number, java.lang.Object, java.lang.String, java.util.List, java.util.Map, long]", new Object[0]));
        this.compile(FunctionWithInvalidOutput.class).get(0);
    }

    @Test
    public void shouldGiveHelpfulErrorOnContextAnnotatedStaticField() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("The field `gdb` in the class named `FunctionWithStaticContextAnnotatedField` is annotated as a @Context field,%nbut it is static. @Context fields must be public, non-final and non-static,%nbecause they are reset each time a procedure is invoked.", new Object[0]));
        this.compile(FunctionWithStaticContextAnnotatedField.class).get(0);
    }

    @Test
    public void shouldAllowOverridingProcedureName() throws Throwable {
        CallableUserAggregationFunction method = this.compile(FunctionWithOverriddenName.class).get(0);
        TestCase.assertEquals((String)"org.mystuff.thisisActuallyTheName", (String)method.signature().name().toString());
    }

    @Test
    public void shouldNotAllowOverridingFunctionNameWithoutNamespace() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("It is not allowed to define functions in the root namespace please use a namespace, e.g. `@UserFunction(\"org.example.com.singleName\")");
        this.compile(FunctionWithSingleName.class).get(0);
    }

    @Test
    public void shouldGiveHelpfulErrorOnNullMessageException() throws Throwable {
        CallableUserAggregationFunction method = this.compile(FunctionThatThrowsNullMsgExceptionAtInvocation.class).get(0);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Failed to invoke function `org.neo4j.kernel.impl.proc.test`: Caused by: java.lang.IndexOutOfBoundsException");
        method.create((Context)new BasicContext()).update(new Object[0]);
    }

    @Test
    public void shouldLoadWhiteListedFunction() throws Throwable {
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, new ComponentRegistry(), (Log)NullLog.getInstance(), new ProcedureConfig(Config.defaults().with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.procedure_whitelist.name(), "org.neo4j.kernel.impl.proc.collectCool"}))));
        CallableUserAggregationFunction method = this.compile(SingleAggregationFunction.class).get(0);
        CallableUserAggregationFunction.Aggregator created = method.create((Context)new BasicContext());
        created.update(new Object[]{"Bonnie"});
        Assert.assertThat((Object)created.result(), (Matcher)CoreMatchers.equalTo(Collections.singletonList("Bonnie")));
    }

    @Test
    public void shouldNotLoadNoneWhiteListedFunction() throws Throwable {
        Log log = (Log)Mockito.spy(Log.class);
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, new ComponentRegistry(), log, new ProcedureConfig(Config.defaults().with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.procedure_whitelist.name(), "WrongName"}))));
        List<CallableUserAggregationFunction> method = this.compile(SingleAggregationFunction.class);
        ((Log)Mockito.verify((Object)log)).warn("The function 'org.neo4j.kernel.impl.proc.collectCool' is not on the whitelist and won't be loaded.");
        Assert.assertThat((Object)method.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldNotLoadAnyFunctionIfConfigIsEmpty() throws Throwable {
        Log log = (Log)Mockito.spy(Log.class);
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, new ComponentRegistry(), log, new ProcedureConfig(Config.defaults().with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.procedure_whitelist.name(), ""}))));
        List<CallableUserAggregationFunction> method = this.compile(SingleAggregationFunction.class);
        ((Log)Mockito.verify((Object)log)).warn("The function 'org.neo4j.kernel.impl.proc.collectCool' is not on the whitelist and won't be loaded.");
        Assert.assertThat((Object)method.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldSupportFunctionDeprecation() throws Throwable {
        Log log = (Log)Mockito.mock(Log.class);
        ReflectiveProcedureCompiler procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, new ComponentRegistry(), log, ProcedureConfig.DEFAULT);
        List funcs = procedureCompiler.compileAggregationFunction(FunctionWithDeprecation.class);
        ((Log)Mockito.verify((Object)log)).warn("Use of @UserAggregationFunction(deprecatedBy) without @Deprecated in org.neo4j.kernel.impl.proc.badFunc");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
        block9: for (CallableUserAggregationFunction func : funcs) {
            String name = func.signature().name().name();
            func.create((Context)new BasicContext());
            switch (name) {
                case "newFunc": {
                    Assert.assertFalse((String)"Should not be deprecated", (boolean)func.signature().deprecated().isPresent());
                    continue block9;
                }
                case "oldFunc": 
                case "badFunc": {
                    Assert.assertTrue((String)"Should be deprecated", (boolean)func.signature().deprecated().isPresent());
                    Assert.assertThat(func.signature().deprecated().get(), (Matcher)CoreMatchers.equalTo((Object)"newFunc"));
                    continue block9;
                }
            }
            Assert.fail((String)("Unexpected function: " + name));
        }
    }

    private List<CallableUserAggregationFunction> compile(Class<?> clazz) throws KernelException {
        return this.procedureCompiler.compileAggregationFunction(clazz);
    }

    public static class NonPublicResultMethod {
        @UserAggregationFunction
        public InnerAggregator test() {
            return new InnerAggregator();
        }

        public static class InnerAggregator {
            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            String result() {
                return "Testing";
            }
        }
    }

    public static class NonPublicUpdateMethod {
        @UserAggregationFunction
        public InnerAggregator test() {
            return new InnerAggregator();
        }

        public static class InnerAggregator {
            @UserAggregationUpdate
            void update() {
            }

            @UserAggregationResult
            public String result() {
                return "Testing";
            }
        }
    }

    public static class NonPublicTestMethod {
        @UserAggregationFunction
        InnerAggregator test() {
            return new InnerAggregator();
        }

        public static class InnerAggregator {
            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public String result() {
                return "Testing";
            }
        }
    }

    public static class FunctionWithDeprecation {
        @UserAggregationFunction
        public CoolPeopleAggregator newFunc() {
            return new CoolPeopleAggregator();
        }

        @Deprecated
        @UserAggregationFunction(deprecatedBy="newFunc")
        public CoolPeopleAggregator oldFunc() {
            return new CoolPeopleAggregator();
        }

        @UserAggregationFunction(deprecatedBy="newFunc")
        public CoolPeopleAggregator badFunc() {
            return new CoolPeopleAggregator();
        }
    }

    public static class FunctionWithSingleName {
        @UserAggregationFunction(value="singleName")
        public CoolPeopleAggregator collectCool() {
            return new CoolPeopleAggregator();
        }
    }

    public static class FunctionWithOverriddenName {
        @UserAggregationFunction(value="org.mystuff.thisisActuallyTheName")
        public CoolPeopleAggregator collectCool() {
            return new CoolPeopleAggregator();
        }
    }

    public static class PrivateConstructorButNoFunctions {
        private PrivateConstructorButNoFunctions() {
        }

        public String thisIsNotAFunction() {
            return null;
        }
    }

    public static class PrivateConstructorFunction {
        private PrivateConstructorFunction() {
        }

        @UserAggregationFunction
        public CoolPeopleAggregator collectCool() {
            return new CoolPeopleAggregator();
        }
    }

    public static class FunctionThatThrowsNullMsgExceptionAtInvocation {
        @UserAggregationFunction
        public ThrowingAggregator test() {
            return new ThrowingAggregator();
        }

        public static class ThrowingAggregator {
            @UserAggregationUpdate
            public void update() {
                throw new IndexOutOfBoundsException();
            }

            @UserAggregationResult
            public String result() {
                return "Testing";
            }
        }
    }

    public static class FunctionWithStaticContextAnnotatedField {
        @org.neo4j.procedure.Context
        public static GraphDatabaseService gdb;

        @UserAggregationFunction
        public InvalidAggregator test() {
            return new InvalidAggregator();
        }

        public static class InvalidAggregator {
            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public String result() {
                return "Testing";
            }
        }
    }

    public static class FunctionWithInvalidOutput {
        @UserAggregationFunction
        public InvalidAggregator test() {
            return new InvalidAggregator();
        }

        public static class InvalidAggregator {
            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public char[] result() {
                return "Testing".toCharArray();
            }
        }
    }

    public static class WierdConstructorFunction {
        public WierdConstructorFunction(WierdConstructorFunction wat) {
        }

        @UserAggregationFunction
        public CoolPeopleAggregator collectCool() {
            return new CoolPeopleAggregator();
        }
    }

    public static class MultiFunction {
        @UserAggregationFunction
        public CoolPeopleAggregator collectCool() {
            return new CoolPeopleAggregator();
        }

        @UserAggregationFunction
        public MapAggregator collectMap() {
            return new MapAggregator();
        }
    }

    public static class MapAggregator {
        private Map<String, Object> map = new HashMap<String, Object>();

        @UserAggregationUpdate
        public void update(@Name(value="name") String name, @Name(value="value") long value) {
            Long prev = (Long)this.map.getOrDefault(name, 0L);
            if (value > prev) {
                this.map.put(name, value);
            }
        }

        @UserAggregationResult
        public Map<String, Object> result() {
            return this.map;
        }
    }

    public static class LoggingFunction {
        @org.neo4j.procedure.Context
        public Log log;

        @UserAggregationFunction
        public LoggingAggregator log() {
            return new LoggingAggregator();
        }

        public class LoggingAggregator {
            @UserAggregationUpdate
            public void logAround() {
                LoggingFunction.this.log.debug("1");
                LoggingFunction.this.log.info("2");
                LoggingFunction.this.log.warn("3");
                LoggingFunction.this.log.error("4");
            }

            @UserAggregationResult
            public long result() {
                return 1337L;
            }
        }
    }

    public static class FunctionWithNonVoidUpdate {
        @UserAggregationFunction
        public VoidOutput voidOutput() {
            return new VoidOutput();
        }

        public static class VoidOutput {
            @UserAggregationUpdate
            public long update() {
                return 42L;
            }

            @UserAggregationResult
            public long result() {
                return 42L;
            }
        }
    }

    public static class FunctionWithDuplicateResultAnnotations {
        @UserAggregationFunction
        public MissingAggregator test() {
            return new MissingAggregator();
        }

        public static class MissingAggregator {
            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public String result1() {
                return "test";
            }

            @UserAggregationResult
            public String result2() {
                return "test";
            }
        }
    }

    public static class FunctionWithDuplicateUpdateAnnotations {
        @UserAggregationFunction
        public MissingAggregator test() {
            return new MissingAggregator();
        }

        public static class MissingAggregator {
            @UserAggregationUpdate
            public void update1() {
            }

            @UserAggregationUpdate
            public void update2() {
            }

            @UserAggregationResult
            public String result() {
                return "test";
            }
        }
    }

    public static class FunctionWithMissingAnnotations {
        @UserAggregationFunction
        public MissingAggregator test() {
            return new MissingAggregator();
        }

        public static class MissingAggregator {
            public void update() {
            }

            public String result() {
                return "test";
            }
        }
    }

    public static class FunctionWithVoidOutput {
        @UserAggregationFunction
        public VoidOutput voidOutput() {
            return new VoidOutput();
        }

        public static class VoidOutput {
            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public void result() {
            }
        }
    }

    public static class CoolPeopleAggregator {
        private List<String> coolPeople = new ArrayList<String>();

        @UserAggregationUpdate
        public void update(@Name(value="name") String name) {
            if (name.equals("Bonnie") || name.equals("Clyde")) {
                this.coolPeople.add(name);
            }
        }

        @UserAggregationResult
        public List<String> result() {
            return this.coolPeople;
        }
    }

    public static class SingleAggregationFunction {
        @UserAggregationFunction
        public CoolPeopleAggregator collectCool() {
            return new CoolPeopleAggregator();
        }
    }
}

