/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.TypeMappers;

@RunWith(value=Parameterized.class)
public class TypeMappersTest {
    @Parameterized.Parameter(value=0)
    public Type javaClass;
    @Parameterized.Parameter(value=1)
    public Neo4jTypes.AnyType neoType;
    @Parameterized.Parameter(value=2)
    public Object javaValue;
    @Parameterized.Parameter(value=3)
    public Object expectedNeoValue;
    static Type listOfListOfMap = TypeMappersTest.typeOf("listOfListOfMap");

    @Parameterized.Parameters(name="{0} to {1}")
    public static List<Object[]> conversions() {
        return Arrays.asList({Object.class, Neo4jTypes.NTAny, "", ""}, {Object.class, Neo4jTypes.NTAny, null, null}, {Object.class, Neo4jTypes.NTAny, 1, 1}, {Object.class, Neo4jTypes.NTAny, true, true}, {Object.class, Neo4jTypes.NTAny, Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 3)}, {Object.class, Neo4jTypes.NTAny, new HashMap(), new HashMap()}, {String.class, Neo4jTypes.NTString, "", ""}, {String.class, Neo4jTypes.NTString, "not empty", "not empty"}, {String.class, Neo4jTypes.NTString, null, null}, {Map.class, Neo4jTypes.NTMap, new HashMap(), new HashMap()}, {Map.class, Neo4jTypes.NTMap, TypeMappersTest.getKMap(), TypeMappersTest.getKMap()}, {Map.class, Neo4jTypes.NTMap, null, null}, {List.class, Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTAny), Collections.emptyList(), Collections.emptyList()}, {List.class, Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTAny), Arrays.asList(1, 2, 3, 4), Arrays.asList(1, 2, 3, 4)}, {List.class, Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTAny), Arrays.asList(Arrays.asList(1, 2), Arrays.asList("three", "four")), Arrays.asList(Arrays.asList(1, 2), Arrays.asList("three", "four"))}, {List.class, Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTAny), null, null}, {listOfListOfMap, Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)), Arrays.asList(new Object[0]), Arrays.asList(new Object[0])}, {Boolean.TYPE, Neo4jTypes.NTBoolean, false, false}, {Boolean.TYPE, Neo4jTypes.NTBoolean, true, true}, {Boolean.TYPE, Neo4jTypes.NTBoolean, null, null}, {Boolean.class, Neo4jTypes.NTBoolean, false, false}, {Boolean.class, Neo4jTypes.NTBoolean, true, true}, {Boolean.class, Neo4jTypes.NTBoolean, null, null}, {Number.class, Neo4jTypes.NTNumber, 1L, 1L}, {Number.class, Neo4jTypes.NTNumber, 0L, 0L}, {Number.class, Neo4jTypes.NTNumber, null, null}, {Number.class, Neo4jTypes.NTNumber, Long.MIN_VALUE, Long.MIN_VALUE}, {Number.class, Neo4jTypes.NTNumber, Long.MAX_VALUE, Long.MAX_VALUE}, {Number.class, Neo4jTypes.NTNumber, 1.0, 1.0}, {Number.class, Neo4jTypes.NTNumber, 0.0, 0.0}, {Number.class, Neo4jTypes.NTNumber, 1.234, 1.234}, {Number.class, Neo4jTypes.NTNumber, null, null}, {Number.class, Neo4jTypes.NTNumber, Double.MIN_VALUE, Double.MIN_VALUE}, {Number.class, Neo4jTypes.NTNumber, Double.MAX_VALUE, Double.MAX_VALUE}, {Long.TYPE, Neo4jTypes.NTInteger, 1L, 1L}, {Long.TYPE, Neo4jTypes.NTInteger, 0L, 0L}, {Long.TYPE, Neo4jTypes.NTInteger, null, null}, {Long.TYPE, Neo4jTypes.NTInteger, Long.MIN_VALUE, Long.MIN_VALUE}, {Long.TYPE, Neo4jTypes.NTInteger, Long.MAX_VALUE, Long.MAX_VALUE}, {Long.class, Neo4jTypes.NTInteger, 1L, 1L}, {Long.class, Neo4jTypes.NTInteger, 0L, 0L}, {Long.class, Neo4jTypes.NTInteger, null, null}, {Long.class, Neo4jTypes.NTInteger, Long.MIN_VALUE, Long.MIN_VALUE}, {Long.class, Neo4jTypes.NTInteger, Long.MAX_VALUE, Long.MAX_VALUE}, {Double.TYPE, Neo4jTypes.NTFloat, 1.0, 1.0}, {Double.TYPE, Neo4jTypes.NTFloat, 0.0, 0.0}, {Double.TYPE, Neo4jTypes.NTFloat, 1.234, 1.234}, {Double.TYPE, Neo4jTypes.NTFloat, null, null}, {Double.TYPE, Neo4jTypes.NTFloat, Double.MIN_VALUE, Double.MIN_VALUE}, {Double.TYPE, Neo4jTypes.NTFloat, Double.MAX_VALUE, Double.MAX_VALUE}, {Double.class, Neo4jTypes.NTFloat, 1.0, 1.0}, {Double.class, Neo4jTypes.NTFloat, 0.0, 0.0}, {Double.class, Neo4jTypes.NTFloat, 1.234, 1.234}, {Double.class, Neo4jTypes.NTFloat, null, null}, {Double.class, Neo4jTypes.NTFloat, Double.MIN_VALUE, Double.MIN_VALUE}, {Double.class, Neo4jTypes.NTFloat, Double.MAX_VALUE, Double.MAX_VALUE});
    }

    private static HashMap<String, Object> getKMap() {
        return new HashMap<String, Object>(){
            {
                this.put("k", 1);
            }
        };
    }

    @Test
    public void shouldDetectCorrectType() throws Throwable {
        TypeMappers.NeoValueConverter mapper = new TypeMappers().converterFor(this.javaClass);
        TestCase.assertEquals((Object)this.neoType, (Object)mapper.type());
    }

    @Test
    public void shouldMapCorrectly() throws Throwable {
        TypeMappers.NeoValueConverter mapper = new TypeMappers().converterFor(this.javaClass);
        Object converted = mapper.toNeoValue(this.javaValue);
        Assert.assertEquals((Object)this.expectedNeoValue, (Object)converted);
    }

    static Type typeOf(String methodName) {
        try {
            for (Method method : ClassToGetGenericTypeSignatures.class.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method.getGenericParameterTypes()[0];
            }
            throw new AssertionError((Object)("No method named " + methodName));
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    static interface ClassToGetGenericTypeSignatures {
        public void listOfListOfMap(List<List<Map<String, Object>>> var1);
    }
}

