/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.List;
import org.junit.Assert;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class CountsOracle {
    private final CountsRecordState state = new CountsRecordState();

    public Node node(long ... labels) {
        this.state.addNode(labels);
        return new Node(labels);
    }

    public void relationship(Node start, int type, Node end) {
        this.state.addRelationship(start.labels, type, end.labels);
    }

    public void indexUpdatesAndSize(long indexId, long updates, long size) {
        this.state.replaceIndexUpdateAndSize(indexId, updates, size);
    }

    public void indexSampling(long indexId, long unique, long size) {
        this.state.replaceIndexSample(indexId, unique, size);
    }

    public void update(CountsTracker target, long txId) {
        try (CountsAccessor.Updater updater = (CountsAccessor.Updater)target.apply(txId).get();
             CountsAccessor.IndexStatsUpdater stats = target.updateIndexCounts();){
            this.state.accept((CountsVisitor)new CountsAccessor.Initializer(updater, stats));
        }
    }

    public void update(CountsOracle target) {
        this.state.accept((CountsVisitor)new CountsAccessor.Initializer((CountsAccessor.Updater)target.state, (CountsAccessor.IndexStatsUpdater)target.state));
    }

    public <Tracker extends CountsVisitor.Visitable & CountsAccessor> void verify(final Tracker tracker) {
        CountsRecordState seenState = new CountsRecordState();
        final CountsAccessor.Initializer initializer = new CountsAccessor.Initializer((CountsAccessor.Updater)seenState, (CountsAccessor.IndexStatsUpdater)seenState);
        List differences = this.state.verify(new CountsVisitor.Visitable(){

            public void accept(CountsVisitor verifier) {
                tracker.accept(CountsVisitor.Adapter.multiplex((CountsVisitor[])new CountsVisitor[]{initializer, verifier}));
            }
        });
        seenState.accept(new CountsVisitor(){

            public void visitNodeCount(int labelId, long count) {
                long expected = ((CountsAccessor)tracker).nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
                Assert.assertEquals((String)"Should be able to read visited state.", (long)expected, (long)count);
            }

            public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
                long expected = ((CountsAccessor)tracker).relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
                Assert.assertEquals((String)"Should be able to read visited state.", (long)expected, (long)count);
            }

            public void visitIndexStatistics(long indexId, long updates, long size) {
                Register.DoubleLongRegister output = ((CountsAccessor)tracker).indexUpdatesAndSize(indexId, Registers.newDoubleLongRegister());
                Assert.assertEquals((String)"Should be able to read visited state.", (long)output.readFirst(), (long)updates);
                Assert.assertEquals((String)"Should be able to read visited state.", (long)output.readSecond(), (long)size);
            }

            public void visitIndexSample(long indexId, long unique, long size) {
                Register.DoubleLongRegister output = ((CountsAccessor)tracker).indexSample(indexId, Registers.newDoubleLongRegister());
                Assert.assertEquals((String)"Should be able to read visited state.", (long)output.readFirst(), (long)unique);
                Assert.assertEquals((String)"Should be able to read visited state.", (long)output.readSecond(), (long)size);
            }
        });
        if (!differences.isEmpty()) {
            StringBuilder errors = new StringBuilder().append("Counts differ in ").append(differences.size()).append(" places...");
            for (CountsRecordState.Difference difference : differences) {
                errors.append("\n\t").append(difference);
            }
            throw new AssertionError((Object)errors.toString());
        }
    }

    public static class Node {
        private final long[] labels;

        private Node(long[] labels) {
            this.labels = labels;
        }
    }
}

