/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.store.IdGeneratorContractTest;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IdGeneratorImplContractTest
extends IdGeneratorContractTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction fs;
    private File storeDir;

    @Before
    public void doBefore() {
        this.fs = (EphemeralFileSystemAbstraction)this.fsRule.get();
        this.storeDir = AbstractNeo4jTestCase.getStorePath("xatest");
        this.fs.mkdirs(this.storeDir);
    }

    @Override
    protected IdGenerator createIdGenerator(int grabSize) {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        return this.openIdGenerator(grabSize);
    }

    @Override
    protected IdGenerator openIdGenerator(int grabSize) {
        return new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), grabSize, 1000L, false, 0L);
    }

    @After
    public void verifyFileCleanup() throws Exception {
        File file = this.idGeneratorFile();
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    private File file(String name) {
        return new File(this.storeDir, name);
    }

    private File idGeneratorFile() {
        return this.file("testIdGenerator.id");
    }
}

