/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRuleSerialization;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class SchemaStoreTest {
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private Config config;
    private SchemaStore store;
    private NeoStores neoStores;
    private StoreFactory storeFactory;

    @Before
    public void before() throws Exception {
        File storeDir = new File("dir");
        ((EphemeralFileSystemAbstraction)this.fs.get()).mkdirs(storeDir);
        this.config = Config.empty();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(this.fs.get());
        this.storeFactory = new StoreFactory(storeDir, this.config, (IdGeneratorFactory)idGeneratorFactory, pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        this.neoStores = this.storeFactory.openAllNeoStores(true);
        this.store = this.neoStores.getSchemaStore();
    }

    @After
    public void after() throws Exception {
        this.neoStores.close();
    }

    @Test
    public void storeAndLoadSchemaRule() throws Exception {
        IndexRule indexRule = IndexRule.indexRule((long)this.store.nextId(), (IndexDescriptor)IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{4}), (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule readIndexRule = (IndexRule)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(indexRule.serialize()));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule.getIndexDescriptor(), (Object)readIndexRule.getIndexDescriptor());
        Assert.assertEquals((Object)indexRule.getProviderDescriptor(), (Object)readIndexRule.getProviderDescriptor());
    }

    @Test
    public void storeAndLoadCompositeSchemaRule() throws Exception {
        int[] propertyIds = new int[]{4, 5, 6, 7};
        IndexRule indexRule = IndexRule.indexRule((long)this.store.nextId(), (IndexDescriptor)IndexDescriptorFactory.forLabel((int)2, (int[])propertyIds), (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule readIndexRule = (IndexRule)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(indexRule.serialize()));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule.getIndexDescriptor(), (Object)readIndexRule.getIndexDescriptor());
        Assert.assertEquals((Object)indexRule.getProviderDescriptor(), (Object)readIndexRule.getProviderDescriptor());
    }

    @Test
    public void storeAndLoad_Big_CompositeSchemaRule() throws Exception {
        IndexRule indexRule = IndexRule.indexRule((long)this.store.nextId(), (IndexDescriptor)IndexDescriptorFactory.forLabel((int)2, (int[])IntStream.range(1, 200).toArray()), (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule readIndexRule = (IndexRule)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(indexRule.serialize()));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule.getIndexDescriptor(), (Object)readIndexRule.getIndexDescriptor());
        Assert.assertEquals((Object)indexRule.getProviderDescriptor(), (Object)readIndexRule.getProviderDescriptor());
    }

    @Test
    public void storeAndLoadAllRules() throws Exception {
        long indexId = this.store.nextId();
        long constraintId = this.store.nextId();
        List<SchemaRule> rules = Arrays.asList(this.uniqueIndexRule(indexId, constraintId, TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, 2, 5, 3), this.constraintUniqueRule(constraintId, indexId, 2, 5, 3), this.indexRule(this.store.nextId(), TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, 0, 5), this.indexRule(this.store.nextId(), TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, 1, 6, 10, 99), this.constraintExistsRule(this.store.nextId(), 5, 1));
        for (SchemaRule rule : rules) {
            this.storeRule(rule);
        }
        Collection readRules = Iterators.asCollection((Iterator)this.store.loadAllSchemaRules());
        Assert.assertEquals(rules, (Object)readRules);
    }

    private long storeRule(SchemaRule rule) {
        List records = this.store.allocateFrom(rule);
        for (DynamicRecord record : records) {
            this.store.updateRecord((AbstractBaseRecord)record);
        }
        return ((DynamicRecord)Iterables.first((Iterable)records)).getId();
    }

    private IndexRule indexRule(long ruleId, SchemaIndexProvider.Descriptor descriptor, int labelId, int ... propertyIds) {
        return IndexRule.indexRule((long)ruleId, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)labelId, (int[])propertyIds), (SchemaIndexProvider.Descriptor)descriptor);
    }

    private IndexRule uniqueIndexRule(long ruleId, long owningConstraint, SchemaIndexProvider.Descriptor descriptor, int labelId, int ... propertyIds) {
        return IndexRule.constraintIndexRule((long)ruleId, (IndexDescriptor)IndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyIds), (SchemaIndexProvider.Descriptor)descriptor, (Long)owningConstraint);
    }

    private ConstraintRule constraintUniqueRule(long ruleId, long ownedIndexId, int labelId, int ... propertyIds) {
        return ConstraintRule.constraintRule((long)ruleId, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyIds), (long)ownedIndexId);
    }

    private ConstraintRule constraintExistsRule(long ruleId, int labelId, int ... propertyIds) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])propertyIds));
    }
}

