/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.string.UTF8;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class TestArrayStore {
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private DynamicArrayStore arrayStore;
    private NeoStores neoStores;

    @Before
    public void before() throws Exception {
        File dir = this.testDirectory.graphDbDir();
        FileSystemAbstraction fs = this.fileSystemRule.get();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs);
        PageCache pageCache = pageCacheRule.getPageCache(fs);
        StoreFactory factory = new StoreFactory(dir, Config.empty(), (IdGeneratorFactory)idGeneratorFactory, pageCache, fs, (LogProvider)NullLogProvider.getInstance());
        this.neoStores = factory.openAllNeoStores(true);
        this.arrayStore = this.neoStores.getPropertyStore().getArrayStore();
    }

    @After
    public void after() throws Exception {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Test
    public void intArrayPropertiesShouldBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1, 2, 3, 4, 5, 6, 7}, PropertyType.INT, 3);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1, 2, 3, 4, 5, 6, 7, 8}, PropertyType.INT, 4);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1000, 10000, 13000}, PropertyType.INT, 14);
    }

    @Test
    public void longArrayPropertiesShouldBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, PropertyType.LONG, 3);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}, PropertyType.LONG, 4);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1000L, 10000L, 13000L, 15000000000L}, PropertyType.LONG, 34);
    }

    @Test
    public void byteArrayPropertiesShouldNotBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new byte[]{1, 2, 3, 4, 5}, PropertyType.BYTE, 8);
    }

    @Test
    public void stringArrayGetsStoredAsUtf8() throws Exception {
        String[] array = new String[]{"first", "second"};
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        this.arrayStore.allocateRecords(records, (Object)array);
        Pair<byte[], byte[]> loaded = this.loadArray(records);
        this.assertStringHeader((byte[])loaded.first(), array.length);
        ByteBuffer buffer = ByteBuffer.wrap((byte[])loaded.other());
        for (String item : array) {
            byte[] expectedData = UTF8.encode((String)item);
            Assert.assertEquals((long)expectedData.length, (long)buffer.getInt());
            byte[] loadedItem = new byte[expectedData.length];
            buffer.get(loadedItem);
            Assert.assertTrue((boolean)Arrays.equals(expectedData, loadedItem));
        }
    }

    private void assertStringHeader(byte[] header, int itemCount) {
        Assert.assertEquals((long)PropertyType.STRING.byteValue(), (long)header[0]);
        Assert.assertEquals((long)itemCount, (long)ByteBuffer.wrap(header, 1, 4).getInt());
    }

    private void assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(Object array, PropertyType type, int expectedBitsUsedPerItem) {
        Collection<DynamicRecord> records = this.storeArray(array);
        Pair<byte[], byte[]> asBytes = this.loadArray(records);
        this.assertArrayHeader((byte[])asBytes.first(), type, expectedBitsUsedPerItem);
        Bits bits = Bits.bitsFromBytes((byte[])((byte[])asBytes.other()));
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((long)((Number)Array.get(array, i)).longValue(), (long)bits.getLong(expectedBitsUsedPerItem));
        }
    }

    private void assertArrayHeader(byte[] header, PropertyType type, int bitsPerItem) {
        Assert.assertEquals((long)type.byteValue(), (long)header[0]);
        Assert.assertEquals((long)bitsPerItem, (long)header[2]);
    }

    private Collection<DynamicRecord> storeArray(Object array) {
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        this.arrayStore.allocateRecords(records, array);
        for (DynamicRecord record : records) {
            this.arrayStore.updateRecord((AbstractBaseRecord)record);
        }
        return records;
    }

    private Pair<byte[], byte[]> loadArray(Collection<DynamicRecord> records) {
        return this.arrayStore.readFullByteArray(records, PropertyType.ARRAY);
    }
}

