/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.store.ProduceUncleanStore;
import org.neo4j.test.ProcessTestUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class TestBrokenStoreRecovery {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void testTruncatedPropertyStore() throws Exception {
        File storeDir = this.testDirectory.directory("propertyStore");
        Future<Integer> subProcess = ProcessTestUtil.startSubProcess(ProduceUncleanStore.class, storeDir.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)subProcess.get().intValue());
        this.trimFileToSize(new File(storeDir, "neostore.propertystore.db"), 42);
        File log = new File(storeDir, "neostore.transaction.db.0");
        this.trimFileToSize(log, 78);
        new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir.getAbsoluteFile()).shutdown();
    }

    private void trimFileToSize(File theFile, int toSize) throws IOException {
        try (FileChannel theChannel = new RandomAccessFile(theFile, "rw").getChannel();){
            theChannel.truncate(toSize);
            theChannel.force(false);
        }
    }
}

