/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.allocator;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public class ReusableRecordsAllocatorTest {
    @Test
    public void allocatePreviouslyNotUsedRecord() throws Exception {
        DynamicRecord dynamicRecord = new DynamicRecord(1L);
        dynamicRecord.setInUse(false);
        ReusableRecordsAllocator recordsAllocator = new ReusableRecordsAllocator(10, new DynamicRecord[]{dynamicRecord});
        DynamicRecord allocatedRecord = recordsAllocator.nextRecord();
        Assert.assertSame((String)"Records should be the same.", (Object)allocatedRecord, (Object)dynamicRecord);
        Assert.assertTrue((String)"Record should be marked as used.", (boolean)allocatedRecord.inUse());
        Assert.assertTrue((String)"Record should be marked as created.", (boolean)allocatedRecord.isCreated());
    }

    @Test
    public void allocatePreviouslyUsedRecord() throws Exception {
        DynamicRecord dynamicRecord = new DynamicRecord(1L);
        dynamicRecord.setInUse(true);
        ReusableRecordsAllocator recordsAllocator = new ReusableRecordsAllocator(10, new DynamicRecord[]{dynamicRecord});
        DynamicRecord allocatedRecord = recordsAllocator.nextRecord();
        Assert.assertSame((String)"Records should be the same.", (Object)allocatedRecord, (Object)dynamicRecord);
        Assert.assertTrue((String)"Record should be marked as used.", (boolean)allocatedRecord.inUse());
        Assert.assertFalse((String)"Record should be marked as created.", (boolean)allocatedRecord.isCreated());
    }

    @Test
    public void trackRecordsAvailability() {
        DynamicRecord dynamicRecord1 = new DynamicRecord(1L);
        DynamicRecord dynamicRecord2 = new DynamicRecord(1L);
        ReusableRecordsAllocator recordsAllocator = new ReusableRecordsAllocator(10, new DynamicRecord[]{dynamicRecord1, dynamicRecord2});
        Assert.assertSame((String)"Should be the same as first available record.", (Object)dynamicRecord1, (Object)recordsAllocator.nextRecord());
        Assert.assertTrue((String)"Should have second record.", (boolean)recordsAllocator.hasNext());
        Assert.assertSame((String)"Should be the same as second available record.", (Object)dynamicRecord2, (Object)recordsAllocator.nextRecord());
        Assert.assertFalse((String)"Should be out of available records", (boolean)recordsAllocator.hasNext());
    }
}

