/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.NoRecordFormat;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.format.standard.StandardFormatFamily;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class RecordFormatPropertyConfiguratorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void keepUserDefinedFormatConfig() throws Exception {
        Config config = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.string_block_size.name(), "36"}));
        RecordFormats recordFormats = Standard.LATEST_RECORD_FORMATS;
        new RecordFormatPropertyConfigurator(recordFormats, config).configure();
        Assert.assertEquals((String)"Should keep used specified value", (long)36L, (long)((Integer)config.get(GraphDatabaseSettings.string_block_size)).intValue());
    }

    @Test
    public void overrideDefaultValuesForCurrentFormat() {
        Config config = Config.empty();
        int testHeaderSize = 17;
        ResizableRecordFormats recordFormats = new ResizableRecordFormats(testHeaderSize);
        new RecordFormatPropertyConfigurator((RecordFormats)recordFormats, config).configure();
        Assert.assertEquals((long)(128 - testHeaderSize), (long)((Integer)config.get(GraphDatabaseSettings.string_block_size)).intValue());
        Assert.assertEquals((long)(128 - testHeaderSize), (long)((Integer)config.get(GraphDatabaseSettings.array_block_size)).intValue());
        Assert.assertEquals((long)(64 - testHeaderSize), (long)((Integer)config.get(GraphDatabaseSettings.label_block_size)).intValue());
    }

    @Test
    public void checkForMinimumBlockSize() {
        Config config = Config.empty();
        int testHeaderSize = 60;
        ResizableRecordFormats recordFormats = new ResizableRecordFormats(testHeaderSize);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Block size should be bigger then 16");
        new RecordFormatPropertyConfigurator((RecordFormats)recordFormats, config).configure();
    }

    private class ResizableRecordFormat
    extends NoRecordFormat<DynamicRecord> {
        private int headerSize;

        ResizableRecordFormat(int headerSize) {
            this.headerSize = headerSize;
        }

        public int getRecordHeaderSize() {
            return this.headerSize;
        }
    }

    private class ResizableRecordFormats
    implements RecordFormats {
        private int dynamicRecordHeaderSize;

        ResizableRecordFormats(int dynamicRecordHeaderSize) {
            this.dynamicRecordHeaderSize = dynamicRecordHeaderSize;
        }

        public String storeVersion() {
            return null;
        }

        public String introductionVersion() {
            return null;
        }

        public int generation() {
            return 0;
        }

        public RecordFormat<NodeRecord> node() {
            return null;
        }

        public RecordFormat<RelationshipGroupRecord> relationshipGroup() {
            return null;
        }

        public RecordFormat<RelationshipRecord> relationship() {
            return null;
        }

        public RecordFormat<PropertyRecord> property() {
            return null;
        }

        public RecordFormat<LabelTokenRecord> labelToken() {
            return null;
        }

        public RecordFormat<PropertyKeyTokenRecord> propertyKeyToken() {
            return null;
        }

        public RecordFormat<RelationshipTypeTokenRecord> relationshipTypeToken() {
            return null;
        }

        public RecordFormat<DynamicRecord> dynamic() {
            return new ResizableRecordFormat(this.dynamicRecordHeaderSize);
        }

        public RecordFormat<MetaDataRecord> metaData() {
            return null;
        }

        public Capability[] capabilities() {
            return new Capability[0];
        }

        public boolean hasCapability(Capability capability) {
            return false;
        }

        public FormatFamily getFormatFamily() {
            return StandardFormatFamily.INSTANCE;
        }

        public boolean hasSameCapabilities(RecordFormats other, CapabilityType type) {
            return false;
        }
    }
}

