/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRuleTestBase;

public class IndexRuleTest
extends SchemaRuleTestBase {
    @Test
    public void shouldCreateGeneralIndex() throws Exception {
        IndexDescriptor descriptor = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30});
        IndexRule indexRule = IndexRule.indexRule((long)1L, (IndexDescriptor)descriptor, (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR);
        MatcherAssert.assertThat((Object)indexRule.getId(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertFalse((boolean)indexRule.canSupportUniqueConstraint());
        MatcherAssert.assertThat((Object)indexRule.schema(), (Matcher)Matchers.equalTo((Object)descriptor.schema()));
        MatcherAssert.assertThat((Object)indexRule.getIndexDescriptor(), (Matcher)Matchers.equalTo((Object)descriptor));
        MatcherAssert.assertThat((Object)indexRule.getProviderDescriptor(), (Matcher)Matchers.equalTo((Object)PROVIDER_DESCRIPTOR));
        org.neo4j.test.assertion.Assert.assertException(() -> ((IndexRule)indexRule).getOwningConstraint(), IllegalStateException.class);
        org.neo4j.test.assertion.Assert.assertException(() -> indexRule.withOwningConstraint(2L), IllegalStateException.class);
    }

    @Test
    public void shouldCreateUniqueIndex() throws Exception {
        IndexDescriptor descriptor = IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30});
        IndexRule indexRule = IndexRule.indexRule((long)1L, (IndexDescriptor)descriptor, (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR);
        MatcherAssert.assertThat((Object)indexRule.getId(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertTrue((boolean)indexRule.canSupportUniqueConstraint());
        MatcherAssert.assertThat((Object)indexRule.schema(), (Matcher)Matchers.equalTo((Object)descriptor.schema()));
        MatcherAssert.assertThat((Object)indexRule.getIndexDescriptor(), (Matcher)Matchers.equalTo((Object)descriptor));
        MatcherAssert.assertThat((Object)indexRule.getProviderDescriptor(), (Matcher)Matchers.equalTo((Object)PROVIDER_DESCRIPTOR));
        MatcherAssert.assertThat((Object)indexRule.getOwningConstraint(), (Matcher)Matchers.equalTo(null));
        IndexRule withConstraint = indexRule.withOwningConstraint(2L);
        MatcherAssert.assertThat((Object)withConstraint.getOwningConstraint(), (Matcher)Matchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)indexRule.getOwningConstraint(), (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void indexRulesAreEqualBasedOnIndexDescriptor() throws Exception {
        this.assertEqualityByDescriptor(IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30}));
        this.assertEqualityByDescriptor(IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}));
        this.assertEqualityByDescriptor(IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30, 31}));
        this.assertEqualityByDescriptor(IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30, 31}));
    }

    private void assertEqualityByDescriptor(IndexDescriptor descriptor) {
        IndexRule rule1 = IndexRule.indexRule((long)1L, (IndexDescriptor)descriptor, (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR);
        IndexRule rule2 = IndexRule.indexRule((long)2L, (IndexDescriptor)descriptor, (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR_2);
        this.assertEquality(rule1, rule2);
    }
}

