/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRuleSerialization;
import org.neo4j.kernel.impl.store.record.SchemaRuleTestBase;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaRuleSerializationTest
extends SchemaRuleTestBase {
    IndexRule indexRegular = IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR);
    IndexRule indexUnique = IndexRule.constraintIndexRule((long)2L, (IndexDescriptor)IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (Long)1L);
    IndexRule indexCompositeRegular = IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30, 31}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR);
    IndexRule indexCompositeUnique = IndexRule.constraintIndexRule((long)2L, (IndexDescriptor)IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30, 31}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (Long)1L);
    IndexRule indexBigComposite = IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])IntStream.range(1, 200).toArray()), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR);
    ConstraintRule constraintExistsLabel = ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30}));
    ConstraintRule constraintUniqueLabel = ConstraintRule.constraintRule((long)2L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}), (long)1L);
    ConstraintRule constraintNodeKeyLabel = ConstraintRule.constraintRule((long)2L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30}), (long)1L);
    ConstraintRule constraintExistsRelType = ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)20, (int[])new int[]{30}));
    ConstraintRule constraintCompositeLabel = ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30, 31}));
    ConstraintRule constraintCompositeRelType = ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)20, (int[])new int[]{30, 31}));

    @Test
    public void rulesCreatedWithoutNameMustHaveComputedName() throws Exception {
        MatcherAssert.assertThat((Object)this.indexRegular.getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.indexUnique.getName(), (Matcher)Matchers.is((Object)"index_2"));
        MatcherAssert.assertThat((Object)this.indexCompositeRegular.getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.indexCompositeUnique.getName(), (Matcher)Matchers.is((Object)"index_2"));
        MatcherAssert.assertThat((Object)this.indexBigComposite.getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.constraintExistsLabel.getName(), (Matcher)Matchers.is((Object)"constraint_1"));
        MatcherAssert.assertThat((Object)this.constraintUniqueLabel.getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.constraintNodeKeyLabel.getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.constraintExistsRelType.getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.constraintCompositeLabel.getName(), (Matcher)Matchers.is((Object)"constraint_1"));
        MatcherAssert.assertThat((Object)this.constraintCompositeRelType.getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.indexRegular), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.indexUnique), (Matcher)Matchers.is((Object)"index_2"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.indexCompositeRegular), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.indexCompositeUnique), (Matcher)Matchers.is((Object)"index_2"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.indexBigComposite), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.constraintExistsLabel), (Matcher)Matchers.is((Object)"constraint_1"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.constraintUniqueLabel), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.constraintNodeKeyLabel), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.constraintExistsRelType), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.constraintCompositeLabel), (Matcher)Matchers.is((Object)"constraint_1"));
        MatcherAssert.assertThat((Object)SchemaRuleSerializationTest.generateName((SchemaRule)this.constraintCompositeRelType), (Matcher)Matchers.is((Object)"constraint_2"));
    }

    private static String generateName(SchemaRule rule) {
        return SchemaRule.generateName((long)rule.getId(), rule.getClass());
    }

    @Test
    public void rulesCreatedWithoutNameMustRetainComputedNameAfterDeserialisation() throws Exception {
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.indexRegular).getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.indexUnique).getName(), (Matcher)Matchers.is((Object)"index_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.indexCompositeRegular).getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.indexCompositeUnique).getName(), (Matcher)Matchers.is((Object)"index_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.indexBigComposite).getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.constraintExistsLabel).getName(), (Matcher)Matchers.is((Object)"constraint_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.constraintUniqueLabel).getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.constraintNodeKeyLabel).getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.constraintExistsRelType).getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.constraintCompositeLabel).getName(), (Matcher)Matchers.is((Object)"constraint_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(this.constraintCompositeRelType).getName(), (Matcher)Matchers.is((Object)"constraint_2"));
    }

    @Test
    public void rulesCreatedWithNameMustRetainGivenNameAfterDeserialisation() throws Exception {
        String name = "custom_rule";
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.constraintIndexRule((long)2L, (IndexDescriptor)IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (Long)1L, (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30, 31}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.constraintIndexRule((long)2L, (IndexDescriptor)IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30, 31}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (Long)1L, (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])IntStream.range(1, 200).toArray()), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30}), (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)2L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}), (long)1L, (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)2L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30}), (long)1L, (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)20, (int[])new int[]{30}), (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30, 31}), (String)name)).getName(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)20, (int[])new int[]{30, 31}), (String)name)).getName(), (Matcher)Matchers.is((Object)name));
    }

    @Test
    public void rulesCreatedWithNullNameMustRetainComputedNameAfterDeserialisation() throws Exception {
        String name = null;
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, name)).getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.constraintIndexRule((long)2L, (IndexDescriptor)IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (Long)1L, name)).getName(), (Matcher)Matchers.is((Object)"index_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30, 31}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, name)).getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.constraintIndexRule((long)2L, (IndexDescriptor)IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30, 31}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (Long)1L, name)).getName(), (Matcher)Matchers.is((Object)"index_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])IntStream.range(1, 200).toArray()), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, name)).getName(), (Matcher)Matchers.is((Object)"index_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30}), name)).getName(), (Matcher)Matchers.is((Object)"constraint_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)2L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}), (long)1L, name)).getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)2L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30}), (long)1L, name)).getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)20, (int[])new int[]{30}), name)).getName(), (Matcher)Matchers.is((Object)"constraint_2"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30, 31}), name)).getName(), (Matcher)Matchers.is((Object)"constraint_1"));
        MatcherAssert.assertThat((Object)this.serialiseAndDeserialise(ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)20, (int[])new int[]{30, 31}), name)).getName(), (Matcher)Matchers.is((Object)"constraint_2"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void indexRuleNameMustNotContainNullCharacter() throws Exception {
        String name = "a\u0000b";
        IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void indexRuleNameMustNotBeTheEmptyString() throws Exception {
        String name = new String("");
        IndexRule.indexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constraintIndexRuleNameMustNotContainNullCharacter() throws Exception {
        String name = "a\u0000b";
        IndexRule.constraintIndexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (Long)2L, (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constraintIndexRuleNameMustNotBeTheEmptyString() throws Exception {
        String name = new String("");
        IndexRule.constraintIndexRule((long)1L, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{30}), (SchemaIndexProvider.Descriptor)PROVIDER_DESCRIPTOR, (Long)2L, (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constraintRuleNameMustNotContainNullCharacter() throws Exception {
        String name = "a\u0000b";
        ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30}), (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constraintRuleNameMustNotBeTheEmptyString() throws Exception {
        String name = new String("");
        ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30}), (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void uniquenessConstraintRuleNameMustNotContainNullCharacter() throws Exception {
        String name = "a\u0000b";
        ConstraintRule.constraintRule((long)1L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}), (long)2L, (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void uniquenessConstraintRuleNameMustNotBeTheEmptyString() throws Exception {
        String name = new String("");
        ConstraintRule.constraintRule((long)1L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}), (long)2L, (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nodeKeyConstraintRuleNameMustNotContainNullCharacter() throws Exception {
        String name = "a\u0000b";
        ConstraintRule.constraintRule((long)1L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30}), (long)2L, (String)name);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nodeKeyConstraintRuleNameMustNotBeTheEmptyString() throws Exception {
        String name = new String("");
        ConstraintRule.constraintRule((long)1L, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30}), (long)2L, (String)name);
    }

    @Test
    public void shouldSerializeAndDeserializeIndexRules() throws MalformedSchemaRuleException {
        this.assertSerializeAndDeserializeIndexRule(this.indexRegular);
        this.assertSerializeAndDeserializeIndexRule(this.indexUnique);
    }

    @Test
    public void shouldSerializeAndDeserializeCompositeIndexRules() throws MalformedSchemaRuleException {
        this.assertSerializeAndDeserializeIndexRule(this.indexCompositeRegular);
        this.assertSerializeAndDeserializeIndexRule(this.indexCompositeUnique);
    }

    @Test
    public void shouldSerializeAndDeserialize_Big_CompositeIndexRules() throws MalformedSchemaRuleException {
        this.assertSerializeAndDeserializeIndexRule(this.indexBigComposite);
    }

    @Test
    public void shouldSerializeAndDeserializeConstraintRules() throws MalformedSchemaRuleException {
        this.assertSerializeAndDeserializeConstraintRule(this.constraintExistsLabel);
        this.assertSerializeAndDeserializeConstraintRule(this.constraintUniqueLabel);
        this.assertSerializeAndDeserializeConstraintRule(this.constraintNodeKeyLabel);
        this.assertSerializeAndDeserializeConstraintRule(this.constraintExistsRelType);
    }

    @Test
    public void shouldSerializeAndDeserializeCompositeConstraintRules() throws MalformedSchemaRuleException {
        this.assertSerializeAndDeserializeConstraintRule(this.constraintCompositeLabel);
        this.assertSerializeAndDeserializeConstraintRule(this.constraintCompositeRelType);
    }

    @Test
    public void shouldReturnCorrectLengthForIndexRules() throws MalformedSchemaRuleException {
        this.assertCorrectLength(this.indexRegular);
        this.assertCorrectLength(this.indexUnique);
        this.assertCorrectLength(this.indexCompositeRegular);
        this.assertCorrectLength(this.indexCompositeUnique);
        this.assertCorrectLength(this.indexBigComposite);
    }

    @Test
    public void shouldReturnCorrectLengthForConstraintRules() throws MalformedSchemaRuleException {
        this.assertCorrectLength(this.constraintExistsLabel);
    }

    @Test
    public void shouldParseIndexRule() throws Exception {
        this.assertParseIndexRule("/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMB9bAAACAAABAAAABA==", "index_24");
        this.assertParseIndexRule("AAACAAEAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMAABAAAAAAAAAAQ=", "index_24");
        this.assertParseIndexRule("/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMB9bAAACAAABAAAABAAAAAtjdXN0b21fbmFtZQ==", "custom_name");
        this.assertParseIndexRule(this.addNullByte("/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMB9bAAACAAABAAAABA=="), "index_24");
        this.assertParseIndexRule(this.addNullByte(2, "/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMB9bAAACAAABAAAABA=="), "index_24");
        this.assertParseIndexRule(this.addNullByte(3, "/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMB9bAAACAAABAAAABA=="), "index_24");
        this.assertParseIndexRule(this.addNullByte(4, "/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMB9bAAACAAABAAAABA=="), "index_24");
        this.assertParseIndexRule(this.addNullByte(5, "/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMB9bAAACAAABAAAABA=="), "index_24");
    }

    @Test
    public void shouldParseUniqueIndexRule() throws Exception {
        this.assertParseUniqueIndexRule("/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMCAAAAAAAAAAC1sAAAA9AAEAAAPc", "index_33");
        this.assertParseUniqueIndexRule("AAAAPQIAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMAABAAAAAAAAA9wAAAAAAAAACw==", "index_33");
        this.assertParseUniqueIndexRule("/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMCAAAAAAAAAAC1sAAAA9AAEAAAPcAAAAC2N1c3RvbV9uYW1l", "custom_name");
        this.assertParseUniqueIndexRule(this.addNullByte("/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMCAAAAAAAAAAC1sAAAA9AAEAAAPc"), "index_33");
        this.assertParseUniqueIndexRule(this.addNullByte(2, "/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMCAAAAAAAAAAC1sAAAA9AAEAAAPc"), "index_33");
        this.assertParseUniqueIndexRule(this.addNullByte(3, "/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMCAAAAAAAAAAC1sAAAA9AAEAAAPc"), "index_33");
        this.assertParseUniqueIndexRule(this.addNullByte(4, "/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMCAAAAAAAAAAC1sAAAA9AAEAAAPc"), "index_33");
        this.assertParseUniqueIndexRule(this.addNullByte(5, "/////wsAAAAOaW5kZXgtcHJvdmlkZXIAAAAEMjUuMCAAAAAAAAAAC1sAAAA9AAEAAAPc"), "index_33");
    }

    @Test
    public void shouldParseUniqueConstraintRule() throws Exception {
        this.assertParseUniqueConstraintRule("/////ww+AAAAAAAAAAJbAAAANwABAAAAAw==", "constraint_1");
        this.assertParseUniqueConstraintRule("AAAANwMBAAAAAAAAAAMAAAAAAAAAAg==", "constraint_1");
        this.assertParseUniqueConstraintRule("/////ww+AAAAAAAAAAJbAAAANwABAAAAAwAAAAtjdXN0b21fbmFtZQ==", "custom_name");
        this.assertParseUniqueConstraintRule(this.addNullByte("/////ww+AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
        this.assertParseUniqueConstraintRule(this.addNullByte(2, "/////ww+AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
        this.assertParseUniqueConstraintRule(this.addNullByte(3, "/////ww+AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
        this.assertParseUniqueConstraintRule(this.addNullByte(4, "/////ww+AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
        this.assertParseUniqueConstraintRule(this.addNullByte(5, "/////ww+AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
    }

    @Test
    public void shouldParseNodeKeyConstraintRule() throws Exception {
        this.assertParseNodeKeyConstraintRule("/////ww/AAAAAAAAAAJbAAAANwABAAAAAw==", "constraint_1");
        this.assertParseNodeKeyConstraintRule("/////ww/AAAAAAAAAAJbAAAANwABAAAAAwAAAAtjdXN0b21fbmFtZQ==", "custom_name");
        this.assertParseNodeKeyConstraintRule(this.addNullByte("/////ww/AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
        this.assertParseNodeKeyConstraintRule(this.addNullByte(2, "/////ww/AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
        this.assertParseNodeKeyConstraintRule(this.addNullByte(3, "/////ww/AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
        this.assertParseNodeKeyConstraintRule(this.addNullByte(4, "/////ww/AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
        this.assertParseNodeKeyConstraintRule(this.addNullByte(5, "/////ww/AAAAAAAAAAJbAAAANwABAAAAAw=="), "constraint_1");
    }

    @Test
    public void shouldParseNodePropertyExistsRule() throws Exception {
        this.assertParseNodePropertyExistsRule("/////ww9WwAAAC0AAQAAADM=", "constraint_87");
        this.assertParseNodePropertyExistsRule("AAAALQQAAAAz", "constraint_87");
        this.assertParseNodePropertyExistsRule("/////ww9WwAAAC0AAQAAADMAAAALY3VzdG9tX25hbWU=", "custom_name");
        this.assertParseNodePropertyExistsRule(this.addNullByte("/////ww9WwAAAC0AAQAAADM="), "constraint_87");
        this.assertParseNodePropertyExistsRule(this.addNullByte(2, "/////ww9WwAAAC0AAQAAADM="), "constraint_87");
        this.assertParseNodePropertyExistsRule(this.addNullByte(3, "/////ww9WwAAAC0AAQAAADM="), "constraint_87");
        this.assertParseNodePropertyExistsRule(this.addNullByte(4, "/////ww9WwAAAC0AAQAAADM="), "constraint_87");
        this.assertParseNodePropertyExistsRule(this.addNullByte(5, "/////ww9WwAAAC0AAQAAADM="), "constraint_87");
    }

    @Test
    public void shouldParseRelationshipPropertyExistsRule() throws Exception {
        this.assertParseRelationshipPropertyExistsRule("/////ww9XAAAIUAAAQAAF+c=", "constraint_51");
        this.assertParseRelationshipPropertyExistsRule("AAAhQAUAABfn", "constraint_51");
        this.assertParseRelationshipPropertyExistsRule("/////ww9XAAAIUAAAQAAF+cAAAALY3VzdG9tX25hbWU=", "custom_name");
        this.assertParseRelationshipPropertyExistsRule(this.addNullByte("/////ww9XAAAIUAAAQAAF+c="), "constraint_51");
        this.assertParseRelationshipPropertyExistsRule(this.addNullByte(2, "/////ww9XAAAIUAAAQAAF+c="), "constraint_51");
        this.assertParseRelationshipPropertyExistsRule(this.addNullByte(3, "/////ww9XAAAIUAAAQAAF+c="), "constraint_51");
        this.assertParseRelationshipPropertyExistsRule(this.addNullByte(4, "/////ww9XAAAIUAAAQAAF+c="), "constraint_51");
        this.assertParseRelationshipPropertyExistsRule(this.addNullByte(5, "/////ww9XAAAIUAAAQAAF+c="), "constraint_51");
    }

    private void assertParseIndexRule(String serialized, String name) throws Exception {
        long ruleId = 24L;
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)512, (int[])new int[]{4});
        SchemaIndexProvider.Descriptor indexProvider = new SchemaIndexProvider.Descriptor("index-provider", "25.0");
        byte[] bytes = this.decodeBase64(serialized);
        IndexRule deserialized = this.assertIndexRule(SchemaRuleSerialization.deserialize((long)ruleId, (ByteBuffer)ByteBuffer.wrap(bytes)));
        MatcherAssert.assertThat((Object)deserialized.getId(), (Matcher)Matchers.equalTo((Object)ruleId));
        MatcherAssert.assertThat((Object)deserialized.getIndexDescriptor(), (Matcher)Matchers.equalTo((Object)index));
        MatcherAssert.assertThat((Object)deserialized.schema(), (Matcher)Matchers.equalTo((Object)index.schema()));
        MatcherAssert.assertThat((Object)deserialized.getProviderDescriptor(), (Matcher)Matchers.equalTo((Object)indexProvider));
        MatcherAssert.assertThat((Object)deserialized.getName(), (Matcher)Matchers.is((Object)name));
        org.neo4j.test.assertion.Assert.assertException(() -> ((IndexRule)deserialized).getOwningConstraint(), IllegalStateException.class);
    }

    private void assertParseUniqueIndexRule(String serialized, String name) throws MalformedSchemaRuleException {
        long ruleId = 33L;
        long constraintId = 11L;
        IndexDescriptor index = IndexDescriptorFactory.uniqueForLabel((int)61, (int[])new int[]{988});
        SchemaIndexProvider.Descriptor indexProvider = new SchemaIndexProvider.Descriptor("index-provider", "25.0");
        byte[] bytes = this.decodeBase64(serialized);
        IndexRule deserialized = this.assertIndexRule(SchemaRuleSerialization.deserialize((long)ruleId, (ByteBuffer)ByteBuffer.wrap(bytes)));
        MatcherAssert.assertThat((Object)deserialized.getId(), (Matcher)Matchers.equalTo((Object)ruleId));
        MatcherAssert.assertThat((Object)deserialized.getIndexDescriptor(), (Matcher)Matchers.equalTo((Object)index));
        MatcherAssert.assertThat((Object)deserialized.schema(), (Matcher)Matchers.equalTo((Object)index.schema()));
        MatcherAssert.assertThat((Object)deserialized.getProviderDescriptor(), (Matcher)Matchers.equalTo((Object)indexProvider));
        MatcherAssert.assertThat((Object)deserialized.getOwningConstraint(), (Matcher)Matchers.equalTo((Object)constraintId));
        MatcherAssert.assertThat((Object)deserialized.getName(), (Matcher)Matchers.is((Object)name));
    }

    private void assertParseUniqueConstraintRule(String serialized, String name) throws MalformedSchemaRuleException {
        long ruleId = 1L;
        int propertyKey = 3;
        int labelId = 55;
        long ownedIndexId = 2L;
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyKey});
        byte[] bytes = this.decodeBase64(serialized);
        ConstraintRule deserialized = this.assertConstraintRule(SchemaRuleSerialization.deserialize((long)ruleId, (ByteBuffer)ByteBuffer.wrap(bytes)));
        MatcherAssert.assertThat((Object)deserialized.getId(), (Matcher)Matchers.equalTo((Object)ruleId));
        MatcherAssert.assertThat((Object)deserialized.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)constraint));
        MatcherAssert.assertThat((Object)deserialized.schema(), (Matcher)Matchers.equalTo((Object)constraint.schema()));
        MatcherAssert.assertThat((Object)deserialized.getOwnedIndex(), (Matcher)Matchers.equalTo((Object)ownedIndexId));
        MatcherAssert.assertThat((Object)deserialized.getName(), (Matcher)Matchers.is((Object)name));
    }

    private void assertParseNodeKeyConstraintRule(String serialized, String name) throws MalformedSchemaRuleException {
        long ruleId = 1L;
        int propertyKey = 3;
        int labelId = 55;
        long ownedIndexId = 2L;
        NodeKeyConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeKeyForLabel((int)labelId, (int[])new int[]{propertyKey});
        byte[] bytes = this.decodeBase64(serialized);
        ConstraintRule deserialized = this.assertConstraintRule(SchemaRuleSerialization.deserialize((long)ruleId, (ByteBuffer)ByteBuffer.wrap(bytes)));
        MatcherAssert.assertThat((Object)deserialized.getId(), (Matcher)Matchers.equalTo((Object)ruleId));
        MatcherAssert.assertThat((Object)deserialized.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)constraint));
        MatcherAssert.assertThat((Object)deserialized.schema(), (Matcher)Matchers.equalTo((Object)constraint.schema()));
        MatcherAssert.assertThat((Object)deserialized.getOwnedIndex(), (Matcher)Matchers.equalTo((Object)ownedIndexId));
        MatcherAssert.assertThat((Object)deserialized.getName(), (Matcher)Matchers.is((Object)name));
    }

    private void assertParseNodePropertyExistsRule(String serialized, String name) throws Exception {
        long ruleId = 87L;
        int propertyKey = 51;
        int labelId = 45;
        NodeExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])new int[]{propertyKey});
        byte[] bytes = this.decodeBase64(serialized);
        ConstraintRule deserialized = this.assertConstraintRule(SchemaRuleSerialization.deserialize((long)ruleId, (ByteBuffer)ByteBuffer.wrap(bytes)));
        MatcherAssert.assertThat((Object)deserialized.getId(), (Matcher)Matchers.equalTo((Object)ruleId));
        MatcherAssert.assertThat((Object)deserialized.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)constraint));
        MatcherAssert.assertThat((Object)deserialized.schema(), (Matcher)Matchers.equalTo((Object)constraint.schema()));
        org.neo4j.test.assertion.Assert.assertException(() -> ((ConstraintRule)deserialized).getOwnedIndex(), IllegalStateException.class);
        MatcherAssert.assertThat((Object)deserialized.getName(), (Matcher)Matchers.is((Object)name));
    }

    private void assertParseRelationshipPropertyExistsRule(String serialized, String name) throws Exception {
        long ruleId = 51L;
        int propertyKey = 6119;
        int relTypeId = 8512;
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{propertyKey});
        byte[] bytes = this.decodeBase64(serialized);
        ConstraintRule deserialized = this.assertConstraintRule(SchemaRuleSerialization.deserialize((long)ruleId, (ByteBuffer)ByteBuffer.wrap(bytes)));
        MatcherAssert.assertThat((Object)deserialized.getId(), (Matcher)Matchers.equalTo((Object)ruleId));
        MatcherAssert.assertThat((Object)deserialized.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)constraint));
        MatcherAssert.assertThat((Object)deserialized.schema(), (Matcher)Matchers.equalTo((Object)constraint.schema()));
        org.neo4j.test.assertion.Assert.assertException(() -> ((ConstraintRule)deserialized).getOwnedIndex(), IllegalStateException.class);
        MatcherAssert.assertThat((Object)deserialized.getName(), (Matcher)Matchers.is((Object)name));
    }

    private void assertSerializeAndDeserializeIndexRule(IndexRule indexRule) throws MalformedSchemaRuleException {
        IndexRule deserialized = this.assertIndexRule(this.serialiseAndDeserialise(indexRule));
        MatcherAssert.assertThat((Object)deserialized.getId(), (Matcher)Matchers.equalTo((Object)indexRule.getId()));
        MatcherAssert.assertThat((Object)deserialized.getIndexDescriptor(), (Matcher)Matchers.equalTo((Object)indexRule.getIndexDescriptor()));
        MatcherAssert.assertThat((Object)deserialized.schema(), (Matcher)Matchers.equalTo((Object)indexRule.schema()));
        MatcherAssert.assertThat((Object)deserialized.getProviderDescriptor(), (Matcher)Matchers.equalTo((Object)indexRule.getProviderDescriptor()));
    }

    private IndexRule assertIndexRule(SchemaRule schemaRule) {
        if (!(schemaRule instanceof IndexRule)) {
            Assert.fail((String)("Expected IndexRule, but got " + schemaRule.getClass().getSimpleName()));
        }
        return (IndexRule)schemaRule;
    }

    private void assertSerializeAndDeserializeConstraintRule(ConstraintRule constraintRule) throws MalformedSchemaRuleException {
        ConstraintRule deserialized = this.assertConstraintRule(this.serialiseAndDeserialise(constraintRule));
        MatcherAssert.assertThat((Object)deserialized.getId(), (Matcher)Matchers.equalTo((Object)constraintRule.getId()));
        MatcherAssert.assertThat((Object)deserialized.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)constraintRule.getConstraintDescriptor()));
        MatcherAssert.assertThat((Object)deserialized.schema(), (Matcher)Matchers.equalTo((Object)constraintRule.schema()));
    }

    private SchemaRule serialiseAndDeserialise(ConstraintRule constraintRule) throws MalformedSchemaRuleException {
        ByteBuffer buffer = ByteBuffer.wrap(constraintRule.serialize());
        return SchemaRuleSerialization.deserialize((long)constraintRule.getId(), (ByteBuffer)buffer);
    }

    private SchemaRule serialiseAndDeserialise(IndexRule indexRule) throws MalformedSchemaRuleException {
        ByteBuffer buffer = ByteBuffer.wrap(indexRule.serialize());
        return SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)buffer);
    }

    private ConstraintRule assertConstraintRule(SchemaRule schemaRule) {
        if (!(schemaRule instanceof ConstraintRule)) {
            Assert.fail((String)("Expected ConstraintRule, but got " + schemaRule.getClass().getSimpleName()));
        }
        return (ConstraintRule)schemaRule;
    }

    private void assertCorrectLength(IndexRule indexRule) throws MalformedSchemaRuleException {
        ByteBuffer buffer = ByteBuffer.wrap(indexRule.serialize());
        MatcherAssert.assertThat((Object)SchemaRuleSerialization.lengthOf((IndexRule)indexRule), (Matcher)Matchers.equalTo((Object)buffer.capacity()));
    }

    private void assertCorrectLength(ConstraintRule constraintRule) throws MalformedSchemaRuleException {
        ByteBuffer buffer = ByteBuffer.wrap(constraintRule.serialize());
        MatcherAssert.assertThat((Object)SchemaRuleSerialization.lengthOf((ConstraintRule)constraintRule), (Matcher)Matchers.equalTo((Object)buffer.capacity()));
    }

    private byte[] decodeBase64(String serialized) {
        return Base64.getDecoder().decode(serialized);
    }

    private String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private String addNullByte(String input) {
        byte[] inputBytes = this.decodeBase64(input);
        byte[] outputBytes = Arrays.copyOf(inputBytes, inputBytes.length + 1);
        return this.encodeBase64(outputBytes);
    }

    private String addNullByte(int nullByteCountToAdd, String input) {
        if (nullByteCountToAdd < 1) {
            return input;
        }
        if (nullByteCountToAdd == 1) {
            return this.addNullByte(input);
        }
        return this.addNullByte(this.addNullByte(nullByteCountToAdd - 1, input));
    }
}

