/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.cursor.IOCursor;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryReader;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogFilenames;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LegacyLogEntryReaderTest {
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private final FileSystemAbstraction fs = this.fileSystemRule.get();
    private final File input = new File(LegacyLogFilenames.getLegacyLogFilename((int)3));

    @Before
    public void setup() throws IOException {
        LogHeaderWriter.writeLogHeader((FileSystemAbstraction)this.fs, (File)this.input, (long)3L, (long)-1L);
    }

    @Test
    public void shouldReadTheLogHeaderAndSetCurrentVersionAndABaseTxIdIfNegative() throws IOException {
        LegacyLogEntryReader reader = new LegacyLogEntryReader(this.fs);
        Pair pair = reader.openReadableChannel(this.input);
        ((IOCursor)pair.other()).close();
        Assert.assertEquals((Object)new LogHeader(6, 3L, 1L), (Object)pair.first());
    }

    @Test
    public void shouldReturnNoEntriesWhenTheChannelContainsNothing() throws IOException {
        final LogEntryReader logEntryReader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
        Mockito.when((Object)logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn(null);
        LegacyLogEntryReader reader = new LegacyLogEntryReader(this.fs, (Function)new Function<LogHeader, LogEntryReader<ReadableLogChannel>>(){

            @Override
            public LogEntryReader<ReadableLogChannel> apply(LogHeader from) throws RuntimeException {
                return logEntryReader;
            }
        });
        IOCursor cursor = (IOCursor)reader.openReadableChannel(this.input).other();
        Assert.assertFalse((boolean)cursor.next());
        Assert.assertNull((Object)cursor.get());
        cursor.close();
    }

    @Test
    public void shouldReadTheEntries() throws IOException {
        LogEntryStart start = new LogEntryStart(0, 1, 2L, 3L, LogEntryStart.EMPTY_ADDITIONAL_ARRAY, LogPosition.UNSPECIFIED);
        NodeRecord record = new NodeRecord(42L);
        LogEntryCommand command = new LogEntryCommand((StorageCommand)new Command.NodeCommand(record, record));
        OnePhaseCommit commit = new OnePhaseCommit(42L, 43L);
        LogEntryReader logEntryReader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
        Mockito.when((Object)logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)new IdentifiableLogEntry((LogEntry)start, 1), (Object[])new LogEntry[]{new IdentifiableLogEntry((LogEntry)command, 1), new IdentifiableLogEntry((LogEntry)commit, 1), null});
        LegacyLogEntryReader reader = new LegacyLogEntryReader(this.fs, from -> logEntryReader);
        IOCursor cursor = (IOCursor)reader.openReadableChannel(this.input).other();
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertEquals((Object)start, (Object)cursor.get());
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertEquals((Object)command, (Object)cursor.get());
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertEquals((Object)commit, (Object)cursor.get());
        Assert.assertFalse((boolean)cursor.next());
        cursor.close();
    }
}

