/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.ClassGuardedAdversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.internal.EmbeddedGraphDatabase;
import org.neo4j.test.rule.TestDirectory;

public class PartialTransactionFailureIT {
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentlyCommittingTransactionsMustNotRotateOutLoggedCommandsOfFailingTransaction() throws Exception {
        Node d;
        Node c;
        Node b;
        Node a;
        final ClassGuardedAdversary adversary = new ClassGuardedAdversary((Adversary)new CountingAdversary(1, false), new Class[]{Command.RelationshipCommand.class});
        adversary.disable();
        File storeDir = this.dir.graphDbDir();
        Map params = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m"});
        TestEmbeddedGraphDatabase db = new TestEmbeddedGraphDatabase(storeDir, params){

            protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

                    protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                        return new PlatformModule(storeDir, config, this.databaseInfo, dependencies, graphDatabaseFacade){

                            protected FileSystemAbstraction createFileSystemAbstraction() {
                                return new AdversarialFileSystemAbstraction((Adversary)adversary);
                            }
                        };
                    }
                }.initFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
            }
        };
        try (Transaction tx = db.beginTx();){
            a = db.createNode();
            b = db.createNode();
            c = db.createNode();
            d = db.createNode();
            tx.success();
        }
        adversary.enable();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t1 = new Thread(this.createRelationship(db, a, b, latch), "T1");
        Thread t2 = new Thread(this.createRelationship(db, c, d, latch), "T2");
        t1.start();
        t2.start();
        t1.join(10L);
        t2.join(10L);
        latch.countDown();
        t1.join(25000L);
        t2.join(25000L);
        db.shutdown();
        TestEmbeddedGraphDatabase db2 = new TestEmbeddedGraphDatabase(storeDir, params);
        try (Transaction tx = db2.beginTx();){
            Relationship rel;
            Node x = db2.getNodeById(a.getId());
            Node y = db2.getNodeById(b.getId());
            Node z = db2.getNodeById(c.getId());
            Node w = db2.getNodeById(d.getId());
            Iterator itrRelX = x.getRelationships().iterator();
            Iterator itrRelY = y.getRelationships().iterator();
            Iterator itrRelZ = z.getRelationships().iterator();
            Iterator itrRelW = w.getRelationships().iterator();
            if (itrRelX.hasNext() != itrRelY.hasNext()) {
                Assert.fail((String)"Node x and y have inconsistent relationship counts");
            } else if (itrRelX.hasNext()) {
                rel = (Relationship)itrRelX.next();
                Assert.assertEquals((Object)rel, itrRelY.next());
                Assert.assertFalse((boolean)itrRelX.hasNext());
                Assert.assertFalse((boolean)itrRelY.hasNext());
            }
            if (itrRelZ.hasNext() != itrRelW.hasNext()) {
                Assert.fail((String)"Node z and w have inconsistent relationship counts");
            } else if (itrRelZ.hasNext()) {
                rel = (Relationship)itrRelZ.next();
                Assert.assertEquals((Object)rel, itrRelW.next());
                Assert.assertFalse((boolean)itrRelZ.hasNext());
                Assert.assertFalse((boolean)itrRelW.hasNext());
            }
        }
        finally {
            db2.shutdown();
        }
    }

    private Runnable createRelationship(final EmbeddedGraphDatabase db, final Node x, final Node y, final CountDownLatch latch) {
        return new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = db.beginTx();){
                    x.createRelationshipTo(y, RelationshipType.withName((String)"r"));
                    tx.success();
                    latch.await();
                    ((LogRotation)db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
                    ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private static class TestEmbeddedGraphDatabase
    extends EmbeddedGraphDatabase {
        TestEmbeddedGraphDatabase(File storeDir, Map<String, String> params) {
            super(storeDir, params, TestEmbeddedGraphDatabase.dependencies());
        }

        private static GraphDatabaseFacadeFactory.Dependencies dependencies() {
            GraphDatabaseFactoryState state = new GraphDatabaseFactoryState();
            state.addKernelExtensions(Arrays.asList(new KernelExtensionFactory[]{new InMemoryIndexProviderFactory()}));
            return state.databaseDependencies();
        }
    }
}

