/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;

public class PhysicalLogFilesTest {
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final File tmpDirectory = new File(".");
    private final String filename = "filename";

    @Test
    public void shouldGetTheFileNameForAGivenVersion() {
        PhysicalLogFiles files = new PhysicalLogFiles(this.tmpDirectory, "filename", this.fs);
        int version = 12;
        File versionFileName = files.getLogFileForVersion(12L);
        File expected = new File(this.tmpDirectory, "filename.12");
        Assert.assertEquals((Object)expected, (Object)versionFileName);
    }

    @Test
    public void shouldVisitEachLofFile() {
        PhysicalLogFiles files = new PhysicalLogFiles(this.tmpDirectory, "filename", this.fs);
        File[] filesOnDisk = new File[]{new File(this.tmpDirectory, "filename.1"), new File(this.tmpDirectory, "crap.2"), new File(this.tmpDirectory, "filename.3"), new File(this.tmpDirectory, "filename")};
        Mockito.when((Object)this.fs.listFiles(this.tmpDirectory)).thenReturn((Object)filesOnDisk);
        final ArrayList seenFiles = new ArrayList();
        final ArrayList seenVersions = new ArrayList();
        files.accept(new PhysicalLogFiles.LogVersionVisitor(){

            public void visit(File file, long logVersion) {
                seenFiles.add(file);
                seenVersions.add(logVersion);
            }
        });
        Assert.assertEquals(Arrays.asList(new File(this.tmpDirectory, "filename.1"), new File(this.tmpDirectory, "filename.3")), seenFiles);
        Assert.assertEquals(Arrays.asList(1L, 3L), seenVersions);
    }

    @Test
    public void shouldBeAbleToRetrieveTheHighestLogVersion() {
        PhysicalLogFiles files = new PhysicalLogFiles(this.tmpDirectory, "filename", this.fs);
        File[] filesOnDisk = new File[]{new File(this.tmpDirectory, "filename.1"), new File(this.tmpDirectory, "crap.4"), new File(this.tmpDirectory, "filename.3"), new File(this.tmpDirectory, "filename")};
        Mockito.when((Object)this.fs.listFiles(this.tmpDirectory)).thenReturn((Object)filesOnDisk);
        long highestLogVersion = files.getHighestLogVersion();
        Assert.assertEquals((long)3L, (long)highestLogVersion);
    }

    @Test
    public void shouldReturnANegativeValueIfThereAreNoLogFiles() {
        PhysicalLogFiles files = new PhysicalLogFiles(this.tmpDirectory, "filename", this.fs);
        File[] filesOnDisk = new File[]{new File(this.tmpDirectory, "crap.4"), new File(this.tmpDirectory, "filename")};
        Mockito.when((Object)this.fs.listFiles(this.tmpDirectory)).thenReturn((Object)filesOnDisk);
        long highestLogVersion = files.getHighestLogVersion();
        Assert.assertEquals((long)-1L, (long)highestLogVersion);
    }

    @Test
    public void shouldFindTheVersionBasedOnTheFilename() {
        File file = new File("v...2");
        long logVersion = PhysicalLogFiles.getLogVersion((File)file);
        Assert.assertEquals((long)2L, (long)logVersion);
    }

    @Test
    public void shouldThrowIfThereIsNoVersionInTheFileName() {
        File file = new File("wrong");
        try {
            PhysicalLogFiles.getLogVersion((File)file);
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((Object)("Invalid log file '" + file.getName() + "'"), (Object)ex.getMessage());
        }
    }

    @Test(expected=NumberFormatException.class)
    public void shouldThrowIfVersionIsNotANumber() {
        File file = new File("aa.A");
        PhysicalLogFiles.getLogVersion((File)file);
    }
}

