/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.command.HighIdTransactionApplier;
import org.neo4j.test.rule.NeoStoresRule;

public class HighIdTransactionApplierTest {
    @Rule
    public final NeoStoresRule neoStoresRule = new NeoStoresRule(this.getClass(), new StoreType[0]);

    @Test
    public void shouldUpdateHighIdsOnExternalTransaction() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        HighIdTransactionApplier tracker = new HighIdTransactionApplier(neoStores);
        tracker.visitNodeCommand(Commands.createNode(10L, 2L, 3L));
        tracker.visitNodeCommand(Commands.createNode(20L, 4L, 5L));
        tracker.visitRelationshipCommand(Commands.createRelationship(4L, 10L, 20L, 0));
        tracker.visitRelationshipCommand(Commands.createRelationship(45L, 10L, 20L, 1));
        tracker.visitLabelTokenCommand(Commands.createLabelToken(3, 0));
        tracker.visitLabelTokenCommand(Commands.createLabelToken(5, 1));
        tracker.visitPropertyKeyTokenCommand(Commands.createPropertyKeyToken(3, 0));
        tracker.visitPropertyKeyTokenCommand(Commands.createPropertyKeyToken(5, 1));
        tracker.visitRelationshipTypeTokenCommand(Commands.createRelationshipTypeToken(3, 0));
        tracker.visitRelationshipTypeTokenCommand(Commands.createRelationshipTypeToken(5, 1));
        tracker.visitRelationshipGroupCommand(Commands.createRelationshipGroup(10L, 1));
        tracker.visitRelationshipGroupCommand(Commands.createRelationshipGroup(20L, 2));
        int[] propertyKeyIds = new int[]{1};
        tracker.visitSchemaRuleCommand(Commands.createIndexRule(SchemaIndexProvider.NO_INDEX_PROVIDER.getProviderDescriptor(), 10L, SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
        tracker.visitSchemaRuleCommand(Commands.createIndexRule(SchemaIndexProvider.NO_INDEX_PROVIDER.getProviderDescriptor(), 20L, SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{2})));
        tracker.visitPropertyCommand(Commands.createProperty(10L, PropertyType.STRING, 0, 6L, 7L));
        tracker.visitPropertyCommand(Commands.createProperty(20L, PropertyType.ARRAY, 1, 8L, 9L));
        tracker.close();
        Assert.assertEquals((String)"NodeStore", (long)21L, (long)neoStores.getNodeStore().getHighId());
        Assert.assertEquals((String)"DynamicNodeLabelStore", (long)6L, (long)neoStores.getNodeStore().getDynamicLabelStore().getHighId());
        Assert.assertEquals((String)"RelationshipStore", (long)46L, (long)neoStores.getRelationshipStore().getHighId());
        Assert.assertEquals((String)"RelationshipTypeStore", (long)6L, (long)neoStores.getRelationshipTypeTokenStore().getHighId());
        Assert.assertEquals((String)"RelationshipType NameStore", (long)2L, (long)neoStores.getRelationshipTypeTokenStore().getNameStore().getHighId());
        Assert.assertEquals((String)"PropertyKeyStore", (long)6L, (long)neoStores.getPropertyKeyTokenStore().getHighId());
        Assert.assertEquals((String)"PropertyKey NameStore", (long)2L, (long)neoStores.getPropertyKeyTokenStore().getNameStore().getHighId());
        Assert.assertEquals((String)"LabelStore", (long)6L, (long)neoStores.getLabelTokenStore().getHighId());
        Assert.assertEquals((String)"Label NameStore", (long)2L, (long)neoStores.getLabelTokenStore().getNameStore().getHighId());
        Assert.assertEquals((String)"PropertyStore", (long)21L, (long)neoStores.getPropertyStore().getHighId());
        Assert.assertEquals((String)"PropertyStore DynamicStringStore", (long)8L, (long)neoStores.getPropertyStore().getStringStore().getHighId());
        Assert.assertEquals((String)"PropertyStore DynamicArrayStore", (long)10L, (long)neoStores.getPropertyStore().getArrayStore().getHighId());
        Assert.assertEquals((String)"SchemaStore", (long)21L, (long)neoStores.getSchemaStore().getHighId());
    }

    @Test
    public void shouldTrackSecondaryUnitIdsAsWell() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        HighIdTransactionApplier tracker = new HighIdTransactionApplier(neoStores);
        NodeRecord node = new NodeRecord(5L).initialize(true, 123L, true, 456L, 0L);
        node.setSecondaryUnitId(6L);
        node.setRequiresSecondaryUnit(true);
        RelationshipRecord relationship = new RelationshipRecord(10L).initialize(true, 1L, 2L, 3L, 4, 5L, 6L, 7L, 8L, true, true);
        relationship.setSecondaryUnitId(12L);
        relationship.setRequiresSecondaryUnit(true);
        RelationshipGroupRecord relationshipGroup = new RelationshipGroupRecord(8L).initialize(true, 0, 1L, 2L, 3L, 4L, 5L);
        relationshipGroup.setSecondaryUnitId(20L);
        relationshipGroup.setRequiresSecondaryUnit(true);
        tracker.visitNodeCommand(new Command.NodeCommand(new NodeRecord(node.getId()), node));
        tracker.visitRelationshipCommand(new Command.RelationshipCommand(new RelationshipRecord(relationship.getId()), relationship));
        tracker.visitRelationshipGroupCommand(new Command.RelationshipGroupCommand(new RelationshipGroupRecord(relationshipGroup.getId()), relationshipGroup));
        tracker.close();
        Assert.assertEquals((long)(node.getSecondaryUnitId() + 1L), (long)neoStores.getNodeStore().getHighId());
        Assert.assertEquals((long)(relationship.getSecondaryUnitId() + 1L), (long)neoStores.getRelationshipStore().getHighId());
        Assert.assertEquals((long)(relationshipGroup.getSecondaryUnitId() + 1L), (long)neoStores.getRelationshipGroupStore().getHighId());
    }
}

