/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Random;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChannel;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class PhysicalFlushableChannelTest {
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldBeAbleToWriteSmallNumberOfBytes() throws IOException {
        File firstFile = new File(this.directory.directory(), "file1");
        StoreFileChannel storeChannel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(firstFile, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)storeChannel, 1L, -1);
        PhysicalFlushableChannel channel = new PhysicalFlushableChannel((StoreChannel)versionedStoreChannel);
        int length = 26145;
        byte[] bytes = this.generateBytes(length);
        channel.put(bytes, length);
        channel.close();
        byte[] writtenBytes = new byte[length];
        try (FileInputStream in = new FileInputStream(firstFile);){
            ((InputStream)in).read(writtenBytes);
        }
        Assert.assertArrayEquals((byte[])bytes, (byte[])writtenBytes);
    }

    @Test
    public void shouldBeAbleToWriteValuesGreaterThanHalfTheBufferSize() throws IOException {
        File firstFile = new File(this.directory.directory(), "file1");
        StoreFileChannel storeChannel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(firstFile, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)storeChannel, 1L, -1);
        PhysicalFlushableChannel channel = new PhysicalFlushableChannel((StoreChannel)versionedStoreChannel);
        int length = 262145;
        byte[] bytes = this.generateBytes(length);
        channel.put(bytes, length);
        channel.close();
        byte[] writtenBytes = new byte[length];
        try (FileInputStream in = new FileInputStream(firstFile);){
            ((InputStream)in).read(writtenBytes);
        }
        Assert.assertArrayEquals((byte[])bytes, (byte[])writtenBytes);
    }

    @Test
    public void shouldBeAbleToWriteValuesGreaterThanTheBufferSize() throws IOException {
        File firstFile = new File(this.directory.directory(), "file1");
        StoreFileChannel storeChannel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(firstFile, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)storeChannel, 1L, -1);
        PhysicalFlushableChannel channel = new PhysicalFlushableChannel((StoreChannel)versionedStoreChannel);
        int length = 1000000;
        byte[] bytes = this.generateBytes(length);
        channel.put(bytes, length);
        channel.close();
        byte[] writtenBytes = new byte[length];
        try (FileInputStream in = new FileInputStream(firstFile);){
            ((InputStream)in).read(writtenBytes);
        }
        Assert.assertArrayEquals((byte[])bytes, (byte[])writtenBytes);
    }

    private byte[] generateBytes(int length) {
        Random random = new Random();
        char[] validCharacters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o'};
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)validCharacters[random.nextInt(validCharacters.length)];
        }
        return bytes;
    }

    @Test
    public void shouldWriteThroughRotation() throws Exception {
        File firstFile = new File(this.directory.directory(), "file1");
        File secondFile = new File(this.directory.directory(), "file2");
        StoreFileChannel storeChannel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(firstFile, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)storeChannel, 1L, -1);
        PhysicalFlushableChannel channel = new PhysicalFlushableChannel((StoreChannel)versionedStoreChannel);
        byte byteValue = 4;
        short shortValue = 10;
        int intValue = 3545;
        long longValue = 45849589L;
        float floatValue = 45849.332f;
        double doubleValue = 4.58493343E8;
        byte[] byteArrayValue = new byte[]{1, 4, 2, 5, 3, 6};
        channel.put(byteValue);
        channel.putShort(shortValue);
        channel.putInt(intValue);
        channel.putLong(longValue);
        channel.prepareForFlush().flush();
        channel.close();
        storeChannel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(secondFile, "rw");
        channel.setChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel((StoreChannel)storeChannel, 2L, -1));
        channel.putFloat(floatValue);
        channel.putDouble(doubleValue);
        channel.put(byteArrayValue, byteArrayValue.length);
        channel.close();
        ByteBuffer firstFileContents = this.readFile(firstFile);
        Assert.assertEquals((long)byteValue, (long)firstFileContents.get());
        Assert.assertEquals((long)shortValue, (long)firstFileContents.getShort());
        Assert.assertEquals((long)intValue, (long)firstFileContents.getInt());
        Assert.assertEquals((long)longValue, (long)firstFileContents.getLong());
        ByteBuffer secondFileContents = this.readFile(secondFile);
        Assert.assertEquals((float)floatValue, (float)secondFileContents.getFloat(), (float)0.0f);
        Assert.assertEquals((double)doubleValue, (double)secondFileContents.getDouble(), (double)0.0);
        byte[] readByteArray = new byte[byteArrayValue.length];
        secondFileContents.get(readByteArray);
        Assert.assertArrayEquals((byte[])byteArrayValue, (byte[])readByteArray);
    }

    @Test
    public void shouldSeeCorrectPositionEvenBeforeEmptyingDataIntoChannel() throws Exception {
        File file = new File(this.directory.directory(), "file");
        StoreFileChannel storeChannel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(file, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)storeChannel, 1L, -1);
        PositionAwarePhysicalFlushableChannel channel = new PositionAwarePhysicalFlushableChannel((LogVersionedStoreChannel)versionedStoreChannel);
        LogPositionMarker positionMarker = new LogPositionMarker();
        LogPosition initialPosition = channel.getCurrentPosition(positionMarker).newPosition();
        channel.putLong(67L);
        channel.putInt(1234);
        LogPosition positionAfterSomeData = channel.getCurrentPosition(positionMarker).newPosition();
        Assert.assertEquals((long)12L, (long)(positionAfterSomeData.getByteOffset() - initialPosition.getByteOffset()));
        channel.close();
    }

    @Test
    public void shouldThrowIllegalStateExceptionAfterClosed() throws Exception {
        File file = new File(this.directory.directory(), "file");
        StoreFileChannel storeChannel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(file, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)storeChannel, 1L, -1);
        PhysicalFlushableChannel channel = new PhysicalFlushableChannel((StoreChannel)versionedStoreChannel);
        channel.close();
        storeChannel.close();
        channel.put((byte)0);
        try {
            channel.prepareForFlush();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowClosedChannelExceptionWhenChannelUnexpectedlyClosed() throws Exception {
        File file = new File(this.directory.directory(), "file");
        StoreFileChannel storeChannel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(file, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)storeChannel, 1L, -1);
        PhysicalFlushableChannel channel = new PhysicalFlushableChannel((StoreChannel)versionedStoreChannel);
        storeChannel.close();
        channel.put((byte)0);
        try {
            channel.prepareForFlush();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    private ByteBuffer readFile(File file) throws IOException {
        try (StoreFileChannel channel = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(file, "r");){
            ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
            channel.read(buffer);
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }
}

