/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.storageengine.api.StorageCommand;

public class TransactionPositionLocatorTest {
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
    private final ReadableClosablePositionAwareChannel channel = (ReadableClosablePositionAwareChannel)Mockito.mock(ReadableClosablePositionAwareChannel.class);
    private final TransactionMetadataCache metadataCache = (TransactionMetadataCache)Mockito.mock(TransactionMetadataCache.class);
    private final long txId = 42L;
    private final LogPosition startPosition = new LogPosition(1L, 128L);
    private final LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, null, this.startPosition);
    private final LogEntryCommand command = new LogEntryCommand((StorageCommand)new Command.NodeCommand(new NodeRecord(42L), new NodeRecord(42L)));
    private final LogEntryCommit commit = new OnePhaseCommit(42L, System.currentTimeMillis());

    @Test
    public void shouldFindTransactionLogPosition() throws IOException {
        PhysicalLogicalTransactionStore.TransactionPositionLocator locator = new PhysicalLogicalTransactionStore.TransactionPositionLocator(42L, this.logEntryReader);
        Mockito.when((Object)this.logEntryReader.readLogEntry(this.channel)).thenReturn((Object)this.start, (Object[])new LogEntry[]{this.command, this.commit, null});
        boolean result = locator.visit(this.startPosition, this.channel);
        LogPosition position = locator.getAndCacheFoundLogPosition(this.metadataCache);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)this.startPosition, (Object)position);
        ((TransactionMetadataCache)Mockito.verify((Object)this.metadataCache, (VerificationMode)Mockito.times((int)1))).cacheTransactionMetadata(42L, this.startPosition, this.start.getMasterId(), this.start.getLocalId(), LogEntryStart.checksum((LogEntryStart)this.start), this.commit.getTimeWritten());
    }

    @Test
    public void shouldNotFindTransactionLogPosition() throws IOException {
        PhysicalLogicalTransactionStore.TransactionPositionLocator locator = new PhysicalLogicalTransactionStore.TransactionPositionLocator(42L, this.logEntryReader);
        Mockito.when((Object)this.logEntryReader.readLogEntry(this.channel)).thenReturn((Object)this.start, (Object[])new LogEntry[]{this.command, null});
        boolean result = locator.visit(this.startPosition, this.channel);
        Assert.assertTrue((boolean)result);
        try {
            locator.getAndCacheFoundLogPosition(this.metadataCache);
            Assert.fail((String)"should have thrown");
        }
        catch (NoSuchTransactionException e) {
            Assert.assertEquals((Object)"Unable to find transaction 42 in any of my logical logs", (Object)e.getMessage());
        }
    }
}

