/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.Flushable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OnDemandJobScheduler;

public class CheckPointSchedulerTest {
    private final IOLimiter ioLimiter = (IOLimiter)Mockito.mock(IOLimiter.class);
    private final CheckPointer checkPointer = (CheckPointer)Mockito.mock(CheckPointer.class);
    private final OnDemandJobScheduler jobScheduler = (OnDemandJobScheduler)((Object)Mockito.spy((Object)((Object)new OnDemandJobScheduler())));
    private final DatabaseHealth health = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);

    @Test
    public void shouldScheduleTheCheckPointerJobOnStart() throws Throwable {
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, this.ioLimiter, (JobScheduler)this.jobScheduler, 20L, this.health);
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Assert.assertNotNull((Object)this.jobScheduler.getJob());
        ((OnDemandJobScheduler)((Object)Mockito.verify((Object)((Object)this.jobScheduler), (VerificationMode)Mockito.times((int)1)))).schedule((JobScheduler.Group)Matchers.eq((Object)JobScheduler.Groups.checkPoint), (Runnable)Matchers.any(Runnable.class), Matchers.eq((long)20L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void shouldRescheduleTheJobAfterARun() throws Throwable {
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, this.ioLimiter, (JobScheduler)this.jobScheduler, 20L, this.health);
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Runnable scheduledJob = this.jobScheduler.getJob();
        Assert.assertNotNull((Object)scheduledJob);
        this.jobScheduler.runJob();
        ((OnDemandJobScheduler)((Object)Mockito.verify((Object)((Object)this.jobScheduler), (VerificationMode)Mockito.times((int)2)))).schedule((JobScheduler.Group)Matchers.eq((Object)JobScheduler.Groups.checkPoint), (Runnable)Matchers.any(Runnable.class), Matchers.eq((long)20L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((CheckPointer)Mockito.verify((Object)this.checkPointer, (VerificationMode)Mockito.times((int)1))).checkPointIfNeeded((TriggerInfo)Matchers.any(TriggerInfo.class));
        Assert.assertEquals((Object)scheduledJob, (Object)this.jobScheduler.getJob());
    }

    @Test
    public void shouldNotRescheduleAJobWhenStopped() throws Throwable {
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, this.ioLimiter, (JobScheduler)this.jobScheduler, 20L, this.health);
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Assert.assertNotNull((Object)this.jobScheduler.getJob());
        scheduler.stop();
        Assert.assertNull((Object)this.jobScheduler.getJob());
    }

    @Test
    public void stoppedJobCantBeInvoked() throws Throwable {
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, this.ioLimiter, (JobScheduler)this.jobScheduler, 10L, this.health);
        scheduler.start();
        this.jobScheduler.runJob();
        ((CheckPointer)Mockito.verify((Object)this.checkPointer)).checkPointIfNeeded((TriggerInfo)Matchers.any(TriggerInfo.class));
        scheduler.stop();
        scheduler.start();
        this.jobScheduler.runJob();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.checkPointer});
    }

    @Test
    public void shouldWaitOnStopUntilTheRunningCheckpointIsDone() throws Throwable {
        final AtomicReference ex = new AtomicReference();
        final AtomicBoolean stoppedCompleted = new AtomicBoolean();
        final DoubleLatch checkPointerLatch = new DoubleLatch(1);
        CheckPointer checkPointer = new CheckPointer(){

            public long checkPointIfNeeded(TriggerInfo triggerInfo) throws IOException {
                checkPointerLatch.startAndWaitForAllToStart();
                checkPointerLatch.waitForAllToFinish();
                return 42L;
            }

            public long tryCheckPoint(TriggerInfo triggerInfo) throws IOException {
                throw new RuntimeException("this should have not been called");
            }

            public long forceCheckPoint(TriggerInfo triggerInfo) throws IOException {
                throw new RuntimeException("this should have not been called");
            }

            public long lastCheckPointedTransactionId() {
                return 42L;
            }
        };
        final CheckPointScheduler scheduler = new CheckPointScheduler(checkPointer, this.ioLimiter, (JobScheduler)this.jobScheduler, 20L, this.health);
        scheduler.start();
        Thread runCheckPointer = new Thread(){

            @Override
            public void run() {
                CheckPointSchedulerTest.this.jobScheduler.runJob();
            }
        };
        runCheckPointer.start();
        checkPointerLatch.waitForAllToStart();
        Thread stopper = new Thread(){

            @Override
            public void run() {
                try {
                    scheduler.stop();
                    stoppedCompleted.set(true);
                }
                catch (Throwable throwable) {
                    ex.set(throwable);
                }
            }
        };
        stopper.start();
        Thread.sleep(10L);
        Assert.assertFalse((boolean)stoppedCompleted.get());
        checkPointerLatch.finish();
        runCheckPointer.join();
        Thread.sleep(150L);
        Assert.assertTrue((boolean)stoppedCompleted.get());
        stopper.join();
        Assert.assertNull(ex.get());
    }

    @Test
    public void shouldContinueThroughSporadicFailures() throws Throwable {
        ControlledCheckPointer checkPointer = new ControlledCheckPointer();
        CheckPointScheduler scheduler = new CheckPointScheduler((CheckPointer)checkPointer, this.ioLimiter, (JobScheduler)this.jobScheduler, 1L, this.health);
        scheduler.start();
        for (int i = 0; i < CheckPointScheduler.MAX_CONSECUTIVE_FAILURES_TOLERANCE * 2; ++i) {
            checkPointer.fail = true;
            this.jobScheduler.runJob();
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.health});
            checkPointer.fail = false;
            this.jobScheduler.runJob();
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.health});
        }
    }

    @Test(timeout=10000L)
    public void checkpointOnStopShouldFlushAsFastAsPossible() throws Throwable {
        CheckableIOLimiter ioLimiter = new CheckableIOLimiter();
        CountDownLatch checkPointerLatch = new CountDownLatch(1);
        WaitUnlimitedCheckPointer checkPointer = new WaitUnlimitedCheckPointer(ioLimiter, checkPointerLatch);
        CheckPointScheduler scheduler = new CheckPointScheduler((CheckPointer)checkPointer, (IOLimiter)ioLimiter, (JobScheduler)this.jobScheduler, 0L, this.health);
        scheduler.start();
        Thread checkpointerStarter = new Thread(this.jobScheduler::runJob);
        checkpointerStarter.start();
        checkPointerLatch.await();
        scheduler.stop();
        checkpointerStarter.join();
        Assert.assertTrue((String)"Checkpointer should be created.", (boolean)checkPointer.isCheckpointCreated());
        Assert.assertTrue((String)"Limiter should be enabled in the end.", (boolean)ioLimiter.isLimitEnabled());
    }

    @Test
    public void shouldCausePanicAfterSomeFailures() throws Throwable {
        Object[] failures = new RuntimeException[]{new RuntimeException("First"), new RuntimeException("Second"), new RuntimeException("Third")};
        Mockito.when((Object)this.checkPointer.checkPointIfNeeded((TriggerInfo)Matchers.any(TriggerInfo.class))).thenThrow((Throwable[])failures);
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, this.ioLimiter, (JobScheduler)this.jobScheduler, 1L, this.health);
        scheduler.start();
        for (int i = 0; i < CheckPointScheduler.MAX_CONSECUTIVE_FAILURES_TOLERANCE - 1; ++i) {
            this.jobScheduler.runJob();
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.health});
        }
        try {
            this.jobScheduler.runJob();
            Assert.fail((String)"Should have failed");
        }
        catch (UnderlyingStorageException e) {
            Assert.assertEquals((Object)Iterators.asSet((Object[])failures), (Object)Iterators.asSet((Object[])e.getSuppressed()));
            ((DatabaseHealth)Mockito.verify((Object)this.health)).panic((Throwable)e);
        }
    }

    private static class WaitUnlimitedCheckPointer
    implements CheckPointer {
        private final CheckableIOLimiter ioLimiter;
        private final CountDownLatch latch;
        private volatile boolean checkpointCreated;

        WaitUnlimitedCheckPointer(CheckableIOLimiter ioLimiter, CountDownLatch latch) {
            this.ioLimiter = ioLimiter;
            this.latch = latch;
            this.checkpointCreated = false;
        }

        public long checkPointIfNeeded(TriggerInfo triggerInfo) throws IOException {
            this.latch.countDown();
            while (this.ioLimiter.isLimitEnabled()) {
            }
            this.checkpointCreated = true;
            return 42L;
        }

        public long tryCheckPoint(TriggerInfo triggerInfo) throws IOException {
            throw new UnsupportedOperationException("This should have not been called");
        }

        public long forceCheckPoint(TriggerInfo triggerInfo) throws IOException {
            throw new UnsupportedOperationException("This should have not been called");
        }

        public long lastCheckPointedTransactionId() {
            return 0L;
        }

        boolean isCheckpointCreated() {
            return this.checkpointCreated;
        }
    }

    private static class CheckableIOLimiter
    implements IOLimiter {
        private volatile boolean limitEnabled = false;

        private CheckableIOLimiter() {
        }

        public long maybeLimitIO(long previousStamp, int recentlyCompletedIOs, Flushable flushable) throws IOException {
            return 0L;
        }

        public void disableLimit() {
            this.limitEnabled = false;
        }

        public void enableLimit() {
            this.limitEnabled = true;
        }

        boolean isLimitEnabled() {
            return this.limitEnabled;
        }
    }

    private static class ControlledCheckPointer
    implements CheckPointer {
        volatile boolean fail;

        private ControlledCheckPointer() {
        }

        public long checkPointIfNeeded(TriggerInfo triggerInfo) throws IOException {
            if (this.fail) {
                throw new IOException("Just failing");
            }
            return 1L;
        }

        public long tryCheckPoint(TriggerInfo triggerInfo) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long forceCheckPoint(TriggerInfo triggerInfo) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long lastCheckPointedTransactionId() {
            throw new UnsupportedOperationException();
        }
    }
}

