/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.test.Barrier;
import org.neo4j.test.Race;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class StoreCopyCheckPointMutexTest {
    private static final ThrowingAction<IOException> NO_OP = () -> {};
    private static final ThrowingAction<IOException> ASSERT_NOT_CALLED = () -> Assert.fail((String)"Should not be called");
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("T2");
    @Rule
    public final OtherThreadRule<Void> t3 = new OtherThreadRule("T3");
    private final StoreCopyCheckPointMutex mutex = new StoreCopyCheckPointMutex();

    @Test
    public void checkPointShouldBlockStoreCopy() throws Exception {
        try (Resource lock = this.mutex.checkPoint();){
            this.t2.execute(state -> this.mutex.storeCopy(NO_OP));
            this.t2.get().waitUntilWaiting(details -> details.isAt(StoreCopyCheckPointMutex.class, "storeCopy"));
        }
    }

    @Test
    public void checkPointShouldBlockAnotherCheckPoint() throws Exception {
        try (Resource lock = this.mutex.checkPoint();){
            this.t2.execute(state -> this.mutex.checkPoint());
            this.t2.get().waitUntilWaiting(details -> details.isAt(StoreCopyCheckPointMutex.class, "checkPoint"));
        }
    }

    @Test
    public void storeCopyShouldBlockCheckPoint() throws Exception {
        try (Resource lock = this.mutex.storeCopy(NO_OP);){
            this.t2.execute(state -> this.mutex.checkPoint());
            this.t2.get().waitUntilWaiting(details -> details.isAt(StoreCopyCheckPointMutex.class, "checkPoint"));
        }
    }

    @Test
    public void storeCopyShouldHaveTryCheckPointBackOff() throws Exception {
        try (Resource lock = this.mutex.storeCopy(NO_OP);){
            Assert.assertNull((Object)this.mutex.tryCheckPoint());
        }
    }

    @Test
    public void storeCopyShouldAllowAnotherStoreCopy() throws Exception {
        try (Resource lock = this.mutex.storeCopy(NO_OP);){
            Resource otherLock = this.mutex.storeCopy(NO_OP);
            Throwable throwable = null;
            if (otherLock != null) {
                if (throwable != null) {
                    try {
                        otherLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    otherLock.close();
                }
            }
        }
    }

    @Test
    public void storeCopyShouldAllowAnotherStoreCopyButOnlyFirstShouldPerformBeforeAction() throws Exception {
        ThrowingAction action = (ThrowingAction)Mockito.mock(ThrowingAction.class);
        try (Resource lock = this.mutex.storeCopy(action);){
            ((ThrowingAction)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).apply();
            try (Resource otherLock = this.mutex.storeCopy(action);){
                ((ThrowingAction)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).apply();
            }
        }
    }

    @Test
    public void shouldHandleMultipleConcurrentStoreCopyWhenBeforeActionPerformsCheckPoint() throws Throwable {
        CheckPointingAction checkPointingAction = new CheckPointingAction(this.mutex);
        for (int i = 0; i < 2; ++i) {
            Resource firstLock = this.mutex.storeCopy((ThrowingAction)checkPointingAction);
            Assert.assertNotNull((Object)checkPointingAction.lock);
            Resource secondLock = this.mutex.storeCopy((ThrowingAction)checkPointingAction);
            firstLock.close();
            Resource thirdLock = this.mutex.storeCopy((ThrowingAction)checkPointingAction);
            thirdLock.close();
            secondLock.close();
            checkPointingAction.unlock();
        }
    }

    @Test
    public void shouldHandleMultipleConcurrentStoreCopyRequests() throws Throwable {
        Race race = new Race();
        CountingAction action = new CountingAction();
        int threads = Runtime.getRuntime().availableProcessors() * 10;
        race.addContestants(threads, Race.throwing(() -> {
            StoreCopyCheckPointMutexTest.parkARandomWhile();
            try (Resource lock = this.mutex.storeCopy((ThrowingAction)action);){
                StoreCopyCheckPointMutexTest.parkARandomWhile();
            }
        }));
        race.go();
        Assert.assertThat((Object)action.count(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(threads)));
    }

    @Test
    public void shouldPropagateStoreCopyActionFailureToOtherStoreCopyRequests() throws Exception {
        final Barrier.Control barrier = new Barrier.Control();
        final IOException controlledFailure = new IOException("My own fault");
        final AtomicReference secondRequest = new AtomicReference();
        ThrowingAction<IOException> controllableAndFailingAction = new ThrowingAction<IOException>(){

            public void apply() throws IOException {
                secondRequest.set(StoreCopyCheckPointMutexTest.this.t3.execute(state -> StoreCopyCheckPointMutexTest.this.mutex.storeCopy(ASSERT_NOT_CALLED)));
                barrier.awaitUninterruptibly();
                try {
                    throw controlledFailure;
                }
                catch (Throwable throwable) {
                    barrier.release();
                    throw throwable;
                }
            }
        };
        Future<Object> firstRequest = this.t2.execute(arg_0 -> this.lambda$shouldPropagateStoreCopyActionFailureToOtherStoreCopyRequests$9((ThrowingAction)controllableAndFailingAction, arg_0));
        while (secondRequest.get() == null) {
            StoreCopyCheckPointMutexTest.parkARandomWhile();
        }
        this.t3.get().waitUntilWaiting(details -> details.isAt(StoreCopyCheckPointMutex.class, "waitForFirstStoreCopyActionToComplete"));
        barrier.reached();
        try {
            firstRequest.get();
        }
        catch (ExecutionException e) {
            Assert.assertSame((Object)controlledFailure, (Object)e.getCause());
        }
        try {
            ((Future)secondRequest.get()).get();
        }
        catch (ExecutionException e) {
            Throwable cooperativeActionFailure = e.getCause();
            Assert.assertThat((Object)cooperativeActionFailure.getMessage(), (Matcher)Matchers.containsString((String)"Co-operative"));
            Assert.assertSame((Object)controlledFailure, (Object)cooperativeActionFailure.getCause());
        }
        CountingAction action = new CountingAction();
        try (Resource lock = this.mutex.storeCopy((ThrowingAction)action);){
            Assert.assertEquals((long)1L, (long)action.count());
        }
    }

    private static void parkARandomWhile() {
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(ThreadLocalRandom.current().nextInt(10)));
    }

    private /* synthetic */ Object lambda$shouldPropagateStoreCopyActionFailureToOtherStoreCopyRequests$9(ThrowingAction controllableAndFailingAction, Void state) throws Exception {
        return this.mutex.storeCopy(controllableAndFailingAction);
    }

    private static class CountingAction
    implements ThrowingAction<IOException> {
        private final AtomicInteger count = new AtomicInteger();

        private CountingAction() {
        }

        public void apply() throws IOException {
            StoreCopyCheckPointMutexTest.parkARandomWhile();
            this.count.incrementAndGet();
        }

        int count() {
            return this.count.get();
        }
    }

    private static class CheckPointingAction
    implements ThrowingAction<IOException> {
        private final StoreCopyCheckPointMutex mutex;
        private Resource lock;

        CheckPointingAction(StoreCopyCheckPointMutex mutex) {
            this.mutex = mutex;
        }

        public void apply() throws IOException {
            Assert.assertNull((Object)this.lock);
            this.lock = this.mutex.checkPoint();
        }

        void unlock() {
            Assert.assertNotNull((Object)this.lock);
            this.lock.close();
            this.lock = null;
        }
    }
}

