/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.InvalidLogEntryHandler;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.WritableChannel;

public class VersionAwareLogEntryReaderTest {
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = new VersionAwareLogEntryReader();

    @Test
    public void shouldReadAStartLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        LogEntryStart start = new LogEntryStart(version, 1, 2, 3L, 4L, new byte[]{5}, new LogPosition(0L, 31L));
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)1);
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertEquals((Object)start, (Object)logEntry);
    }

    @Test
    public void shouldReadACommitLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        OnePhaseCommit commit = new OnePhaseCommit(version, 42L, 21L);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)5);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertEquals((Object)commit, (Object)logEntry);
    }

    @Test
    public void shouldReadACommandLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        Command.NodeCommand nodeCommand = new Command.NodeCommand(new NodeRecord(11L), new NodeRecord(11L));
        LogEntryCommand command = new LogEntryCommand(version, (StorageCommand)nodeCommand);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)3);
        nodeCommand.serialize((WritableChannel)channel);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertEquals((Object)command, (Object)logEntry);
    }

    @Test
    public void shouldReadACheckPointLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        LogPosition logPosition = new LogPosition(42L, 43L);
        CheckPoint checkPoint = new CheckPoint(version, logPosition);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)7);
        channel.putLong(logPosition.getLogVersion());
        channel.putLong(logPosition.getByteOffset());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertEquals((Object)checkPoint, (Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenThereIsNoCommand() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)3);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenLogEntryIsEmpty() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenNotEnoughDataInTheChannel() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldParseOldStartEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        LogEntryStart start = new LogEntryStart(1, 2, 3L, 4L, new byte[0], new LogPosition(0L, 37L));
        channel.put(version.byteCode());
        channel.put((byte)1);
        channel.put((byte)1);
        channel.put((byte)0);
        channel.put(new byte[]{7}, 1);
        channel.put(new byte[0], 0);
        channel.putInt(123);
        channel.putInt(456);
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)start, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldOnePhaseCommit() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put(version.byteCode());
        channel.put((byte)5);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldTwoPhaseCommit() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put(version.byteCode());
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldPrepareSkipItAndReadTheOneAfter() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put(version.byteCode());
        channel.put((byte)2);
        channel.putInt(123);
        channel.putLong(456L);
        channel.put(version.byteCode());
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldDoneSkipItAndReadTheOneAfter() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put(version.byteCode());
        channel.put((byte)4);
        channel.putInt(123);
        channel.put(version.byteCode());
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseAnOldCommandLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        Command.NodeCommand nodeCommand = new Command.NodeCommand(new NodeRecord(10L), new NodeRecord(10L));
        LogEntryCommand command = new LogEntryCommand(version, (StorageCommand)nodeCommand);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)3);
        channel.putInt(42);
        nodeCommand.serialize((WritableChannel)channel);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)command, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldReturnNullWhenThereIsNoCommandOldVersion() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)3);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldParseOldLogEntryEmptyANdReturnNull() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put(version.byteCode());
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldParseStreamOfZerosAsEmptyLogEntries() throws Exception {
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        int count = 100;
        channel.put(new byte[count], count);
        for (int i = 0; i < count; ++i) {
            LogEntry entry = reader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
            Assert.assertNull((Object)entry);
            Assert.assertEquals((long)(i + 1), (long)channel.readerPosition());
        }
    }

    @Test
    public void shouldBeAbleToSkipBadVersionAndTypeBytesInBetweenLogEntries() throws Exception {
        AcceptingInvalidLogEntryHandler invalidLogEntryHandler = new AcceptingInvalidLogEntryHandler();
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader((CommandReaderFactory)new RecordStorageCommandReaderFactory(), (InvalidLogEntryHandler)invalidLogEntryHandler);
        InMemoryClosableChannel channel = new InMemoryClosableChannel(1000);
        LogEntryWriter writer = new LogEntryWriter((FlushableChannel)channel.writer());
        long startTime = System.currentTimeMillis();
        long commitTime = startTime + 10L;
        writer.writeStartEntry(1, 2, startTime, 3L, new byte[0]);
        writer.writeCommitEntry(4L, commitTime);
        channel.put((byte)127);
        channel.put((byte)126);
        channel.put((byte)125);
        long secondStartTime = startTime + 100L;
        writer.writeStartEntry(1, 2, secondStartTime, 4L, new byte[0]);
        LogEntryStart readStartEntry = (LogEntryStart)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel.reader()).as();
        LogEntryCommit readCommitEntry = (LogEntryCommit)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel.reader()).as();
        LogEntryStart readSecondStartEntry = (LogEntryStart)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel.reader()).as();
        Assert.assertEquals((long)1L, (long)readStartEntry.getMasterId());
        Assert.assertEquals((long)2L, (long)readStartEntry.getLocalId());
        Assert.assertEquals((long)startTime, (long)readStartEntry.getTimeWritten());
        Assert.assertEquals((long)4L, (long)readCommitEntry.getTxId());
        Assert.assertEquals((long)commitTime, (long)readCommitEntry.getTimeWritten());
        Assert.assertEquals((long)3L, (long)invalidLogEntryHandler.bytesSkipped);
        Assert.assertEquals((long)3L, (long)invalidLogEntryHandler.invalidEntryCalls);
        Assert.assertEquals((long)1L, (long)readSecondStartEntry.getMasterId());
        Assert.assertEquals((long)2L, (long)readSecondStartEntry.getLocalId());
        Assert.assertEquals((long)secondStartTime, (long)readSecondStartEntry.getTimeWritten());
    }

    @Test
    public void shouldBeAbleToSkipBadLogEntries() throws Exception {
        AcceptingInvalidLogEntryHandler invalidLogEntryHandler = new AcceptingInvalidLogEntryHandler();
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader((CommandReaderFactory)new RecordStorageCommandReaderFactory(), (InvalidLogEntryHandler)invalidLogEntryHandler);
        InMemoryClosableChannel channel = new InMemoryClosableChannel(1000);
        LogEntryWriter writer = new LogEntryWriter((FlushableChannel)channel.writer());
        long startTime = System.currentTimeMillis();
        long commitTime = startTime + 10L;
        writer.writeStartEntry(1, 2, startTime, 3L, new byte[0]);
        int posBefore = channel.writerPosition();
        writer.serialize(Arrays.asList(new Command.NodeCommand(new NodeRecord(1L), new NodeRecord(1L).initialize(true, 1L, false, 2L, 0L))));
        int posAfter = channel.writerPosition();
        channel.positionWriter(posBefore);
        while (channel.writerPosition() < posAfter) {
            channel.put((byte)-1);
        }
        writer.writeCommitEntry(4L, commitTime);
        long secondStartTime = startTime + 100L;
        writer.writeStartEntry(1, 2, secondStartTime, 4L, new byte[0]);
        LogEntryStart readStartEntry = (LogEntryStart)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel.reader()).as();
        LogEntryCommit readCommitEntry = (LogEntryCommit)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel.reader()).as();
        LogEntryStart readSecondStartEntry = (LogEntryStart)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel.reader()).as();
        Assert.assertEquals((long)1L, (long)readStartEntry.getMasterId());
        Assert.assertEquals((long)2L, (long)readStartEntry.getLocalId());
        Assert.assertEquals((long)startTime, (long)readStartEntry.getTimeWritten());
        Assert.assertEquals((long)4L, (long)readCommitEntry.getTxId());
        Assert.assertEquals((long)commitTime, (long)readCommitEntry.getTimeWritten());
        Assert.assertEquals((long)(posAfter - posBefore), (long)invalidLogEntryHandler.bytesSkipped);
        Assert.assertEquals((long)(posAfter - posBefore), (long)invalidLogEntryHandler.invalidEntryCalls);
        Assert.assertEquals((long)1L, (long)readSecondStartEntry.getMasterId());
        Assert.assertEquals((long)2L, (long)readSecondStartEntry.getLocalId());
        Assert.assertEquals((long)secondStartTime, (long)readSecondStartEntry.getTimeWritten());
    }

    static class AcceptingInvalidLogEntryHandler
    extends InvalidLogEntryHandler {
        long bytesSkipped;
        Exception e;
        LogPosition position;
        int invalidEntryCalls;

        AcceptingInvalidLogEntryHandler() {
        }

        public boolean handleInvalidEntry(Exception e, LogPosition position) {
            this.e = e;
            this.position = position;
            ++this.invalidEntryCalls;
            return true;
        }

        public void bytesSkipped(long bytesSkipped) {
            this.bytesSkipped += bytesSkipped;
        }
    }
}

