/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest.workload;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.TransactionRepresentationFactory;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.Worker;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class Runner
implements Callable<Long> {
    private final File workingDirectory;
    private final BooleanSupplier condition;
    private final int threads;
    private static final LogRotation.Monitor NOOP_LOGROTATION_MONITOR = new LogRotation.Monitor(){

        public void startedRotating(long currentVersion) {
        }

        public void finishedRotating(long currentVersion) {
        }
    };

    public Runner(File workingDirectory, BooleanSupplier condition, int threads) {
        this.workingDirectory = workingDirectory;
        this.condition = condition;
        this.threads = threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws Exception {
        long lastCommittedTransactionId;
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             Lifespan life = new Lifespan(new Lifecycle[0]);){
            DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore();
            TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(100000);
            LogHeaderCache logHeaderCache = new LogHeaderCache(1000);
            LogFile logFile = (LogFile)life.add((Lifecycle)this.createPhysicalLogFile(transactionIdStore, logHeaderCache, (FileSystemAbstraction)fileSystem));
            TransactionAppender transactionAppender = (TransactionAppender)life.add((Lifecycle)this.createBatchingTransactionAppender(transactionIdStore, transactionMetadataCache, logFile));
            ExecutorService executorService = Executors.newFixedThreadPool(this.threads);
            try {
                Future[] handlers = new Future[this.threads];
                for (int i = 0; i < this.threads; ++i) {
                    TransactionRepresentationFactory factory = new TransactionRepresentationFactory();
                    Worker task = new Worker(transactionAppender, factory, this.condition);
                    handlers[i] = executorService.submit(task);
                }
                for (Future handle : handlers) {
                    handle.get();
                }
            }
            finally {
                executorService.shutdown();
            }
            lastCommittedTransactionId = transactionIdStore.getLastCommittedTransactionId();
        }
        return lastCommittedTransactionId;
    }

    private BatchingTransactionAppender createBatchingTransactionAppender(TransactionIdStore transactionIdStore, TransactionMetadataCache transactionMetadataCache, LogFile logFile) {
        NullLog log = NullLog.getInstance();
        KernelEventHandlers kernelEventHandlers = new KernelEventHandlers((Log)log);
        DatabasePanicEventGenerator panicEventGenerator = new DatabasePanicEventGenerator(kernelEventHandlers);
        DatabaseHealth databaseHealth = new DatabaseHealth(panicEventGenerator, (Log)log);
        LogRotationImpl logRotation = new LogRotationImpl(NOOP_LOGROTATION_MONITOR, logFile, databaseHealth);
        return new BatchingTransactionAppender(logFile, (LogRotation)logRotation, transactionMetadataCache, transactionIdStore, IdOrderingQueue.BYPASS, databaseHealth);
    }

    private PhysicalLogFile createPhysicalLogFile(TransactionIdStore transactionIdStore, LogHeaderCache logHeaderCache, FileSystemAbstraction fileSystemAbstraction) {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.workingDirectory, fileSystemAbstraction);
        long rotateAtSize = (Long)Settings.BYTES.apply(GraphDatabaseSettings.logical_log_rotation_threshold.getDefaultValue());
        DeadSimpleLogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(0L);
        return new PhysicalLogFile(fileSystemAbstraction, logFiles, rotateAtSize, () -> ((TransactionIdStore)transactionIdStore).getLastCommittedTransactionId(), (LogVersionRepository)logVersionRepository, PhysicalLogFile.NO_MONITOR, logHeaderCache);
    }
}

