/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV3_0;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class NodeCommandTest {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    private NodeStore nodeStore;
    InMemoryClosableChannel channel = new InMemoryClosableChannel();
    private final CommandReader commandReader = new PhysicalLogCommandReaderV3_0();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private NeoStores neoStores;

    @Test
    public void shouldSerializeAndDeserializeUnusedRecords() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        this.assertSerializationWorksFor(new Command.NodeCommand(before, after));
    }

    @Test
    public void shouldSerializeCreatedRecord() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setCreated();
        after.setInUse(true);
        this.assertSerializationWorksFor(new Command.NodeCommand(before, after));
    }

    @Test
    public void shouldSerializeDenseRecord() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, true, 2L, 1L);
        after.setInUse(true);
        this.assertSerializationWorksFor(new Command.NodeCommand(before, after));
    }

    @Test
    public void shouldSerializeUpdatedRecord() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        this.assertSerializationWorksFor(new Command.NodeCommand(before, after));
    }

    @Test
    public void shouldSerializeInlineLabels() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)after);
        nodeLabels.add(1337L, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
        this.assertSerializationWorksFor(new Command.NodeCommand(before, after));
    }

    @Test
    public void shouldSerializeSecondaryUnitUsage() throws Exception {
        NodeRecord before = new NodeRecord(13L, false, 1L, 2L);
        before.setInUse(true);
        before.setRequiresSecondaryUnit(false);
        before.setSecondaryUnitId(-1L);
        NodeRecord after = new NodeRecord(13L, false, 1L, 2L);
        after.setInUse(true);
        after.setRequiresSecondaryUnit(true);
        after.setSecondaryUnitId(14L);
        Command.NodeCommand command = new Command.NodeCommand(before, after);
        this.assertSerializationWorksFor(command);
    }

    @Test
    public void shouldSerializeDynamicRecordLabels() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)after);
        for (int i = 10; i < 100; ++i) {
            nodeLabels.add((long)i, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
        }
        this.assertSerializationWorksFor(new Command.NodeCommand(before, after));
    }

    @Test
    public void shouldSerializeDynamicRecordsRemoved() throws Exception {
        this.channel.reset();
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        List<DynamicRecord> beforeDyn = Collections.singletonList(DynamicRecord.dynamicRecord((long)0L, (boolean)true, (boolean)true, (long)-1L, (int)ShortArray.LONG.intValue(), (byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}));
        before.setLabelField(DynamicNodeLabels.dynamicPointer(beforeDyn), beforeDyn);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        List<DynamicRecord> dynamicRecords = Collections.singletonList(DynamicRecord.dynamicRecord((long)0L, (boolean)false, (boolean)true, (long)-1L, (int)ShortArray.LONG.intValue(), (byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}));
        after.setLabelField(DynamicNodeLabels.dynamicPointer(dynamicRecords), dynamicRecords);
        Command.NodeCommand cmd = new Command.NodeCommand(before, after);
        cmd.serialize((WritableChannel)this.channel);
        Command.NodeCommand result = (Command.NodeCommand)this.commandReader.read((ReadableChannel)this.channel);
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)cmd));
        MatcherAssert.assertThat((Object)result.getMode(), (Matcher)IsEqual.equalTo((Object)cmd.getMode()));
        MatcherAssert.assertThat((Object)result.getBefore(), (Matcher)IsEqual.equalTo((Object)cmd.getBefore()));
        MatcherAssert.assertThat((Object)result.getAfter(), (Matcher)IsEqual.equalTo((Object)cmd.getAfter()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getBefore()).getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getBefore()).getDynamicLabelRecords()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getAfter()).getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getAfter()).getDynamicLabelRecords()));
    }

    private void assertSerializationWorksFor(Command.NodeCommand cmd) throws IOException {
        this.channel.reset();
        cmd.serialize((WritableChannel)this.channel);
        Command.NodeCommand result = (Command.NodeCommand)this.commandReader.read((ReadableChannel)this.channel);
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)cmd));
        MatcherAssert.assertThat((Object)result.getMode(), (Matcher)IsEqual.equalTo((Object)cmd.getMode()));
        MatcherAssert.assertThat((Object)result.getBefore(), (Matcher)IsEqual.equalTo((Object)cmd.getBefore()));
        MatcherAssert.assertThat((Object)result.getAfter(), (Matcher)IsEqual.equalTo((Object)cmd.getAfter()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getBefore()).isCreated(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getBefore()).isCreated()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getAfter()).isCreated(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getAfter()).isCreated()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getBefore()).isDense(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getBefore()).isDense()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getAfter()).isDense(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getAfter()).isDense()));
        MatcherAssert.assertThat(this.labels((NodeRecord)result.getBefore()), (Matcher)IsEqual.equalTo(this.labels((NodeRecord)cmd.getBefore())));
        MatcherAssert.assertThat(this.labels((NodeRecord)result.getAfter()), (Matcher)IsEqual.equalTo(this.labels((NodeRecord)cmd.getAfter())));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getBefore()).getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getBefore()).getDynamicLabelRecords()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getAfter()).getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getAfter()).getDynamicLabelRecords()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getBefore()).requiresSecondaryUnit(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getBefore()).requiresSecondaryUnit()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getBefore()).hasSecondaryUnitId(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getBefore()).hasSecondaryUnitId()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getBefore()).getSecondaryUnitId(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getBefore()).getSecondaryUnitId()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getAfter()).requiresSecondaryUnit(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getAfter()).requiresSecondaryUnit()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getAfter()).hasSecondaryUnitId(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getAfter()).hasSecondaryUnitId()));
        MatcherAssert.assertThat((Object)((NodeRecord)result.getAfter()).getSecondaryUnitId(), (Matcher)IsEqual.equalTo((Object)((NodeRecord)cmd.getAfter()).getSecondaryUnitId()));
    }

    private Set<Integer> labels(NodeRecord record) {
        long[] rawLabels = NodeLabelsField.parseLabelsField((NodeRecord)record).get(this.nodeStore);
        HashSet<Integer> labels = new HashSet<Integer>(rawLabels.length);
        for (long label : rawLabels) {
            labels.add(IoPrimitiveUtils.safeCastLongToInt((long)label));
        }
        return labels;
    }

    @Before
    public void before() throws Exception {
        File dir = new File("dir");
        ((EphemeralFileSystemAbstraction)this.fs.get()).mkdirs(dir);
        StoreFactory storeFactory = new StoreFactory(dir, Config.empty(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        this.neoStores = storeFactory.openAllNeoStores(true);
        this.nodeStore = this.neoStores.getNodeStore();
    }

    @After
    public void after() throws Exception {
        this.neoStores.close();
    }
}

