/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Arrays;
import java.util.List;
import java.util.function.IntPredicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class LabelScanViewNodeStoreScanTest {
    private NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
    private LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private LabelScanReader labelScanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
    private IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private Visitor<NodeLabelUpdate, Exception> labelUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private Visitor<NodeUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private IndexDescriptor index = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{3});

    @Before
    public void setUp() {
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)this.labelScanReader);
    }

    @Test
    public void iterateOverLabeledNodeIds() throws Exception {
        PrimitiveLongIterator labeledNodes = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 4L, 8L});
        Mockito.when((Object)this.nodeStore.getHighId()).thenReturn((Object)15L);
        Mockito.when((Object)this.labelScanReader.nodesWithAnyOfLabels(new int[]{1, 2})).thenReturn((Object)labeledNodes);
        int[] labelIds = new int[]{1, 2};
        LabelScanViewNodeStoreScan<Exception> storeScan = this.getLabelScanViewStoreScan(labelIds);
        PrimitiveLongResourceIterator idIterator = storeScan.getNodeIdIterator();
        List visitedNodeIds = PrimitiveLongCollections.asList((PrimitiveLongIterator)idIterator);
        Assert.assertThat((Object)visitedNodeIds, (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)visitedNodeIds, (Matcher)Matchers.hasItems((Object[])new Long[]{1L, 2L, 4L, 8L}));
    }

    @Test
    public void configureSamplersToNotUseOnlineSampling() throws Exception {
        LabelScanViewNodeStoreScan<Exception> scanViewStoreScan = this.getLabelScanViewStoreScan(new int[]{1, 2});
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        LabelScanTestMultipleIndexPopulator indexPopulator = new LabelScanTestMultipleIndexPopulator(storeView, (LogProvider)NullLogProvider.getInstance());
        List<MultipleIndexPopulator.IndexPopulation> populations = Arrays.asList(this.getPopulation(indexPopulator), this.getPopulation(indexPopulator));
        scanViewStoreScan.configure(populations);
        for (MultipleIndexPopulator.IndexPopulation population : populations) {
            ((IndexPopulator)Mockito.verify((Object)population.populator)).configureSampling(false);
        }
    }

    @Test
    public void resetNodeIdIteratorDuringConcurrentUpdates() {
        Mockito.when((Object)this.labelScanReader.nodesWithAnyOfLabels(new int[]{1, 2})).thenReturn((Object)PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L, 4L}));
        LabelScanViewNodeStoreScan<Exception> scanViewStoreScan = this.getLabelScanViewStoreScan(new int[]{1, 2});
        PrimitiveLongResourceIterator nodeIdIterator = scanViewStoreScan.getNodeIdIterator();
        ((LabelScanStore)Mockito.verify((Object)this.labelScanStore)).newReader();
        ((LabelScanReader)Mockito.verify((Object)this.labelScanReader)).nodesWithAnyOfLabels(new int[]{1, 2});
        Assert.assertTrue((String)"Contain 4 nodes id.", (boolean)nodeIdIterator.hasNext());
        Assert.assertEquals((String)"First expected node id is 1.", (long)1L, (long)nodeIdIterator.next());
        Assert.assertTrue((String)"Contain 4 nodes id.", (boolean)nodeIdIterator.hasNext());
        Assert.assertEquals((String)"Second expected node id is 2.", (long)2L, (long)nodeIdIterator.next());
        this.populateWithConcurrentUpdates(scanViewStoreScan);
        Assert.assertTrue((String)"Contain 4 nodes id.", (boolean)nodeIdIterator.hasNext());
        Assert.assertEquals((String)"Third expected node id is 3.", (long)3L, (long)nodeIdIterator.next());
        ((LabelScanReader)Mockito.verify((Object)this.labelScanReader)).close();
        ((LabelScanStore)Mockito.verify((Object)this.labelScanStore, (VerificationMode)Mockito.times((int)2))).newReader();
        ((LabelScanReader)Mockito.verify((Object)this.labelScanReader, (VerificationMode)Mockito.times((int)2))).nodesWithAnyOfLabels(new int[]{1, 2});
        Assert.assertTrue((String)"Contain 4 nodes id.", (boolean)nodeIdIterator.hasNext());
        Assert.assertEquals((String)"Fourth expected node id is 4.", (long)4L, (long)nodeIdIterator.next());
        Assert.assertFalse((boolean)nodeIdIterator.hasNext());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.labelScanReader, this.labelScanStore});
    }

    private void populateWithConcurrentUpdates(LabelScanViewNodeStoreScan<Exception> scanViewStoreScan) {
        MultipleIndexPopulator.MultipleIndexUpdater indexUpdater = (MultipleIndexPopulator.MultipleIndexUpdater)Mockito.mock(MultipleIndexPopulator.MultipleIndexUpdater.class);
        scanViewStoreScan.acceptUpdate(indexUpdater, IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.index.schema(), (Object[])new Object[]{"add"}), 0L);
        scanViewStoreScan.acceptUpdate(indexUpdater, IndexEntryUpdate.change((long)2L, (LabelSchemaSupplier)this.index.schema(), (Object)"changeBefore", (Object)"changeAfter"), 0L);
        scanViewStoreScan.acceptUpdate(indexUpdater, IndexEntryUpdate.change((long)2L, (LabelSchemaSupplier)this.index.schema(), (Object)"changeBefore2", (Object)"changeAfter2"), 0L);
        scanViewStoreScan.acceptUpdate(indexUpdater, IndexEntryUpdate.remove((long)3L, (LabelSchemaSupplier)this.index.schema(), (Object[])new Object[]{"remove"}), 0L);
    }

    private MultipleIndexPopulator.IndexPopulation getPopulation(LabelScanTestMultipleIndexPopulator indexPopulator) {
        return indexPopulator.createPopulation((IndexPopulator)Mockito.mock(IndexPopulator.class), 1L, null, null, null, null, null);
    }

    private LabelScanViewNodeStoreScan<Exception> getLabelScanViewStoreScan(int[] labelIds) {
        return new LabelScanViewNodeStoreScan(this.nodeStore, LockService.NO_LOCK_SERVICE, this.propertyStore, this.labelScanStore, this.labelUpdateVisitor, this.propertyUpdateVisitor, labelIds, this.propertyKeyIdFilter);
    }

    private class LabelScanTestMultipleIndexPopulator
    extends MultipleIndexPopulator {
        LabelScanTestMultipleIndexPopulator(IndexStoreView storeView, LogProvider logProvider) {
            super(storeView, logProvider);
        }

        public MultipleIndexPopulator.IndexPopulation createPopulation(IndexPopulator populator, long indexId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
            return super.createPopulation(populator, indexId, descriptor, providerDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
        }
    }
}

