/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Collections;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.kernel.impl.traversal.TraversalBranchImpl;

public class TraversalBranchImplTest {
    @Test
    public void shouldExpandOnFirstAccess() throws Exception {
        TraversalBranch parent = (TraversalBranch)Mockito.mock(TraversalBranch.class);
        Node source = (Node)Mockito.mock(Node.class);
        TraversalBranchImpl branch = new TraversalBranchImpl(parent, source);
        PathExpander expander = (PathExpander)Mockito.mock(PathExpander.class);
        Mockito.when((Object)expander.expand((Path)Matchers.eq((Object)branch), (BranchState)Matchers.any(BranchState.class))).thenReturn(Collections.emptySet());
        TraversalContext context = (TraversalContext)Mockito.mock(TraversalContext.class);
        Mockito.when((Object)context.evaluate((TraversalBranch)Matchers.eq((Object)branch), (BranchState)Matchers.any(BranchState.class))).thenReturn((Object)Evaluation.INCLUDE_AND_CONTINUE);
        branch.initialize(expander, context);
        Mockito.verifyZeroInteractions((Object[])new Object[]{source});
        branch.next(expander, context);
        ((PathExpander)Mockito.verify((Object)expander)).expand((Path)Matchers.any(Path.class), (BranchState)Matchers.any(BranchState.class));
    }
}

