/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.SilentFileWatcher;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.watcher.FileWatcherLifecycleAdapter;

public class FileWatcherLifecycleAdapterTest {
    private static Neo4jJobScheduler jobScheduler;
    private FileWatcher fileWatcher = (FileWatcher)Mockito.mock(FileWatcher.class);

    @BeforeClass
    public static void setUp() {
        jobScheduler = new Neo4jJobScheduler();
    }

    @AfterClass
    public static void tearDown() {
        jobScheduler.shutdown();
    }

    @Test
    public void startMonitoringWhenLifecycleStarting() throws Throwable {
        CountDownLatch latch = new CountDownLatch(1);
        TestFileWatcher watcher = new TestFileWatcher(latch);
        FileWatcherLifecycleAdapter watcherAdapter = new FileWatcherLifecycleAdapter((JobScheduler)jobScheduler, (FileWatcher)watcher);
        watcherAdapter.init();
        watcherAdapter.start();
        latch.await();
    }

    @Test
    public void stopMonitoringWhenLifecycleStops() throws Throwable {
        FileWatcherLifecycleAdapter watcherAdapter = new FileWatcherLifecycleAdapter((JobScheduler)jobScheduler, this.fileWatcher);
        watcherAdapter.init();
        watcherAdapter.start();
        watcherAdapter.stop();
        ((FileWatcher)Mockito.verify((Object)this.fileWatcher)).stopWatching();
    }

    @Test
    public void closeFileWatcherOnShutdown() throws Throwable {
        FileWatcherLifecycleAdapter watcherAdapter = new FileWatcherLifecycleAdapter((JobScheduler)jobScheduler, this.fileWatcher);
        watcherAdapter.init();
        watcherAdapter.start();
        watcherAdapter.stop();
        watcherAdapter.shutdown();
        ((FileWatcher)Mockito.verify((Object)this.fileWatcher)).close();
    }

    private static class TestFileWatcher
    extends SilentFileWatcher {
        private CountDownLatch latch;

        TestFileWatcher(CountDownLatch latch) {
            this.latch = latch;
        }

        public void startWatching() throws InterruptedException {
            this.latch.countDown();
        }
    }
}

