/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.HexPrinter;

public class HexPrinterTest {
    @Test
    public void shouldPrintACoupleOfLines() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        HexPrinter printer = new HexPrinter(out);
        for (byte value = 0; value < 40; value = (byte)(value + 1)) {
            printer.append(value);
        }
        out.flush();
        Assert.assertEquals((Object)String.format("00 01 02 03 04 05 06 07    08 09 0A 0B 0C 0D 0E 0F    10 11 12 13 14 15 16 17    18 19 1A 1B 1C 1D 1E 1F%n20 21 22 23 24 25 26 27", new Object[0]), (Object)outStream.toString());
    }

    @Test
    public void shouldPrintUserSpecifiedBytesGroupingFormat() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        HexPrinter printer = new HexPrinter(out).withBytesGroupingFormat(12, 4, ", ");
        for (byte value = 0; value < 30; value = (byte)(value + 1)) {
            printer.append(value);
        }
        out.flush();
        Assert.assertEquals((Object)String.format("00 01 02 03, 04 05 06 07, 08 09 0A 0B%n0C 0D 0E 0F, 10 11 12 13, 14 15 16 17%n18 19 1A 1B, 1C 1D", new Object[0]), (Object)outStream.toString());
    }

    @Test
    public void shouldNotGroupingWhenBytesPerGroupIsGreaterThanBytesPerLine() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        HexPrinter printer = new HexPrinter(out).withBytesPerLine(12).withBytesPerGroup(100);
        for (byte value = 0; value < 30; value = (byte)(value + 1)) {
            printer.append(value);
        }
        out.flush();
        Assert.assertEquals((Object)String.format("00 01 02 03 04 05 06 07 08 09 0A 0B%n0C 0D 0E 0F 10 11 12 13 14 15 16 17%n18 19 1A 1B 1C 1D", new Object[0]), (Object)outStream.toString());
    }

    @Test
    public void shouldPrintUserSpecifiedLineNumberFormat() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        HexPrinter printer = new HexPrinter(out).withLineNumberFormat(5, "[", "]");
        for (byte value = 0; value < 40; value = (byte)(value + 1)) {
            printer.append(value);
        }
        out.flush();
        Assert.assertEquals((Object)String.format("[0x00000]00 01 02 03 04 05 06 07    08 09 0A 0B 0C 0D 0E 0F    10 11 12 13 14 15 16 17    18 19 1A 1B 1C 1D 1E 1F%n[0x00001]20 21 22 23 24 25 26 27", new Object[0]), (Object)outStream.toString());
    }

    @Test
    public void shouldStartFromUserSpecifiedLineNumber() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        HexPrinter printer = new HexPrinter(out).withLineNumberDigits(2).withLineNumberOffset(168L);
        for (byte value = 0; value < 40; value = (byte)(value + 1)) {
            printer.append(value);
        }
        out.flush();
        Assert.assertEquals((Object)String.format("@ 0xA8: 00 01 02 03 04 05 06 07    08 09 0A 0B 0C 0D 0E 0F    10 11 12 13 14 15 16 17    18 19 1A 1B 1C 1D 1E 1F%n@ 0xA9: 20 21 22 23 24 25 26 27", new Object[0]), (Object)outStream.toString());
    }

    @Test
    public void shouldPrintPartOfByteBuffer() throws Exception {
        ByteBuffer bytes = ByteBuffer.allocate(1024);
        for (byte value = 0; value < 33; value = (byte)(value + 1)) {
            bytes.put(value);
        }
        String hexString = HexPrinter.hex((ByteBuffer)bytes, (int)3, (int)8);
        Assert.assertEquals((Object)String.format("03 04 05 06 07 08 09 0A", new Object[0]), (Object)hexString);
    }

    @Test
    public void shouldOnlyPrintBytesWrittenToBuffer() throws Exception {
        ByteBuffer bytes = ByteBuffer.allocate(1024);
        for (byte value = 0; value < 10; value = (byte)(value + 1)) {
            bytes.put(value);
        }
        bytes.flip();
        String hexString = HexPrinter.hex((ByteBuffer)bytes);
        Assert.assertEquals((Object)String.format("00 01 02 03 04 05 06 07    08 09", new Object[0]), (Object)hexString);
    }
}

