/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongLongMap;
import org.neo4j.resources.HeapAllocation;

public class FakeHeapAllocation
extends HeapAllocation
implements TestRule {
    private final PrimitiveLongLongMap allocation = Primitive.offHeapLongLongMap();

    public long allocatedBytes(long threadId) {
        return Math.max(0L, this.allocation.get(threadId));
    }

    public FakeHeapAllocation add(long bytes) {
        return this.add(Thread.currentThread().getId(), bytes);
    }

    public FakeHeapAllocation add(long threadId, long bytes) {
        this.allocation.put(threadId, this.allocatedBytes(threadId) + bytes);
        return this;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    FakeHeapAllocation.this.allocation.close();
                }
            }
        };
    }
}

