/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.test.Race;
import org.neo4j.test.rule.NeoStoresRule;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.BatchCollector;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdGeneratorFactory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class PropertyEncoderStepTest {
    private static final String LONG_STRING = StringUtils.repeat((String)"12%$heya", (int)40);
    @Rule
    public final NeoStoresRule neoStoresRule = new NeoStoresRule(this.getClass(), StoreType.PROPERTY, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.PROPERTY_STRING, StoreType.PROPERTY_ARRAY);

    @Test
    public void shouldAssignCorrectIdsOnParallelExecution() throws Throwable {
        StageControl control = (StageControl)Mockito.mock(StageControl.class);
        final int batchSize = 100;
        Configuration config = new Configuration(){

            public int batchSize() {
                return batchSize;
            }
        };
        NeoStores stores = this.neoStoresRule.builder().with(fs -> new BatchingIdGeneratorFactory(fs)).build();
        BatchingTokenRepository.BatchingPropertyKeyTokenRepository keyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository((TokenStore)stores.getPropertyKeyTokenStore());
        PropertyStore propertyStore = stores.getPropertyStore();
        PropertyEncoderStep encoder = new PropertyEncoderStep(control, config, keyRepository, propertyStore);
        BatchCollector sender = new BatchCollector();
        Race race = new Race();
        int i = 0;
        while (i < Runtime.getRuntime().availableProcessors()) {
            int id = i++;
            race.addContestant(() -> encoder.process(this.batch(id, batchSize), (BatchSender)sender));
        }
        race.go();
        this.assertUniqueIds(sender.getBatches());
    }

    private void assertUniqueIds(List<Batch<InputNode, NodeRecord>> batches) {
        PrimitiveLongSet ids = Primitive.longSet((int)1000);
        PrimitiveLongSet stringIds = Primitive.longSet((int)100);
        PrimitiveLongSet arrayIds = Primitive.longSet((int)100);
        for (Batch<InputNode, NodeRecord> batch : batches) {
            PropertyRecord[][] propertyRecordArray = batch.propertyRecords;
            int n = propertyRecordArray.length;
            for (int i = 0; i < n; ++i) {
                PropertyRecord[] records;
                for (PropertyRecord record : records = propertyRecordArray[i]) {
                    Assert.assertTrue((boolean)ids.add(record.getId()));
                    for (PropertyBlock block : record) {
                        block8: for (DynamicRecord dynamicRecord : block.getValueRecords()) {
                            switch (dynamicRecord.getType()) {
                                case STRING: {
                                    Assert.assertTrue((boolean)stringIds.add(dynamicRecord.getId()));
                                    continue block8;
                                }
                                case ARRAY: {
                                    Assert.assertTrue((boolean)arrayIds.add(dynamicRecord.getId()));
                                    continue block8;
                                }
                            }
                            Assert.fail((String)("Unexpected property type " + dynamicRecord.getType()));
                        }
                    }
                }
            }
        }
    }

    protected Batch<InputNode, NodeRecord> batch(int id, int batchSize) {
        Object[] input = new InputNode[batchSize];
        NodeRecord[] records = new NodeRecord[batchSize];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < batchSize; ++i) {
            String value = id + "_" + i;
            if ((double)random.nextFloat() < 0.01) {
                value = value + LONG_STRING;
            }
            input[i] = new InputNode("source", 0L, 0L, null, new Object[]{"key", value}, null, InputNode.NO_LABELS, null);
            records[i] = new NodeRecord(-1L);
        }
        Batch batch = new Batch(input);
        batch.records = records;
        return batch;
    }
}

