/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public final class StoreWithReservedId {
    private StoreWithReservedId() {
    }

    public static NodeStore newNodeStoreMock(long highId) {
        return StoreWithReservedId.newStoreMock(NodeStore.class, new NodeRecord(-1L), highId);
    }

    public static RelationshipStore newRelationshipStoreMock(long highId) {
        return StoreWithReservedId.newStoreMock(RelationshipStore.class, new RelationshipRecord(-1L), highId);
    }

    private static <R extends AbstractBaseRecord, S extends RecordStore<R>> S newStoreMock(Class<S> storeClass, R record, long highId) {
        RecordStore store = (RecordStore)Mockito.mock(storeClass);
        Mockito.when((Object)store.getHighId()).thenReturn((Object)highId);
        Mockito.when((Object)store.newRecord()).thenReturn(record);
        RecordCursor<R> cursor = StoreWithReservedId.newReservedIdReturningRecordCursor(highId, record);
        Mockito.when((Object)store.newRecordCursor((AbstractBaseRecord)Matchers.any())).thenReturn(cursor);
        return (S)store;
    }

    private static <R extends AbstractBaseRecord> RecordCursor<R> newReservedIdReturningRecordCursor(long highId, R record) {
        RecordCursor cursor = (RecordCursor)Mockito.mock(RecordCursor.class);
        Mockito.when((Object)cursor.next((long)Matchers.anyInt())).thenAnswer(invocation -> {
            long id = (Long)invocation.getArguments()[0];
            long realId = id == highId - 1L ? 0xFFFFFFFFL : id;
            record.setId(realId);
            return true;
        });
        Mockito.when((Object)cursor.acquire((long)Matchers.anyInt(), (RecordLoad)Matchers.any())).thenReturn((Object)cursor);
        return cursor;
    }
}

