/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

@RunWith(value=Parameterized.class)
public class NodeRelationshipCacheTest {
    @Rule
    public final RandomRule random = new RandomRule();
    @Parameterized.Parameter(value=0)
    public long base;
    private NodeRelationshipCache cache;

    @After
    public void after() {
        this.cache.close();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{0L});
        data.add(new Object[]{0xFFFFFFFEL});
        return data;
    }

    @Test
    public void shouldReportCorrectNumberOfDenseNodes() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.AUTO, 5, 100, this.base);
        this.cache.setHighNodeId(26L);
        this.increment(this.cache, 2L, 10);
        this.increment(this.cache, 5L, 2);
        this.increment(this.cache, 7L, 12);
        this.increment(this.cache, 23L, 4);
        this.increment(this.cache, 24L, 5);
        this.increment(this.cache, 25L, 6);
        Assert.assertFalse((boolean)this.cache.isDense(0L));
        Assert.assertTrue((boolean)this.cache.isDense(2L));
        Assert.assertFalse((boolean)this.cache.isDense(5L));
        Assert.assertTrue((boolean)this.cache.isDense(7L));
        Assert.assertFalse((boolean)this.cache.isDense(23L));
        Assert.assertTrue((boolean)this.cache.isDense(24L));
        Assert.assertTrue((boolean)this.cache.isDense(25L));
    }

    @Test
    public void shouldGoThroughThePhases() throws Exception {
        int nodeCount = 10;
        this.cache = new NodeRelationshipCache(NumberArrayFactory.OFF_HEAP, 20, 100, this.base);
        this.cache.setHighNodeId((long)nodeCount);
        this.incrementRandomCounts(this.cache, nodeCount, nodeCount * 20);
        long node = this.findNode(this.cache, nodeCount, false);
        this.testNode(this.cache, node, null);
        node = this.findNode(this.cache, nodeCount, true);
        this.testNode(this.cache, node, Direction.OUTGOING);
        this.testNode(this.cache, node, Direction.INCOMING);
    }

    @Test
    public void shouldObserveFirstRelationshipAsEmptyInEachDirection() throws Exception {
        long previous;
        int i;
        this.cache = new NodeRelationshipCache(NumberArrayFactory.AUTO, 1, 100, this.base);
        int nodes = 100;
        int typeId = 5;
        Direction[] directions = Direction.values();
        NodeRelationshipCache.GroupVisitor groupVisitor = (NodeRelationshipCache.GroupVisitor)Mockito.mock(NodeRelationshipCache.GroupVisitor.class);
        this.cache.setForwardScan(true, true);
        this.cache.setHighNodeId((long)(nodes + 1));
        for (i = 0; i < nodes; ++i) {
            Assert.assertEquals((long)-1L, (long)this.cache.getFirstRel((long)nodes, groupVisitor));
            this.cache.incrementCount((long)i);
            previous = this.cache.getAndPutRelationship((long)i, typeId, directions[i % directions.length], (long)this.random.nextInt(1000000), true);
            Assert.assertEquals((long)-1L, (long)previous);
        }
        this.cache.setForwardScan(false, true);
        for (i = 0; i < nodes; ++i) {
            previous = this.cache.getAndPutRelationship((long)i, typeId, directions[i % directions.length], (long)this.random.nextInt(1000000), false);
            Assert.assertEquals((long)-1L, (long)previous);
        }
        this.cache.setForwardScan(true, true);
        for (i = 0; i < nodes; ++i) {
            Assert.assertEquals((long)-1L, (long)this.cache.getFirstRel((long)nodes, groupVisitor));
        }
    }

    @Test
    public void shouldResetCountAfterGetOnDenseNodes() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.AUTO, 1, 100, this.base);
        long nodeId = 0L;
        int typeId = 3;
        this.cache.setHighNodeId(1L);
        this.cache.incrementCount(nodeId);
        this.cache.incrementCount(nodeId);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, 10L, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, 12L, true);
        Assert.assertTrue((boolean)this.cache.isDense(nodeId));
        long count = this.cache.getCount(nodeId, typeId, Direction.OUTGOING);
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertEquals((long)0L, (long)this.cache.getCount(nodeId, typeId, Direction.OUTGOING));
    }

    @Test
    public void shouldGetAndPutRelationshipAroundChunkEdge() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 10);
        long nodeId = 999999L;
        int typeId = 10;
        this.cache.setHighNodeId(nodeId + 1L);
        Direction direction = Direction.OUTGOING;
        long relId = 10L;
        this.cache.getAndPutRelationship(nodeId, typeId, direction, relId, false);
        Assert.assertEquals((long)relId, (long)this.cache.getFirstRel(nodeId, (NodeRelationshipCache.GroupVisitor)Mockito.mock(NodeRelationshipCache.GroupVisitor.class)));
    }

    @Test
    public void shouldPutRandomStuff() throws Exception {
        int typeId = 10;
        int nodes = 10000;
        PrimitiveLongObjectMap key = Primitive.longObjectMap((int)nodes);
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 1, 1000, this.base);
        this.cache.setHighNodeId((long)nodes);
        for (long nodeId = 0L; nodeId < (long)nodes; ++nodeId) {
            if (!this.random.nextBoolean()) continue;
            this.cache.incrementCount(nodeId);
        }
        for (int i = 0; i < 100000; ++i) {
            int keyIndex;
            long nodeId = this.random.nextLong((long)nodes);
            boolean dense = this.cache.isDense(nodeId);
            Direction direction = (Direction)this.random.among((Object[])Direction.values());
            long relationshipId = this.random.nextLong(1000000L);
            long previousHead = this.cache.getAndPutRelationship(nodeId, typeId, direction, relationshipId, false);
            long[] keyIds = (long[])key.get(nodeId);
            int n = keyIndex = dense ? direction.ordinal() : 0;
            if (keyIds == null) {
                keyIds = this.minusOneLongs(Direction.values().length);
                key.put(nodeId, (Object)keyIds);
            }
            Assert.assertEquals((long)keyIds[keyIndex], (long)previousHead);
            keyIds[keyIndex] = relationshipId;
        }
    }

    @Test
    public void shouldPut6ByteRelationshipIds() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 1, 100, this.base);
        long sparseNode = 0L;
        long denseNode = 1L;
        long relationshipId = 0xFFFFFFFFFFFEL;
        int typeId = 10;
        this.cache.setHighNodeId(2L);
        this.cache.incrementCount(denseNode);
        Assert.assertEquals((long)-1L, (long)this.cache.getAndPutRelationship(sparseNode, typeId, Direction.OUTGOING, relationshipId, false));
        Assert.assertEquals((long)-1L, (long)this.cache.getAndPutRelationship(denseNode, typeId, Direction.OUTGOING, relationshipId, false));
        Assert.assertEquals((long)relationshipId, (long)this.cache.getAndPutRelationship(sparseNode, typeId, Direction.OUTGOING, 1L, false));
        Assert.assertEquals((long)relationshipId, (long)this.cache.getAndPutRelationship(denseNode, typeId, Direction.OUTGOING, 1L, false));
    }

    @Test
    public void shouldFailFastIfTooBigRelationshipId() throws Exception {
        int typeId = 10;
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 1, 100, this.base);
        this.cache.setHighNodeId(1L);
        this.cache.getAndPutRelationship(0L, typeId, Direction.OUTGOING, 0xFFFFFFFFFFFEL, false);
        try {
            this.cache.getAndPutRelationship(0L, typeId, Direction.OUTGOING, 0xFFFFFFFFFFFFL, false);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("max"));
        }
    }

    @Test
    public void shouldVisitChangedNodes() throws Exception {
        int nodes = 10;
        int typeId = 10;
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 2, 100, this.base);
        this.cache.setHighNodeId((long)nodes);
        for (long nodeId2 = 0L; nodeId2 < (long)nodes; ++nodeId2) {
            this.cache.incrementCount(nodeId2);
            if (!this.random.nextBoolean()) continue;
            this.cache.incrementCount(nodeId2);
        }
        PrimitiveLongSet keySparseChanged = Primitive.longSet((int)nodes);
        PrimitiveLongSet keyDenseChanged = Primitive.longSet((int)nodes);
        for (int i = 0; i < nodes / 2; ++i) {
            long nodeId3 = this.random.nextLong((long)nodes);
            this.cache.getAndPutRelationship(nodeId3, typeId, Direction.OUTGOING, this.random.nextLong(1000000L), false);
            boolean dense = this.cache.isDense(nodeId3);
            (dense ? keyDenseChanged : keySparseChanged).add(nodeId3);
        }
        NodeRelationshipCache.NodeChangeVisitor visitor = (nodeId, array) -> Assert.assertTrue((String)("Unexpected sparse change reported for " + nodeId), (boolean)keySparseChanged.remove(nodeId));
        this.cache.visitChangedNodes(visitor, 2);
        Assert.assertTrue((String)("There was " + keySparseChanged.size() + " expected sparse changes that weren't reported"), (boolean)keySparseChanged.isEmpty());
        visitor = (nodeId, array) -> Assert.assertTrue((String)("Unexpected dense change reported for " + nodeId), (boolean)keyDenseChanged.remove(nodeId));
        this.cache.visitChangedNodes(visitor, 1);
        Assert.assertTrue((String)("There was " + keyDenseChanged.size() + " expected dense changes that weren reported"), (boolean)keyDenseChanged.isEmpty());
    }

    @Test
    public void shouldFailFastOnTooHighCountOnNode() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 10, 100, this.base);
        long nodeId = 5L;
        long count = 0x7FFFFFFFEL;
        int typeId = 10;
        this.cache.setHighNodeId(10L);
        this.cache.setCount(nodeId, count, typeId, Direction.OUTGOING);
        this.cache.incrementCount(nodeId);
        try {
            this.cache.incrementCount(nodeId);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldKeepNextGroupIdForNextRound() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 1, 100, this.base);
        long nodeId = 0L;
        int typeId = 10;
        this.cache.setHighNodeId(nodeId + 1L);
        this.cache.incrementCount(nodeId);
        NodeRelationshipCache.GroupVisitor groupVisitor = (NodeRelationshipCache.GroupVisitor)Mockito.mock(NodeRelationshipCache.GroupVisitor.class);
        Mockito.when((Object)groupVisitor.visit(Matchers.anyLong(), Matchers.anyInt(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L});
        long relationshipId = 10L;
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, relationshipId, true);
        long firstRelationshipGroupId = this.cache.getFirstRel(nodeId, groupVisitor);
        Assert.assertEquals((long)1L, (long)firstRelationshipGroupId);
        ((NodeRelationshipCache.GroupVisitor)Mockito.verify((Object)groupVisitor)).visit(nodeId, typeId, relationshipId, -1L, -1L);
        this.cache.setForwardScan(false, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, relationshipId, false);
        this.cache.setForwardScan(true, true);
        long relationshipId2 = 11L;
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.INCOMING, relationshipId2, true);
        long secondRelationshipGroupId = this.cache.getFirstRel(nodeId, groupVisitor);
        Assert.assertEquals((long)2L, (long)secondRelationshipGroupId);
        ((NodeRelationshipCache.GroupVisitor)Mockito.verify((Object)groupVisitor)).visit(nodeId, typeId, -1L, relationshipId2, -1L);
        this.cache.setForwardScan(false, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, relationshipId2, false);
        this.cache.setForwardScan(true, true);
        relationshipId2 = 10L;
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.BOTH, relationshipId2, true);
        long thirdRelationshipGroupId = this.cache.getFirstRel(nodeId, groupVisitor);
        Assert.assertEquals((long)3L, (long)thirdRelationshipGroupId);
        ((NodeRelationshipCache.GroupVisitor)Mockito.verify((Object)groupVisitor)).visit(nodeId, typeId, -1L, -1L, relationshipId2);
    }

    @Test
    public void shouldHaveDenseNodesWithBigCounts() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 1, 100, this.base);
        long nodeId = 1L;
        int typeId = 10;
        this.cache.setHighNodeId(nodeId + 1L);
        this.cache.setCount(nodeId, 2L, typeId, Direction.OUTGOING);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, 1L, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.INCOMING, 2L, true);
        long highCountOut = 34359738267L;
        long highCountIn = 34359738317L;
        this.cache.setCount(nodeId, highCountOut, typeId, Direction.OUTGOING);
        this.cache.setCount(nodeId, highCountIn, typeId, Direction.INCOMING);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, 1L, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.INCOMING, 2L, true);
        Assert.assertEquals((long)(highCountOut + 1L), (long)this.cache.getCount(nodeId, typeId, Direction.OUTGOING));
        Assert.assertEquals((long)(highCountIn + 1L), (long)this.cache.getCount(nodeId, typeId, Direction.INCOMING));
    }

    @Test
    public void shouldCacheMultipleDenseNodeRelationshipHeads() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 1);
        this.cache.setHighNodeId(10L);
        long nodeId = 3L;
        this.cache.setCount(nodeId, 10L, 0, Direction.OUTGOING);
        final HashMap<Pair, Long> firstRelationshipIds = new HashMap<Pair, Long>();
        int typeCount = 3;
        int relationshipId = 0;
        for (int typeId = 0; typeId < typeCount; ++typeId) {
            for (Direction direction : Direction.values()) {
                long firstRelationshipId = relationshipId++;
                this.cache.getAndPutRelationship(nodeId, typeId, direction, firstRelationshipId, true);
                firstRelationshipIds.put(Pair.of((Object)typeId, (Object)direction), firstRelationshipId);
            }
        }
        final AtomicInteger visitCount = new AtomicInteger();
        NodeRelationshipCache.GroupVisitor visitor = new NodeRelationshipCache.GroupVisitor(){

            public long visit(long nodeId, int typeId, long out, long in, long loop) {
                visitCount.incrementAndGet();
                Assert.assertEquals((long)((Long)firstRelationshipIds.get(Pair.of((Object)typeId, (Object)Direction.OUTGOING))), (long)out);
                Assert.assertEquals((long)((Long)firstRelationshipIds.get(Pair.of((Object)typeId, (Object)Direction.INCOMING))), (long)in);
                Assert.assertEquals((long)((Long)firstRelationshipIds.get(Pair.of((Object)typeId, (Object)Direction.BOTH))), (long)loop);
                return 0L;
            }
        };
        this.cache.getFirstRel(nodeId, visitor);
        Assert.assertEquals((long)typeCount, (long)visitCount.get());
    }

    @Test
    public void shouldSplitUpRelationshipTypesInBatches() throws Exception {
        int denseNodeThreshold = 5;
        int numberOfNodes = 100;
        int numberOfTypes = 10;
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, denseNodeThreshold);
        this.cache.setHighNodeId((long)(numberOfNodes + 1));
        Object[] directions = Direction.values();
        for (int i = 0; i < numberOfNodes; ++i) {
            int count = this.random.nextInt(1, denseNodeThreshold * 2);
            this.cache.setCount((long)i, (long)count, this.random.nextInt(numberOfTypes), (Direction)this.random.among(directions));
        }
        int numberOfDenseNodes = Math.toIntExact(this.cache.calculateNumberOfDenseNodes());
        HashMap<String, MutableLong> types = new HashMap<String, MutableLong>();
        for (int i = 0; i < numberOfTypes; ++i) {
            types.put("TYPE" + i, new MutableLong((long)this.random.nextInt(1, 1000)));
        }
        long memory = numberOfDenseNodes * numberOfTypes * NodeRelationshipCache.GROUP_ENTRY_SIZE;
        Collection fits = (Collection)Iterators.single((Iterator)this.cache.splitRelationshipTypesIntoRounds(types.entrySet().iterator(), memory));
        Assert.assertEquals((long)types.size(), (long)fits.size());
        int memory2 = numberOfDenseNodes * numberOfTypes / 5 * NodeRelationshipCache.GROUP_ENTRY_SIZE;
        int total = 0;
        Iterator rounds = this.cache.splitRelationshipTypesIntoRounds(types.entrySet().iterator(), (long)memory2);
        while (rounds.hasNext()) {
            Collection round = (Collection)rounds.next();
            total += round.size();
        }
        Assert.assertEquals((long)types.size(), (long)total);
    }

    @Test
    public void shouldHaveSparseNodesWithBigCounts() throws Exception {
        this.cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, 1, 100, this.base);
        long nodeId = 1L;
        int typeId = 10;
        this.cache.setHighNodeId(nodeId + 1L);
        long highCount = 34359738267L;
        this.cache.setCount(nodeId, highCount, typeId, Direction.OUTGOING);
        long nextHighCount = this.cache.incrementCount(nodeId);
        Assert.assertEquals((long)(highCount + 1L), (long)nextHighCount);
    }

    private void testNode(NodeRelationshipCache link, long node, Direction direction) {
        int typeId = 0;
        long count = link.getCount(node, typeId, direction);
        Assert.assertEquals((long)-1L, (long)link.getAndPutRelationship(node, typeId, direction, 5L, false));
        Assert.assertEquals((long)5L, (long)link.getAndPutRelationship(node, typeId, direction, 10L, false));
        Assert.assertEquals((long)count, (long)link.getCount(node, typeId, direction));
    }

    private long findNode(NodeRelationshipCache link, long nodeCount, boolean isDense) {
        for (long i = 0L; i < nodeCount; ++i) {
            if (link.isDense(i) != isDense) continue;
            return i;
        }
        throw new IllegalArgumentException("No dense node found");
    }

    private long incrementRandomCounts(NodeRelationshipCache link, int nodeCount, int i) {
        long highestSeenCount = 0L;
        while (i-- > 0) {
            long node = this.random.nextInt(nodeCount);
            highestSeenCount = Math.max(highestSeenCount, link.incrementCount(node));
        }
        return highestSeenCount;
    }

    private void increment(NodeRelationshipCache cache, long node, int count) {
        for (int i = 0; i < count; ++i) {
            cache.incrementCount(node);
        }
    }

    private long[] minusOneLongs(int length) {
        long[] array = new long[length];
        Arrays.fill(array, -1L);
        return array;
    }
}

