/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.io.NullOutputStream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.input.BadCollector;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class BadCollectorTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldCollectBadRelationshipsEvenIfThresholdNeverReached() throws IOException {
        int tolerance = 5;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 7);
        badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        Assert.assertEquals((long)1L, (long)badCollector.badEntries());
    }

    @Test
    public void shouldThrowExceptionIfNoToleranceThresholdIsExceeded() throws IOException {
        int tolerance = 0;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 7);
        try {
            badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
            Assert.fail((String)"Should have thrown an InputException");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowExceptionIfDuplicateNodeTipsUsOverTheToleranceEdge() throws IOException {
        int tolerance = 1;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 7);
        badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        try {
            badCollector.collectDuplicateNode((Object)1, 1L, "group", "source", "otherSource");
            Assert.fail((String)"Should have thrown an InputException");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowExceptionIfBadRelationshipsTipsUsOverTheToleranceEdge() throws IOException {
        int tolerance = 1;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 7);
        badCollector.collectDuplicateNode((Object)1, 1L, "group", "source", "otherSource");
        try {
            badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
            Assert.fail((String)"Should have thrown an InputException");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotCollectBadRelationshipsIfWeShouldOnlyBeCollectingNodes() throws IOException {
        int tolerance = 1;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 2);
        badCollector.collectDuplicateNode((Object)1, 1L, "group", "source", "otherSource");
        try {
            badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        }
        catch (InputException ignored) {
            Assert.assertEquals((long)1L, (long)badCollector.badEntries());
        }
    }

    @Test
    public void shouldNotCollectBadNodesIfWeShouldOnlyBeCollectingRelationships() throws IOException {
        int tolerance = 1;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 1);
        badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        try {
            badCollector.collectDuplicateNode((Object)1, 1L, "group", "source", "otherSource");
        }
        catch (InputException ignored) {
            Assert.assertEquals((long)1L, (long)badCollector.badEntries());
        }
    }

    @Test
    public void shouldBeAbleToRetrieveDuplicateNodeIds() throws IOException {
        int tolerance = 15;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 7);
        for (int i = 0; i < 15; ++i) {
            badCollector.collectDuplicateNode((Object)i, (long)i, "group", "source" + i, "otherSource" + i);
        }
        Assert.assertEquals((long)15L, (long)PrimitiveLongCollections.count((PrimitiveLongIterator)badCollector.leftOverDuplicateNodesIds()));
        PrimitiveLongSet longs = PrimitiveLongCollections.asSet((PrimitiveLongIterator)badCollector.leftOverDuplicateNodesIds());
        for (int i = 0; i < 15; ++i) {
            Assert.assertTrue((boolean)longs.contains((long)i));
        }
    }

    @Test
    public void shouldProvideNodeIdsSorted() throws Exception {
        BadCollector badCollector = new BadCollector(this.badOutputFile(), 10, 2);
        badCollector.collectDuplicateNode((Object)"a", 10L, "group", "source1", "source2");
        badCollector.collectDuplicateNode((Object)"b", 8L, "group", "source1", "source2");
        badCollector.collectDuplicateNode((Object)"c", 12L, "group", "source1", "source2");
        long[] nodeIds = PrimitiveLongCollections.asArray((PrimitiveLongIterator)badCollector.leftOverDuplicateNodesIds());
        Assert.assertArrayEquals((long[])new long[]{8L, 10L, 12L}, (long[])nodeIds);
    }

    @Test
    public void shouldCollectUnlimitedNumberOfBadEntriesIfToldTo() throws Exception {
        BadCollector collector = new BadCollector(NullOutputStream.NULL_OUTPUT_STREAM, -1, 7);
        int count = 10000;
        for (int i = 0; i < count; ++i) {
            collector.collectDuplicateNode((Object)i, (long)i, "group", "first", "other");
        }
        Assert.assertEquals((long)count, (long)collector.badEntries());
    }

    @Test
    public void skipBadEntriesLogging() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BadCollector badCollector = new BadCollector((OutputStream)outputStream, 100, 7, true);
        for (int i = 0; i < 2; ++i) {
            badCollector.collectDuplicateNode((Object)i, (long)i, "group", "source" + i, "otherSource" + i);
        }
        badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        badCollector.collectExtraColumns("a,b,c", 1L, "a");
        Assert.assertEquals((String)"Output stream should not have any reported entries", (long)0L, (long)outputStream.size());
    }

    private OutputStream badOutputFile() throws IOException {
        File badDataPath = new File("/tmp/foo2").getAbsoluteFile();
        FileSystemAbstraction fileSystem = this.fs.get();
        File badDataFile = this.badDataFile(fileSystem, badDataPath);
        return fileSystem.openAsOutputStream(badDataFile, true);
    }

    private File badDataFile(FileSystemAbstraction fileSystem, File badDataPath) throws IOException {
        fileSystem.mkdir(badDataPath.getParentFile());
        fileSystem.create(badDataPath);
        return badDataPath;
    }

    static class InputRelationshipBuilder {
        private final String sourceDescription = "foo";
        private final int lineNumber = 1;
        private final int position = 1;
        private final Object[] properties = new Object[0];
        private final long firstPropertyId = -1L;
        private final Object startNode = null;
        private final Object endNode = null;
        private final String friend = "FRIEND";
        private final int typeId = 1;

        InputRelationshipBuilder() {
        }

        public static InputRelationshipBuilder inputRelationship() {
            return new InputRelationshipBuilder();
        }

        InputRelationship build() {
            return new InputRelationship("foo", 1L, 1L, this.properties, Long.valueOf(-1L), this.startNode, this.endNode, "FRIEND", Integer.valueOf(1));
        }
    }
}

