/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class BatchingNeoStoresTest {
    private final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsr).around((TestRule)this.pageCacheRule);
    private final File storeDir = new File("dir").getAbsoluteFile();

    @Test
    public void shouldNotOpenStoreWithNodesOrRelationshipsInIt() throws Exception {
        this.someDataInTheDatabase();
        try {
            RecordFormats recordFormats = RecordFormatSelector.selectForConfig((Config)Config.empty(), (LogProvider)NullLogProvider.getInstance());
            BatchingNeoStores.batchingNeoStores((FileSystemAbstraction)this.fsr.get(), (File)this.storeDir, (RecordFormats)recordFormats, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.empty());
            Assert.fail((String)"Should fail on existing data");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"already contains"));
        }
    }

    @Test
    public void shouldRespectDbConfig() throws Exception {
        int size = 10;
        Config config = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.array_block_size.name(), String.valueOf(size), GraphDatabaseSettings.string_block_size.name(), String.valueOf(size)}));
        RecordFormats recordFormats = Standard.LATEST_RECORD_FORMATS;
        int headerSize = recordFormats.dynamic().getRecordHeaderSize();
        try (BatchingNeoStores store = BatchingNeoStores.batchingNeoStores((FileSystemAbstraction)this.fsr.get(), (File)this.storeDir, (RecordFormats)recordFormats, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)config);){
            Assert.assertEquals((long)(size + headerSize), (long)store.getPropertyStore().getArrayStore().getRecordSize());
            Assert.assertEquals((long)(size + headerSize), (long)store.getPropertyStore().getStringStore().getRecordSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void someDataInTheDatabase() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fsr.get())).newImpermanentDatabase(this.storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }
}

