/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class CoarseUnboundedProgressExecutionMonitor
extends ExecutionMonitor.Adapter {
    private int prevN = 0;
    private final int dotEveryN;
    private final PrintStream out;

    public CoarseUnboundedProgressExecutionMonitor(int dotEveryN, PrintStream out) {
        super(100L, TimeUnit.MILLISECONDS);
        this.dotEveryN = dotEveryN;
        this.out = out;
    }

    @Override
    public void start(StageExecution execution) {
        this.prevN = 0;
    }

    @Override
    public void check(StageExecution execution) {
        int n = Math.max(this.prevN, this.n(execution));
        while (this.prevN < n) {
            this.progress();
            ++this.prevN;
        }
    }

    private int n(StageExecution execution) {
        long doneBatches = ((Step)Iterables.last(execution.steps())).stats().stat(Keys.done_batches).asLong();
        int batchSize = execution.getConfig().batchSize();
        long amount = doneBatches * (long)batchSize;
        int n = (int)(amount / (long)this.dotEveryN);
        return n;
    }

    protected void progress() {
        this.out.print(".");
    }

    @Override
    public void done(long totalTimeMillis, String additionalInformation) {
        this.out.println();
    }
}

