/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.LegacyIndexMigrator;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;
import org.neo4j.logging.LogProvider;

public class DatabaseMigrator {
    private final MigrationProgressMonitor progressMonitor;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogService logService;
    private final SchemaIndexProvider schemaIndexProvider;
    private final LabelScanStoreProvider labelScanStoreProvider;
    private final Map<String, IndexImplementation> indexProviders;
    private final PageCache pageCache;
    private final RecordFormats format;

    public DatabaseMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fs, Config config, LogService logService, SchemaIndexProvider schemaIndexProvider, LabelScanStoreProvider labelScanStoreProvider, Map<String, IndexImplementation> indexProviders, PageCache pageCache, RecordFormats format) {
        this.progressMonitor = progressMonitor;
        this.fs = fs;
        this.config = config;
        this.logService = logService;
        this.schemaIndexProvider = schemaIndexProvider;
        this.labelScanStoreProvider = labelScanStoreProvider;
        this.indexProviders = indexProviders;
        this.pageCache = pageCache;
        this.format = format;
    }

    public void migrate(File storeDir) {
        LogProvider logProvider = this.logService.getInternalLogProvider();
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(this.fs, new StoreVersionCheck(this.pageCache), new LegacyStoreVersionCheck(this.fs), this.format);
        StoreUpgrader storeUpgrader = new StoreUpgrader(upgradableDatabase, this.progressMonitor, this.config, this.fs, this.pageCache, logProvider);
        StoreMigrationParticipant schemaMigrator = this.schemaIndexProvider.storeMigrationParticipant(this.fs, this.pageCache, this.labelScanStoreProvider);
        LegacyIndexMigrator legacyIndexMigrator = new LegacyIndexMigrator(this.fs, this.indexProviders, logProvider);
        StoreMigrator storeMigrator = new StoreMigrator(this.fs, this.pageCache, this.config, this.logService, this.schemaIndexProvider);
        storeUpgrader.addParticipant(schemaMigrator);
        storeUpgrader.addParticipant(legacyIndexMigrator);
        storeUpgrader.addParticipant(storeMigrator);
        storeUpgrader.migrateIfNeeded(storeDir);
    }
}

