/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;

public interface TransactionHeaderInformationFactory {
    public static final TransactionHeaderInformationFactory DEFAULT = new WithRandomBytes(){
        private static final int NO_ID = -1;

        @Override
        protected TransactionHeaderInformation createUsing(byte[] additionalHeader) {
            return new TransactionHeaderInformation(-1, -1, additionalHeader);
        }
    };

    public TransactionHeaderInformation create();

    public static abstract class WithRandomBytes
    implements TransactionHeaderInformationFactory {
        private static final int ADDITIONAL_HEADER_SIZE = 8;

        @Override
        public TransactionHeaderInformation create() {
            byte[] additionalHeader = this.generateAdditionalHeader();
            return this.createUsing(additionalHeader);
        }

        protected abstract TransactionHeaderInformation createUsing(byte[] var1);

        private byte[] generateAdditionalHeader() {
            byte[] header = new byte[8];
            ThreadLocalRandom.current().nextBytes(header);
            return header;
        }
    }
}

