/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

abstract class DynamicNumberArray<N extends NumberArray<N>>
implements NumberArray<N> {
    protected final NumberArrayFactory factory;
    protected final long chunkSize;
    protected N[] chunks;

    DynamicNumberArray(NumberArrayFactory factory, long chunkSize, N[] initialChunks) {
        this.factory = factory;
        this.chunkSize = chunkSize;
        this.chunks = initialChunks;
    }

    @Override
    public long length() {
        return (long)this.chunks.length * this.chunkSize;
    }

    @Override
    public void clear() {
        for (N chunk : this.chunks) {
            chunk.clear();
        }
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        for (N chunk : this.chunks) {
            chunk.acceptMemoryStatsVisitor(visitor);
        }
    }

    protected N chunkOrNullAt(long index) {
        int chunkIndex = this.chunkIndex(index);
        return chunkIndex < this.chunks.length ? (N)this.chunks[chunkIndex] : null;
    }

    protected int chunkIndex(long index) {
        return (int)(index / this.chunkSize);
    }

    @Override
    public N at(long index) {
        if (index >= this.length()) {
            this.synchronizedAddChunk(index);
        }
        int chunkIndex = this.chunkIndex(index);
        return this.chunks[chunkIndex];
    }

    private synchronized void synchronizedAddChunk(long index) {
        if (index >= this.length()) {
            NumberArray[] newChunks = (NumberArray[])Arrays.copyOf(this.chunks, this.chunkIndex(index) + 1);
            for (int i = this.chunks.length; i < newChunks.length; ++i) {
                newChunks[i] = this.addChunk(this.chunkSize, this.chunkSize * (long)i);
            }
            this.chunks = newChunks;
        }
    }

    protected abstract N addChunk(long var1, long var3);

    @Override
    public void close() {
        for (N chunk : this.chunks) {
            chunk.close();
        }
    }
}

