/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.labelscan.LabelScanStoreTest;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public abstract class LabelScanStoreChaosIT {
    private final DatabaseRule dbRule = new EmbeddedDatabaseRule(this.getClass()){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            LabelScanStoreChaosIT.this.addSpecificConfig(builder);
        }
    };
    protected final RandomRule randomRule = new RandomRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.randomRule).around((TestRule)this.dbRule);

    protected abstract void addSpecificConfig(GraphDatabaseBuilder var1);

    @Test
    public void shouldRebuildDeletedLabelScanStoreOnStartup() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First);
        Node node2 = this.createLabeledNode(Labels.First);
        Node node3 = this.createLabeledNode(Labels.First);
        this.deleteNode(node2);
        this.dbRule.restartDatabase(this.deleteTheLabelScanStoreIndex(), new String[0]);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node3}), this.getAllNodesWithLabel(Labels.First));
    }

    @Test
    public void rebuildCorruptedLabelScanStoreToStartup() throws Exception {
        Node node = this.createLabeledNode(Labels.First);
        this.dbRule.restartDatabase(this.corruptTheLabelScanStoreIndex(), new String[0]);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node}), this.getAllNodesWithLabel(Labels.First));
    }

    protected abstract DatabaseRule.RestartAction corruptTheLabelScanStoreIndex();

    protected abstract DatabaseRule.RestartAction deleteTheLabelScanStoreIndex();

    private Node createLabeledNode(Label ... labels) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            Node node = this.dbRule.getGraphDatabaseAPI().createNode(labels);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private Set<Node> getAllNodesWithLabel(Label label) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            Set set = Iterators.asSet((Iterator)this.dbRule.getGraphDatabaseAPI().findNodes(label));
            return set;
        }
    }

    protected void scrambleFile(File file) throws IOException {
        LabelScanStoreTest.scrambleFile(this.randomRule.random(), file);
    }

    private void deleteNode(Node node) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            node.delete();
            tx.success();
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second,
        Third;

    }
}

