/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfiguration;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.test.impl.EphemeralIdGenerator;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class LabelsAcceptanceTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void shouldInsertLabelsWithoutDuplicatingThem() throws Exception {
        Node node = this.dbRule.executeAndCommit(GraphDatabaseService::createNode);
        this.dbRule.executeAndCommit(db -> node.addLabel(Label.label((String)"FOOBAR")));
        this.dbRule.executeAndCommit(db -> node.addLabel(Label.label((String)"BAZQUX")));
        this.dbRule.executeAndCommit(db -> {
            for (Label label : node.getLabels()) {
                node.removeLabel(label);
            }
            node.addLabel(Label.label((String)"BAZQUX"));
        });
        List labels = this.dbRule.executeAndCommit(db -> {
            ArrayList<Label> labels1 = new ArrayList<Label>();
            for (Label label : node.getLabels()) {
                labels1.add(label);
            }
            return labels1;
        });
        Assert.assertEquals((String)labels.toString(), (long)1L, (long)labels.size());
        Assert.assertEquals((Object)"BAZQUX", (Object)((Label)labels.get(0)).name());
    }

    @Test
    public void addingALabelUsingAValidIdentifierShouldSucceed() throws Exception {
        GraphDatabaseAPI graphDatabase = this.dbRule.getGraphDatabaseAPI();
        Node myNode = null;
        try (Transaction tx = graphDatabase.beginTx();){
            myNode = graphDatabase.createNode();
            myNode.addLabel((Label)Labels.MY_LABEL);
            tx.success();
        }
        Assert.assertThat((String)"Label should have been added to node", (Object)myNode, Neo4jMatchers.inTx((GraphDatabaseService)graphDatabase, Neo4jMatchers.hasLabel(Labels.MY_LABEL)));
    }

    @Test
    public void addingALabelUsingAnInvalidIdentifierShouldFail() throws Exception {
        Throwable throwable;
        GraphDatabaseAPI graphDatabase = this.dbRule.getGraphDatabaseAPI();
        try {
            throwable = null;
            try (Transaction tx = graphDatabase.beginTx();){
                graphDatabase.createNode().addLabel(Label.label((String)""));
                Assert.fail((String)"Should have thrown exception");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (ConstraintViolationException tx) {
            // empty catch block
        }
        try {
            throwable = null;
            try (Transaction tx2 = graphDatabase.beginTx();){
                graphDatabase.createNode().addLabel(() -> null);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void addingALabelThatAlreadyExistsBehavesAsNoOp() throws Exception {
        GraphDatabaseAPI graphDatabase = this.dbRule.getGraphDatabaseAPI();
        Node myNode = null;
        try (Transaction tx = graphDatabase.beginTx();){
            myNode = graphDatabase.createNode();
            myNode.addLabel((Label)Labels.MY_LABEL);
            myNode.addLabel((Label)Labels.MY_LABEL);
            tx.success();
        }
        Assert.assertThat((String)"Label should have been added to node", (Object)myNode, Neo4jMatchers.inTx((GraphDatabaseService)graphDatabase, Neo4jMatchers.hasLabel(Labels.MY_LABEL)));
    }

    @Test
    public void oversteppingMaxNumberOfLabelsShouldFailGracefully() throws Exception {
        GraphDatabaseService graphDatabase = this.beansAPIWithNoMoreLabelIds();
        try (Transaction tx = graphDatabase.beginTx();){
            graphDatabase.createNode().addLabel((Label)Labels.MY_LABEL);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        graphDatabase.shutdown();
    }

    @Test
    public void removingCommittedLabel() throws Exception {
        GraphDatabaseAPI graphDatabase = this.dbRule.getGraphDatabaseAPI();
        Labels label = Labels.MY_LABEL;
        Node myNode = this.createNode((GraphDatabaseService)graphDatabase, label);
        try (Transaction tx = graphDatabase.beginTx();){
            myNode.removeLabel((Label)label);
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx((GraphDatabaseService)graphDatabase, Neo4jMatchers.hasLabel(label))));
    }

    @Test
    public void createNodeWithLabels() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        Node node = null;
        try (Transaction tx = db.beginTx();){
            node = db.createNode((Label[])Labels.values());
            tx.success();
        }
        Set<String> names = Stream.of(Labels.values()).map(Enum::name).collect(Collectors.toSet());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasLabels(names)));
    }

    @Test
    public void removingNonExistentLabel() throws Exception {
        Node myNode;
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        Labels label = Labels.MY_LABEL;
        try (Transaction tx = beansAPI.beginTx();){
            myNode = beansAPI.createNode();
            myNode.removeLabel((Label)label);
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasLabel(label))));
    }

    @Test
    public void removingExistingLabelFromUnlabeledNode() throws Exception {
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        Labels label = Labels.MY_LABEL;
        this.createNode((GraphDatabaseService)beansAPI, label);
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, new Label[0]);
        try (Transaction tx = beansAPI.beginTx();){
            myNode.removeLabel((Label)label);
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasLabel(label))));
    }

    @Test
    public void removingUncommittedLabel() throws Exception {
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        Labels label = Labels.MY_LABEL;
        try (Transaction tx = beansAPI.beginTx();){
            Node myNode = beansAPI.createNode();
            myNode.addLabel((Label)label);
            myNode.removeLabel((Label)label);
            Assert.assertFalse((boolean)myNode.hasLabel((Label)label));
            tx.success();
        }
    }

    @Test
    public void shouldBeAbleToListLabelsForANode() throws Exception {
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        Node node = null;
        Set expected = Iterators.asSet((Object[])new String[]{Labels.MY_LABEL.name(), Labels.MY_OTHER_LABEL.name()});
        try (Transaction tx = beansAPI.beginTx();){
            node = beansAPI.createNode();
            for (String label : expected) {
                node.addLabel(Label.label((String)label));
            }
            tx.success();
        }
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasLabels(expected)));
    }

    @Test
    public void shouldReturnEmptyListIfNoLabels() throws Exception {
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        Node node = this.createNode((GraphDatabaseService)beansAPI, new Label[0]);
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasNoLabels()));
    }

    @Test
    public void getNodesWithLabelCommitted() throws Exception {
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        Node node = null;
        try (Transaction tx = beansAPI.beginTx();){
            node = beansAPI.createNode();
            node.addLabel((Label)Labels.MY_LABEL);
            tx.success();
        }
        Assert.assertThat((Object)beansAPI, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasNodes(Labels.MY_LABEL, node)));
        Assert.assertThat((Object)beansAPI, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasNoNodes(Labels.MY_OTHER_LABEL)));
    }

    @Test
    public void getNodesWithLabelsWithTxAddsAndRemoves() throws Exception {
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        Node node1 = this.createNode((GraphDatabaseService)beansAPI, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        Node node2 = this.createNode((GraphDatabaseService)beansAPI, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        Node node3 = null;
        Set nodesWithMyLabel = null;
        Set nodesWithMyOtherLabel = null;
        try (Transaction tx = beansAPI.beginTx();){
            node3 = beansAPI.createNode(new Label[]{Labels.MY_LABEL});
            node2.removeLabel((Label)Labels.MY_LABEL);
            nodesWithMyLabel = Iterators.asSet((Iterator)beansAPI.findNodes((Label)Labels.MY_LABEL));
            nodesWithMyOtherLabel = Iterators.asSet((Iterator)beansAPI.findNodes((Label)Labels.MY_OTHER_LABEL));
            tx.success();
        }
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node3}), (Object)nodesWithMyLabel);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node2}), (Object)nodesWithMyOtherLabel);
    }

    @Test
    public void shouldListAllExistingLabels() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createNode((GraphDatabaseService)db, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        List labels = null;
        try (Transaction tx = db.beginTx();){
            labels = Iterables.asList((Iterable)db.getAllLabels());
        }
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertThat((Object)Iterables.map(Label::name, (Iterable)labels), (Matcher)Matchers.hasItems((Object[])new String[]{Labels.MY_LABEL.name(), Labels.MY_OTHER_LABEL.name()}));
    }

    @Test
    public void shouldListAllLabelsInUse() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createNode((GraphDatabaseService)db, Labels.MY_LABEL);
        Node node = this.createNode((GraphDatabaseService)db, Labels.MY_OTHER_LABEL);
        try (Transaction tx = db.beginTx();){
            node.delete();
            tx.success();
        }
        List labels = null;
        try (Transaction tx = db.beginTx();){
            labels = Iterables.asList((Iterable)db.getAllLabelsInUse());
        }
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertThat((Object)Iterables.map(Label::name, (Iterable)labels), (Matcher)Matchers.hasItems((Object[])new String[]{Labels.MY_LABEL.name()}));
    }

    @Test
    public void deleteAllNodesAndTheirLabels() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        Label label = Label.label((String)"A");
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.addLabel(label);
            node.setProperty("name", (Object)"bla");
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            for (Node node : db.getAllNodes()) {
                node.removeLabel(label);
                node.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var4_4 = null;
        try (Transaction transaction = db.beginTx();){
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)db.getAllNodes()));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void removingLabelDoesNotBreakPreviouslyCreatedLabelsIterator() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        Label label1 = Label.label((String)"A");
        Label label2 = Label.label((String)"B");
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{label1, label2});
            for (Label next : node.getLabels()) {
                node.removeLabel(next);
            }
            tx.success();
        }
    }

    @Test
    public void removingPropertyDoesNotBreakPreviouslyCreatedNodePropertyKeysIterator() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("name", (Object)"Horst");
            node.setProperty("age", (Object)"72");
            Iterator iterator = node.getPropertyKeys().iterator();
            while (iterator.hasNext()) {
                node.removeProperty((String)iterator.next());
            }
            tx.success();
        }
    }

    @Test
    public void shouldCreateNodeWithLotsOfLabelsAndThenRemoveMostOfThem() throws Exception {
        int i;
        Node node;
        int TOTAL_NUMBER_OF_LABELS = 200;
        int NUMBER_OF_PRESERVED_LABELS = 20;
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            node = db.createNode();
            for (i = 0; i < 200; ++i) {
                node.addLabel(Label.label((String)("label:" + i)));
            }
            tx.success();
        }
        tx = db.beginTx();
        var6_5 = null;
        try {
            for (i = 20; i < 200; ++i) {
                node.removeLabel(Label.label((String)("label:" + i)));
            }
            tx.success();
        }
        catch (Throwable i2) {
            var6_5 = i2;
            throw i2;
        }
        finally {
            if (tx != null) {
                if (var6_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable i2) {
                        var6_5.addSuppressed(i2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_5 = null;
        try (Transaction transaction = db.beginTx();){
            ArrayList<String> labels = new ArrayList<String>();
            for (Label label : node.getLabels()) {
                labels.add(label.name());
            }
            Assert.assertEquals((String)("labels on node: " + labels), (long)20L, (long)labels.size());
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldAllowManyLabelsAndPropertyCursor() throws Exception {
        Node node;
        int propertyCount = 10;
        int labelCount = 15;
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            int i;
            node = db.createNode();
            for (i = 0; i < propertyCount; ++i) {
                node.setProperty("foo" + i, (Object)"bar");
            }
            for (i = 0; i < labelCount; ++i) {
                node.addLabel(Label.label((String)("label" + i)));
            }
            tx.success();
        }
        HashSet<Integer> seenProperties = new HashSet<Integer>();
        HashSet seenLabels = new HashSet();
        try (Transaction tx = db.beginTx();){
            DependencyResolver resolver = db.getDependencyResolver();
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)resolver.resolveDependency(ThreadToStatementContextBridge.class);
            try (Statement statement = bridge.getTopLevelTransactionBoundToThisThread(true).acquireStatement();
                 Cursor nodeCursor = statement.readOperations().nodeCursorById(node.getId());
                 Cursor properties = statement.readOperations().nodeGetProperties((NodeItem)nodeCursor.get());){
                while (properties.next()) {
                    seenProperties.add(((PropertyItem)properties.get()).propertyKeyId());
                    PrimitiveIntCollections.consume((PrimitiveIntIterator)((NodeItem)nodeCursor.get()).labels().iterator(), seenLabels::add);
                }
            }
            tx.success();
        }
        Assert.assertEquals((long)propertyCount, (long)seenProperties.size());
        Assert.assertEquals((long)labelCount, (long)seenLabels.size());
    }

    @Test
    public void nodeWithManyLabels() {
        int labels = 500;
        int halveLabels = labels / 2;
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        long nodeId = this.createNode((GraphDatabaseService)db, new Label[0]).getId();
        this.addLabels(nodeId, 0, halveLabels);
        this.addLabels(nodeId, halveLabels, halveLabels);
        this.verifyLabels(nodeId, 0, labels);
        this.removeLabels(nodeId, halveLabels, halveLabels);
        this.verifyLabels(nodeId, 0, halveLabels);
        this.removeLabels(nodeId, 0, halveLabels - 2);
        this.verifyLabels(nodeId, halveLabels - 2, 2);
    }

    private void addLabels(long nodeId, int startLabelIndex, int count) {
        try (Transaction tx = this.dbRule.beginTx();){
            Node node = this.dbRule.getNodeById(nodeId);
            int endLabelIndex = startLabelIndex + count;
            for (int i = startLabelIndex; i < endLabelIndex; ++i) {
                node.addLabel(LabelsAcceptanceTest.labelWithIndex(i));
            }
            tx.success();
        }
    }

    private void verifyLabels(long nodeId, int startLabelIndex, int count) {
        try (Transaction tx = this.dbRule.beginTx();){
            Node node = this.dbRule.getNodeById(nodeId);
            Set labelNames = Iterables.asList((Iterable)node.getLabels()).stream().map(Label::name).sorted().collect(Collectors.toSet());
            Assert.assertEquals((long)count, (long)labelNames.size());
            int endLabelIndex = startLabelIndex + count;
            for (int i = startLabelIndex; i < endLabelIndex; ++i) {
                Assert.assertTrue((boolean)labelNames.contains(LabelsAcceptanceTest.labelName(i)));
            }
            tx.success();
        }
    }

    private void removeLabels(long nodeId, int startLabelIndex, int count) {
        try (Transaction tx = this.dbRule.beginTx();){
            Node node = this.dbRule.getNodeById(nodeId);
            int endLabelIndex = startLabelIndex + count;
            for (int i = startLabelIndex; i < endLabelIndex; ++i) {
                node.removeLabel(LabelsAcceptanceTest.labelWithIndex(i));
            }
            tx.success();
        }
    }

    private static Label labelWithIndex(int index) {
        return Label.label((String)LabelsAcceptanceTest.labelName(index));
    }

    private static String labelName(int index) {
        return "Label-" + index;
    }

    private GraphDatabaseService beansAPIWithNoMoreLabelIds() {
        final EphemeralIdGenerator.Factory idFactory = new EphemeralIdGenerator.Factory(){
            private IdTypeConfigurationProvider idTypeConfigurationProvider = new CommunityIdTypeConfigurationProvider();

            @Override
            public IdGenerator open(File fileName, int grabSize, IdType idType, Supplier<Long> highId, long maxId) {
                if (idType == IdType.LABEL_TOKEN) {
                    IdGenerator generator = (IdGenerator)this.generators.get(idType);
                    if (generator == null) {
                        IdTypeConfiguration idTypeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
                        generator = new EphemeralIdGenerator(idType, idTypeConfiguration){

                            @Override
                            public long nextId() {
                                throw new UnderlyingStorageException("Id capacity exceeded");
                            }
                        };
                        this.generators.put(idType, generator);
                    }
                    return generator;
                }
                return super.open(fileName, grabSize, idType, () -> Long.MAX_VALUE, Long.MAX_VALUE);
            }
        };
        TestGraphDatabaseFactory dbFactory = new TestGraphDatabaseFactory(){

            @Override
            protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final File storeDir, final TestGraphDatabaseFactoryState state) {
                return new GraphDatabaseBuilder.DatabaseCreator(){

                    public GraphDatabaseService newDatabase(Map<String, String> config) {
                        return this.newDatabase(Config.embeddedDefaults(config));
                    }

                    public GraphDatabaseService newDatabase(@Nonnull Config config) {
                        return new ImpermanentGraphDatabase(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies())){

                            protected void create(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                                Function<PlatformModule, EditionModule> factory = platformModule -> new CommunityEditionModule((PlatformModule)platformModule){

                                    protected IdGeneratorFactory createIdGeneratorFactory(FileSystemAbstraction fs, IdTypeConfigurationProvider idTypeConfigurationProvider) {
                                        return idFactory;
                                    }
                                };
                                new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, factory){

                                    protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                                        return new ImpermanentGraphDatabase.ImpermanentPlatformModule(storeDir, config, this.databaseInfo, dependencies, graphDatabaseFacade);
                                    }
                                }.initFacade(storeDir, config, dependencies, (GraphDatabaseFacade)this);
                            }
                        };
                    }
                };
            }
        };
        return dbFactory.newImpermanentDatabase();
    }

    private Node createNode(GraphDatabaseService db, Label ... labels) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(labels);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private static enum Labels implements Label
    {
        MY_LABEL,
        MY_OTHER_LABEL;

    }
}

