/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public abstract class CompositeIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public CompositeIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Test
    public void testIndexSeekAndScanByString() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a", "a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"b", "b"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a", "b"})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)"a"), IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)"b"), IndexQuery.exact((int)1, (Object)"b")}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)"a"), IndexQuery.exact((int)1, (Object)"b")}), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
    }

    @Test
    public void testIndexSeekAndScanByNumber() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{333, 333}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{101, 101}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{333, 101})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)333), IndexQuery.exact((int)1, (Object)333)}), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)101), IndexQuery.exact((int)1, (Object)101)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)333), IndexQuery.exact((int)1, (Object)101)}), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends CompositeIndexAccessorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a", "a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a", "a"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)"a"), IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends CompositeIndexAccessorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void testDuplicatesInIndexSeekByString() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a", "a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a", "a"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)"a"), IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }

        @Test
        public void testDuplicatesInIndexSeekByNumber() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{333, 333}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{333, 333})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)333), IndexQuery.exact((int)1, (Object)333)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }
    }
}

