/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.OrderedPropertyValues;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class CompositeIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public CompositeIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends CompositeIndexPopulatorCompatibility {
        String value1 = "value1";
        String value2 = "value2";
        String value3 = "value3";
        int nodeId1 = 3;
        int nodeId2 = 4;

        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void shouldEnforceUniqueConstraintsDirectly() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
            IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
            populator.create();
            populator.add(Arrays.asList(IndexEntryUpdate.add((long)this.nodeId1, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{this.value1, this.value2}), IndexEntryUpdate.add((long)this.nodeId2, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{this.value1, this.value2})));
            try {
                NodePropertyAccessor propertyAccessor = new NodePropertyAccessor(this.nodeId1, this.descriptor.schema(), this.value1, this.value2);
                propertyAccessor.addNode(this.nodeId2, this.descriptor.schema(), this.value1, this.value2);
                populator.verifyDeferredConstraints((PropertyAccessor)propertyAccessor);
                Assert.fail((String)"expected exception");
            }
            catch (IndexEntryConflictException conflict) {
                Assert.assertEquals((long)this.nodeId1, (long)conflict.getExistingNodeId());
                Assert.assertEquals((Object)OrderedPropertyValues.ofUndefined((Object[])new Object[]{this.value1, this.value2}), (Object)conflict.getPropertyValues());
                Assert.assertEquals((long)this.nodeId2, (long)conflict.getAddedNodeId());
            }
        }

        @Test
        public void shouldNotRestrictUpdatesDifferingOnSecondProperty() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
            IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
            populator.create();
            populator.add(Arrays.asList(IndexEntryUpdate.add((long)this.nodeId1, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{this.value1, this.value2}), IndexEntryUpdate.add((long)this.nodeId2, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{this.value1, this.value3})));
            NodePropertyAccessor propertyAccessor = new NodePropertyAccessor(this.nodeId1, this.descriptor.schema(), this.value1, this.value2);
            propertyAccessor.addNode(this.nodeId2, this.descriptor.schema(), this.value1, this.value3);
            populator.verifyDeferredConstraints((PropertyAccessor)propertyAccessor);
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends CompositeIndexPopulatorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
            IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
            populator.create();
            populator.add(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"v1", "v2"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"v1", "v2"})));
            populator.close(true);
            IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, this.descriptor, indexSamplingConfig);
            try (IndexReader reader = accessor.newReader();){
                PrimitiveLongIterator nodes = reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"v1"), IndexQuery.exact((int)1, (Object)"v2")});
                Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes));
            }
            accessor.close();
        }
    }
}

