/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;

public class IndexEntryUpdateTest {
    private final Object[] multiValue = new Object[]{"value", "value2"};
    private final String singleValue = "value";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void indexEntryUpdatesShouldBeEqual() {
        IndexEntryUpdate a = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{"hi"});
        IndexEntryUpdate b = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{"hi"});
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)a.hashCode(), (Matcher)Matchers.equalTo((Object)b.hashCode()));
    }

    @Test
    public void addShouldRetainValues() {
        IndexEntryUpdate single = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{"value"});
        IndexEntryUpdate multi = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4, 5}), (Object[])this.multiValue);
        MatcherAssert.assertThat((Object)single, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)multi)));
        MatcherAssert.assertThat((Object)single.values(), (Matcher)Matchers.equalTo((Object)new Object[]{"value"}));
        MatcherAssert.assertThat((Object)multi.values(), (Matcher)Matchers.equalTo((Object)this.multiValue));
    }

    @Test
    public void removeShouldRetainValues() {
        IndexEntryUpdate single = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{"value"});
        IndexEntryUpdate multi = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4, 5}), (Object[])this.multiValue);
        MatcherAssert.assertThat((Object)single, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)multi)));
        MatcherAssert.assertThat((Object)single.values(), (Matcher)Matchers.equalTo((Object)new Object[]{"value"}));
        MatcherAssert.assertThat((Object)multi.values(), (Matcher)Matchers.equalTo((Object)this.multiValue));
    }

    @Test
    public void addShouldThrowIfAskedForChanged() throws Exception {
        IndexEntryUpdate single = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{"value"});
        this.thrown.expect(UnsupportedOperationException.class);
        single.beforeValues();
    }

    @Test
    public void removeShouldThrowIfAskedForChanged() throws Exception {
        IndexEntryUpdate single = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{"value"});
        this.thrown.expect(UnsupportedOperationException.class);
        single.beforeValues();
    }

    @Test
    public void updatesShouldEqualRegardlessOfCreationMethod() {
        IndexEntryUpdate singleAdd = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{"value"});
        Object[] singleAsArray = new Object[]{"value"};
        IndexEntryUpdate multiAdd = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])singleAsArray);
        IndexEntryUpdate singleRemove = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{"value"});
        IndexEntryUpdate multiRemove = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])singleAsArray);
        IndexEntryUpdate singleChange = IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object)"value", (Object)"value");
        IndexEntryUpdate multiChange = IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])singleAsArray, (Object[])singleAsArray);
        MatcherAssert.assertThat((Object)singleAdd, (Matcher)Matchers.equalTo((Object)multiAdd));
        MatcherAssert.assertThat((Object)singleRemove, (Matcher)Matchers.equalTo((Object)multiRemove));
        MatcherAssert.assertThat((Object)singleChange, (Matcher)Matchers.equalTo((Object)multiChange));
    }

    @Test
    public void changedShouldRetainValues() throws Exception {
        String singleAfter = "Hello";
        IndexEntryUpdate singleChange = IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object)"value", (Object)singleAfter);
        Object[] multiAfter = new Object[]{"Hello", "Hi"};
        IndexEntryUpdate multiChange = IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4, 5}), (Object[])this.multiValue, (Object[])multiAfter);
        MatcherAssert.assertThat((Object)new Object[]{"value"}, (Matcher)Matchers.equalTo((Object)singleChange.beforeValues()));
        MatcherAssert.assertThat((Object)new Object[]{singleAfter}, (Matcher)Matchers.equalTo((Object)singleChange.values()));
        MatcherAssert.assertThat((Object)this.multiValue, (Matcher)Matchers.equalTo((Object)multiChange.beforeValues()));
        MatcherAssert.assertThat((Object)multiAfter, (Matcher)Matchers.equalTo((Object)multiChange.values()));
    }

    @Test
    public void indexEntryUpdatesShouldBeEqualForDeepValues() {
        Object[] value1 = this.arraysOfDepth(13);
        Object[] value2 = this.arraysOfDepth(13);
        IndexEntryUpdate a = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{value1});
        IndexEntryUpdate b = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Object[])new Object[]{value2});
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)a.hashCode(), (Matcher)Matchers.equalTo((Object)b.hashCode()));
    }

    private Object[] arraysOfDepth(int n) {
        Object[] objectArray;
        if (n == 0) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "hej";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = this.arraysOfDepth(n - 1);
        }
        return objectArray;
    }
}

