/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public abstract class SimpleIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public SimpleIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Test
    public void testIndexSeekByNumber() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{-5}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{0}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{5.5}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{10.0}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{100.0})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)0, (boolean)true, (Number)10, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(2L, 3L, 4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)10, (boolean)true, null, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(4L, 5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)100, (boolean)true, (Number)0, (boolean)true)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, null, (boolean)true, (Number)5.5, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)null, (boolean)true, null, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)0, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)5.5, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
    }

    @Test
    public void testIndexSeekByString() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"Anabelle"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"Anna"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"Bob"}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"Harriet"}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"William"})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)true, (String)"Harriet", (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(2L, 3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Harriet", (boolean)true, null, (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(4L, 5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Harriet", (boolean)false, null, (boolean)true)}), (Matcher)Matchers.equalTo(Collections.singletonList(5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"William", (boolean)false, (String)"Anna", (boolean)true)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, null, (boolean)false, (String)"Bob", (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, null, (boolean)true, (String)"Bob", (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)null, (boolean)true, null, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anabelle", (boolean)false, (String)"Anna", (boolean)true)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anabelle", (boolean)false, (String)"Bob", (boolean)false)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
    }

    @Test
    public void testIndexSeekByPrefix() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"A"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apA"}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"b"})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"A")}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"ba")}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
    }

    @Test
    public void testIndexSeekByPrefixOnNonStrings() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{2L})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"2")}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends SimpleIndexAccessorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }

        @Test
        public void testIndexSeekAndScan() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"b"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"c"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends SimpleIndexAccessorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }

        @Test
        public void testIndexSeekAndScan() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"b"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        }

        @Test
        public void testIndexRangeSeekByNumberWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{-5}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{-5}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{0}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{5}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{5})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)5, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-3, (boolean)true, (Number)-1, (boolean)true)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)4, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-4, (boolean)true, (Number)5, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)5, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        }

        @Test
        public void testIndexRangeSeekByStringWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"Anna"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"Anna"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"Bob"}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"William"}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"William"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)false, (String)"William", (boolean)false)}), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Arabella", (boolean)false, (String)"Bob", (boolean)false)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)true, (String)"William", (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)false, (String)"William", (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)true, (String)"William", (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        }

        @Test
        public void testIndexRangeSeekByPrefixWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"A"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apa"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"apa")}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
        }

        @Test
        public void testIndexFullSearchWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"A"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apalong"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringContains((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringContains((int)1, (String)"apa")}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringContains((int)1, (String)"apa*")}), (Matcher)Matchers.equalTo(Collections.emptyList()));
        }

        @Test
        public void testIndexEndsWithWithDuplicated() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"A"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"longapa"}), IndexEntryUpdate.add((long)6L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"apalong"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringSuffix((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringSuffix((int)1, (String)"apa")}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringSuffix((int)1, (String)"apa*")}), (Matcher)Matchers.equalTo(Collections.emptyList()));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringSuffix((int)1, (String)"")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L)));
        }
    }
}

